/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.endpointdiscovery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.cache.EndpointDiscoveryCacheLoader;
import com.amazonaws.endpointdiscovery.DaemonThreadFactory;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public abstract class EndpointDiscoveryIdentifiersRefreshCache<K> {
    private static final Log log = LogFactory.getLog(EndpointDiscoveryIdentifiersRefreshCache.class);
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(DaemonThreadFactory.INSTANCE);
    private final EndpointDiscoveryCacheLoader<String, Map<String, String>> cacheLoader;
    protected final Map<String, URI> cache = new ConcurrentHashMap<String, URI>();

    public EndpointDiscoveryIdentifiersRefreshCache(EndpointDiscoveryCacheLoader endpointDiscoveryCacheLoader) {
        this.cacheLoader = endpointDiscoveryCacheLoader;
    }

    public abstract URI get(K var1, AmazonWebServiceRequest var2, boolean var3, URI var4);

    public abstract URI put(String var1, AmazonWebServiceRequest var2, Map<String, String> var3, URI var4);

    public abstract String constructKey(String var1, AmazonWebServiceRequest var2);

    public void evict(String string) {
        this.cache.remove(string);
    }

    public URI discoverEndpoint(String string, AmazonWebServiceRequest amazonWebServiceRequest, boolean bl, URI uRI) {
        if (bl) {
            try {
                return this.put(string, amazonWebServiceRequest, this.cacheLoader.load(string, amazonWebServiceRequest), uRI);
            }
            catch (Exception exception) {
                throw new SdkClientException("Unable to discover required endpoint for request.", exception);
            }
        }
        this.loadAndScheduleRefresh(string, amazonWebServiceRequest, 1L, uRI);
        return uRI;
    }

    public ScheduledFuture<URI> loadAndScheduleRefresh(final String string, final AmazonWebServiceRequest amazonWebServiceRequest, long l, final URI uRI) {
        return this.executorService.schedule(new Callable<URI>(){

            @Override
            public URI call() {
                try {
                    return EndpointDiscoveryIdentifiersRefreshCache.this.put(string, amazonWebServiceRequest, (Map)EndpointDiscoveryIdentifiersRefreshCache.this.cacheLoader.load(string, amazonWebServiceRequest), uRI);
                }
                catch (Exception exception) {
                    log.debug("Failed to refresh cached endpoint. Scheduling another refresh in 5 minutes");
                    EndpointDiscoveryIdentifiersRefreshCache.this.loadAndScheduleRefresh(string, amazonWebServiceRequest, 5L, uRI);
                    return null;
                }
            }
        }, l, TimeUnit.MINUTES);
    }

    public ScheduledFuture<?> loadAndScheduleEvict(final String string, long l, TimeUnit timeUnit) {
        return this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                EndpointDiscoveryIdentifiersRefreshCache.this.evict(string);
            }
        }, l, timeUnit);
    }

    public void shutdown() {
        this.executorService.shutdownNow();
    }
}

