/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.util.PolicyUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonPolicyWriter {
    private JsonGenerator generator = null;
    private Writer writer = new StringWriter();
    private static final Log log = LogFactory.getLog("com.amazonaws.auth.policy");

    public JsonPolicyWriter() {
        try {
            this.generator = Jackson.jsonGeneratorOf(this.writer);
        }
        catch (IOException iOException) {
            throw new SdkClientException("Unable to instantiate JsonGenerator.", iOException);
        }
    }

    public String writePolicyToString(Policy policy) {
        if (!this.isNotNull(policy)) {
            throw new IllegalArgumentException("Policy cannot be null");
        }
        try {
            String string = this.jsonStringOf(policy);
            return string;
        }
        catch (Exception exception) {
            String string = "Unable to serialize policy to JSON string: " + exception.getMessage();
            throw new IllegalArgumentException(string, exception);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private String jsonStringOf(Policy policy) throws JsonGenerationException, IOException {
        this.generator.writeStartObject();
        this.writeJsonKeyValue("Version", policy.getVersion());
        if (this.isNotNull(policy.getId())) {
            this.writeJsonKeyValue("Id", policy.getId());
        }
        this.writeJsonArrayStart("Statement");
        for (Statement statement : policy.getStatements()) {
            List<Condition> list;
            List<Resource> list2;
            List<Action> list3;
            this.generator.writeStartObject();
            if (this.isNotNull(statement.getId())) {
                this.writeJsonKeyValue("Sid", statement.getId());
            }
            this.writeJsonKeyValue("Effect", statement.getEffect().toString());
            List<Principal> list4 = statement.getPrincipals();
            if (this.isNotNull(list4) && !list4.isEmpty()) {
                this.writePrincipals(list4);
            }
            if (this.isNotNull(list3 = statement.getActions()) && !list3.isEmpty()) {
                this.writeActions(list3);
            }
            if (this.isNotNull(list2 = statement.getResources()) && !list2.isEmpty()) {
                this.writeResources(list2);
            }
            if (this.isNotNull(list = statement.getConditions()) && !list.isEmpty()) {
                this.writeConditions(list);
            }
            this.generator.writeEndObject();
        }
        this.writeJsonArrayEnd();
        this.generator.writeEndObject();
        this.generator.flush();
        return this.writer.toString();
    }

    private void writeConditions(List<Condition> list) throws JsonGenerationException, IOException {
        Map<String, ConditionsByKey> map = this.groupConditionsByTypeAndKey(list);
        this.writeJsonObjectStart("Condition");
        for (Map.Entry<String, ConditionsByKey> entry : map.entrySet()) {
            ConditionsByKey conditionsByKey = map.get(entry.getKey());
            this.writeJsonObjectStart(entry.getKey());
            for (String string : conditionsByKey.keySet()) {
                this.writeJsonArray(string, conditionsByKey.getConditionsByKey(string));
            }
            this.writeJsonObjectEnd();
        }
        this.writeJsonObjectEnd();
    }

    private void writeResources(List<Resource> list) throws JsonGenerationException, IOException {
        PolicyUtils.validateResourceList(list);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Resource resource : list) {
            arrayList.add(resource.getId());
        }
        if (list.get(0).isNotType()) {
            this.writeJsonArray("NotResource", arrayList);
        } else {
            this.writeJsonArray("Resource", arrayList);
        }
    }

    private void writeActions(List<Action> list) throws JsonGenerationException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Action action : list) {
            arrayList.add(action.getActionName());
        }
        this.writeJsonArray("Action", arrayList);
    }

    private void writePrincipals(List<Principal> list) throws JsonGenerationException, IOException {
        if (list.size() == 1 && list.get(0).equals(Principal.All)) {
            this.writeJsonKeyValue("Principal", Principal.All.getId());
        } else {
            this.writeJsonObjectStart("Principal");
            Map<String, List<String>> map = this.groupPrincipalByScheme(list);
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                List<String> list2 = map.get(entry.getKey());
                if (list2.size() == 1) {
                    this.writeJsonKeyValue(entry.getKey(), list2.get(0));
                    continue;
                }
                this.writeJsonArray(entry.getKey(), list2);
            }
            this.writeJsonObjectEnd();
        }
    }

    private Map<String, List<String>> groupPrincipalByScheme(List<Principal> list) {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        for (Principal principal : list) {
            String string = principal.getProvider();
            if (!linkedHashMap.containsKey(string)) {
                linkedHashMap.put(string, new ArrayList());
            }
            List list2 = (List)linkedHashMap.get(string);
            list2.add(principal.getId());
        }
        return linkedHashMap;
    }

    private Map<String, ConditionsByKey> groupConditionsByTypeAndKey(List<Condition> list) {
        LinkedHashMap<String, ConditionsByKey> linkedHashMap = new LinkedHashMap<String, ConditionsByKey>();
        for (Condition condition : list) {
            String string = condition.getType();
            String string2 = condition.getConditionKey();
            if (!linkedHashMap.containsKey(string)) {
                linkedHashMap.put(string, new ConditionsByKey());
            }
            ConditionsByKey conditionsByKey = (ConditionsByKey)linkedHashMap.get(string);
            conditionsByKey.addValuesToKey(string2, condition.getValues());
        }
        return linkedHashMap;
    }

    private void writeJsonArray(String string, List<String> list) throws JsonGenerationException, IOException {
        this.writeJsonArrayStart(string);
        for (String string2 : list) {
            this.generator.writeString(string2);
        }
        this.writeJsonArrayEnd();
    }

    private void writeJsonObjectStart(String string) throws JsonGenerationException, IOException {
        this.generator.writeObjectFieldStart(string);
    }

    private void writeJsonObjectEnd() throws JsonGenerationException, IOException {
        this.generator.writeEndObject();
    }

    private void writeJsonArrayStart(String string) throws JsonGenerationException, IOException {
        this.generator.writeArrayFieldStart(string);
    }

    private void writeJsonArrayEnd() throws JsonGenerationException, IOException {
        this.generator.writeEndArray();
    }

    private void writeJsonKeyValue(String string, String string2) throws JsonGenerationException, IOException {
        this.generator.writeStringField(string, string2);
    }

    private boolean isNotNull(Object object) {
        return null != object;
    }

    static class ConditionsByKey {
        private Map<String, List<String>> conditionsByKey = new LinkedHashMap<String, List<String>>();

        public Map<String, List<String>> getConditionsByKey() {
            return this.conditionsByKey;
        }

        public void setConditionsByKey(Map<String, List<String>> map) {
            this.conditionsByKey = map;
        }

        public boolean containsKey(String string) {
            return this.conditionsByKey.containsKey(string);
        }

        public List<String> getConditionsByKey(String string) {
            return this.conditionsByKey.get(string);
        }

        public Set<String> keySet() {
            return this.conditionsByKey.keySet();
        }

        public void addValuesToKey(String string, List<String> list) {
            List<String> list2 = this.getConditionsByKey(string);
            if (list2 == null) {
                this.conditionsByKey.put(string, new ArrayList<String>(list));
            } else {
                list2.addAll(list);
            }
        }
    }
}

