/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.PolicyReaderOptions;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonPolicyReader {
    private static final String PRINCIPAL_SCHEMA_USER = "AWS";
    private static final String PRINCIPAL_SCHEMA_SERVICE = "Service";
    private static final String PRINCIPAL_SCHEMA_FEDERATED = "Federated";
    private final PolicyReaderOptions options;

    public JsonPolicyReader() {
        this(new PolicyReaderOptions());
    }

    public JsonPolicyReader(PolicyReaderOptions policyReaderOptions) {
        this.options = policyReaderOptions;
    }

    public Policy createPolicyFromJsonString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("JSON string cannot be null");
        }
        Policy policy = new Policy();
        LinkedList<Statement> linkedList = new LinkedList<Statement>();
        try {
            JsonNode jsonNode;
            JsonNode jsonNode2 = Jackson.jsonNodeOf(string);
            JsonNode jsonNode3 = jsonNode2.get("Id");
            if (this.isNotNull(jsonNode3)) {
                policy.setId(jsonNode3.asText());
            }
            if (this.isNotNull(jsonNode = jsonNode2.get("Statement"))) {
                if (jsonNode.isObject()) {
                    linkedList.add(this.statementOf(jsonNode));
                } else if (jsonNode.isArray()) {
                    for (JsonNode jsonNode4 : jsonNode) {
                        linkedList.add(this.statementOf(jsonNode4));
                    }
                }
            }
        }
        catch (Exception exception) {
            String string2 = "Unable to generate policy object fron JSON string " + exception.getMessage();
            throw new IllegalArgumentException(string2, exception);
        }
        policy.setStatements(linkedList);
        return policy;
    }

    private Statement statementOf(JsonNode jsonNode) {
        JsonNode jsonNode2;
        JsonNode jsonNode3;
        JsonNode jsonNode4;
        JsonNode jsonNode5;
        JsonNode jsonNode6 = jsonNode.get("Effect");
        Statement.Effect effect = this.isNotNull(jsonNode6) ? Statement.Effect.valueOf(jsonNode6.asText()) : Statement.Effect.Deny;
        Statement statement = new Statement(effect);
        JsonNode jsonNode7 = jsonNode.get("Sid");
        if (this.isNotNull(jsonNode7)) {
            statement.setId(jsonNode7.asText());
        }
        if (this.isNotNull(jsonNode5 = jsonNode.get("Action"))) {
            statement.setActions(this.actionsOf(jsonNode5));
        }
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        JsonNode jsonNode8 = jsonNode.get("Resource");
        if (this.isNotNull(jsonNode8)) {
            linkedList.addAll(this.resourcesOf(jsonNode8, false));
        }
        if (this.isNotNull(jsonNode4 = jsonNode.get("NotResource"))) {
            linkedList.addAll(this.resourcesOf(jsonNode4, true));
        }
        if (!linkedList.isEmpty()) {
            statement.setResources(linkedList);
        }
        if (this.isNotNull(jsonNode3 = jsonNode.get("Condition"))) {
            statement.setConditions(this.conditionsOf(jsonNode3));
        }
        if (this.isNotNull(jsonNode2 = jsonNode.get("Principal"))) {
            statement.setPrincipals(this.principalOf(jsonNode2));
        }
        return statement;
    }

    private List<Action> actionsOf(JsonNode jsonNode) {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        if (jsonNode.isArray()) {
            for (JsonNode jsonNode2 : jsonNode) {
                linkedList.add(new NamedAction(jsonNode2.asText()));
            }
        } else {
            linkedList.add(new NamedAction(jsonNode.asText()));
        }
        return linkedList;
    }

    private List<Resource> resourcesOf(JsonNode jsonNode, boolean bl) {
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        if (jsonNode.isArray()) {
            for (JsonNode jsonNode2 : jsonNode) {
                linkedList.add(new Resource(jsonNode2.asText()).withIsNotType(bl));
            }
        } else {
            linkedList.add(new Resource(jsonNode.asText()).withIsNotType(bl));
        }
        return linkedList;
    }

    private List<Principal> principalOf(JsonNode jsonNode) {
        LinkedList<Principal> linkedList = new LinkedList<Principal>();
        if (jsonNode.asText().equals("*")) {
            linkedList.add(Principal.All);
            return linkedList;
        }
        Iterator<Map.Entry<String, JsonNode>> iterator2 = jsonNode.fields();
        while (iterator2.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator2.next();
            String string = entry.getKey();
            JsonNode jsonNode2 = entry.getValue();
            if (jsonNode2.isArray()) {
                Iterator<JsonNode> iterator3 = jsonNode2.elements();
                while (iterator3.hasNext()) {
                    linkedList.add(this.createPrincipal(string, iterator3.next()));
                }
                continue;
            }
            linkedList.add(this.createPrincipal(string, jsonNode2));
        }
        return linkedList;
    }

    private Principal createPrincipal(String string, JsonNode jsonNode) {
        if (string.equalsIgnoreCase(PRINCIPAL_SCHEMA_USER)) {
            return new Principal(PRINCIPAL_SCHEMA_USER, jsonNode.asText(), this.options.isStripAwsPrincipalIdHyphensEnabled());
        }
        if (string.equalsIgnoreCase(PRINCIPAL_SCHEMA_SERVICE)) {
            return new Principal(string, jsonNode.asText());
        }
        if (string.equalsIgnoreCase(PRINCIPAL_SCHEMA_FEDERATED)) {
            if (Principal.WebIdentityProviders.fromString(jsonNode.asText()) != null) {
                return new Principal(Principal.WebIdentityProviders.fromString(jsonNode.asText()));
            }
            return new Principal(PRINCIPAL_SCHEMA_FEDERATED, jsonNode.asText());
        }
        throw new SdkClientException("Schema " + string + " is not a valid value for the principal.");
    }

    private List<Condition> conditionsOf(JsonNode jsonNode) {
        LinkedList<Condition> linkedList = new LinkedList<Condition>();
        Iterator<Map.Entry<String, JsonNode>> iterator2 = jsonNode.fields();
        while (iterator2.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator2.next();
            this.convertConditionRecord(linkedList, entry.getKey(), entry.getValue());
        }
        return linkedList;
    }

    private void convertConditionRecord(List<Condition> list, String string, JsonNode jsonNode) {
        Iterator<Map.Entry<String, JsonNode>> iterator2 = jsonNode.fields();
        while (iterator2.hasNext()) {
            LinkedList<String> linkedList = new LinkedList<String>();
            Map.Entry<String, JsonNode> entry = iterator2.next();
            JsonNode jsonNode2 = entry.getValue();
            if (jsonNode2.isArray()) {
                Iterator<JsonNode> iterator3 = jsonNode2.elements();
                while (iterator3.hasNext()) {
                    linkedList.add(iterator3.next().asText());
                }
            } else {
                linkedList.add(jsonNode2.asText());
            }
            list.add(new Condition().withType(string).withConditionKey(entry.getKey()).withValues(linkedList));
        }
    }

    private boolean isNotNull(Object object) {
        return null != object;
    }

    private static class NamedAction
    implements Action {
        private String actionName;

        public NamedAction(String string) {
            this.actionName = string;
        }

        @Override
        public String getActionName() {
            return this.actionName;
        }
    }
}

