/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.auth.BaseCredentialsFetcher;
import com.amazonaws.internal.EC2ResourceFetcher;
import com.amazonaws.internal.InstanceMetadataServiceResourceFetcher;
import com.amazonaws.retry.internal.CredentialsEndpointRetryParameters;
import com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import com.amazonaws.util.EC2MetadataUtils;
import java.net.URI;

@SdkInternalApi
final class InstanceMetadataServiceCredentialsFetcher
extends BaseCredentialsFetcher
implements CredentialsEndpointRetryPolicy {
    private final EC2ResourceFetcher resourceFetcher;

    InstanceMetadataServiceCredentialsFetcher() {
        super(true);
        this.resourceFetcher = InstanceMetadataServiceResourceFetcher.getInstance();
    }

    @SdkTestInternalApi
    InstanceMetadataServiceCredentialsFetcher(EC2ResourceFetcher eC2ResourceFetcher) {
        super(true);
        this.resourceFetcher = eC2ResourceFetcher;
    }

    @Override
    protected String getCredentialsResponse() {
        URI uRI = this.getCredentialsEndpoint();
        return this.resourceFetcher.readResource(uRI, this);
    }

    @Override
    public String toString() {
        return "InstanceMetadataServiceCredentialsFetcher";
    }

    private URI getCredentialsEndpoint() {
        String string = EC2MetadataUtils.getHostAddressForEC2MetadataService();
        String string2 = this.resourceFetcher.readResource(URI.create(string + "/latest/meta-data/iam/security-credentials/"), this);
        String[] stringArray = string2.trim().split("\n");
        if (stringArray.length == 0) {
            throw new SdkClientException("Unable to load credentials path");
        }
        return URI.create(string + "/latest/meta-data/iam/security-credentials/" + stringArray[0]);
    }

    @Override
    public boolean shouldRetry(int n, CredentialsEndpointRetryParameters credentialsEndpointRetryParameters) {
        return false;
    }
}

