/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.ReadLimitInfo;
import com.amazonaws.SdkClientException;
import com.amazonaws.SignableRequest;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.EndpointPrefixAwareSigner;
import com.amazonaws.auth.Presigner;
import com.amazonaws.auth.RegionAwareSigner;
import com.amazonaws.auth.RegionFromEndpointResolverAwareSigner;
import com.amazonaws.auth.SdkClock;
import com.amazonaws.auth.ServiceAwareSigner;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.auth.internal.AWS4SignerRequestParams;
import com.amazonaws.auth.internal.AWS4SignerUtils;
import com.amazonaws.auth.internal.SignerKey;
import com.amazonaws.internal.FIFOCache;
import com.amazonaws.log.InternalLogApi;
import com.amazonaws.log.InternalLogFactory;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.endpoint.RegionFromEndpointResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AWS4Signer
extends AbstractAWSSigner
implements EndpointPrefixAwareSigner,
Presigner,
RegionAwareSigner,
RegionFromEndpointResolverAwareSigner,
ServiceAwareSigner {
    protected static final InternalLogApi log = InternalLogFactory.getLog(AWS4Signer.class);
    private static final int SIGNER_CACHE_MAX_SIZE = 300;
    private static final FIFOCache<SignerKey> signerCache = new FIFOCache(300);
    private static final List<String> listOfHeadersToIgnoreInLowerCase = Arrays.asList("connection", "x-amzn-trace-id");
    private final SdkClock clock;
    protected String serviceName;
    private String endpointPrefix;
    private RegionFromEndpointResolver regionFromEndpointResolver;
    protected String regionName;
    protected Date overriddenDate;
    protected boolean doubleUrlEncode;

    public AWS4Signer() {
        this(true);
    }

    public AWS4Signer(boolean bl) {
        this(bl, SdkClock.Instance.get());
    }

    @SdkTestInternalApi
    public AWS4Signer(SdkClock sdkClock) {
        this(true, sdkClock);
    }

    private AWS4Signer(boolean bl, SdkClock sdkClock) {
        this.doubleUrlEncode = bl;
        this.clock = sdkClock;
    }

    @Override
    public void setServiceName(String string) {
        this.serviceName = string;
    }

    @Override
    public void setRegionName(String string) {
        this.regionName = string;
    }

    @Override
    public void setEndpointPrefix(String string) {
        this.endpointPrefix = string;
    }

    @SdkTestInternalApi
    public void setOverrideDate(Date date) {
        this.overriddenDate = date != null ? new Date(date.getTime()) : null;
    }

    @Override
    public void setRegionFromEndpointResolver(RegionFromEndpointResolver regionFromEndpointResolver) {
        this.regionFromEndpointResolver = regionFromEndpointResolver;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Date getOverriddenDate() {
        return this.overriddenDate == null ? null : new Date(this.overriddenDate.getTime());
    }

    @Override
    public void sign(SignableRequest<?> signableRequest, AWSCredentials aWSCredentials) {
        if (this.isAnonymous(aWSCredentials)) {
            return;
        }
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            this.addSessionCredentials(signableRequest, (AWSSessionCredentials)aWSCredentials2);
        }
        AWS4SignerRequestParams aWS4SignerRequestParams = new AWS4SignerRequestParams(signableRequest, this.overriddenDate, this.regionName, this.serviceName, "AWS4-HMAC-SHA256", this.endpointPrefix, this.regionFromEndpointResolver);
        this.addHostHeader(signableRequest);
        signableRequest.addHeader("X-Amz-Date", aWS4SignerRequestParams.getFormattedSigningDateTime());
        String string = this.calculateContentHash(signableRequest);
        if ("required".equals(signableRequest.getHeaders().get("x-amz-content-sha256"))) {
            signableRequest.addHeader("x-amz-content-sha256", string);
        }
        String string2 = this.createCanonicalRequest(signableRequest, string);
        String string3 = this.createStringToSign(string2, aWS4SignerRequestParams);
        byte[] byArray = this.deriveSigningKey(aWSCredentials2, aWS4SignerRequestParams);
        byte[] byArray2 = this.computeSignature(string3, byArray, aWS4SignerRequestParams);
        signableRequest.addHeader("Authorization", this.buildAuthorizationHeader(signableRequest, byArray2, aWSCredentials2, aWS4SignerRequestParams));
        this.processRequestPayload(signableRequest, byArray2, byArray, aWS4SignerRequestParams);
    }

    @Override
    public void presignRequest(SignableRequest<?> signableRequest, AWSCredentials aWSCredentials, Date date) {
        if (this.isAnonymous(aWSCredentials)) {
            return;
        }
        long l = this.generateExpirationDate(date);
        this.addHostHeader(signableRequest);
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            signableRequest.addParameter("X-Amz-Security-Token", ((AWSSessionCredentials)aWSCredentials2).getSessionToken());
        }
        AWS4SignerRequestParams aWS4SignerRequestParams = new AWS4SignerRequestParams(signableRequest, this.overriddenDate, this.regionName, this.serviceName, "AWS4-HMAC-SHA256", this.endpointPrefix, this.regionFromEndpointResolver);
        String string = aWS4SignerRequestParams.getFormattedSigningDateTime();
        this.addPreSignInformationToRequest(signableRequest, aWSCredentials2, aWS4SignerRequestParams, string, l);
        String string2 = this.calculateContentHashPresign(signableRequest);
        String string3 = this.createCanonicalRequest(signableRequest, string2);
        String string4 = this.createStringToSign(string3, aWS4SignerRequestParams);
        byte[] byArray = this.deriveSigningKey(aWSCredentials2, aWS4SignerRequestParams);
        byte[] byArray2 = this.computeSignature(string4, byArray, aWS4SignerRequestParams);
        signableRequest.addParameter("X-Amz-Signature", BinaryUtils.toHex(byArray2));
    }

    protected String createCanonicalRequest(SignableRequest<?> signableRequest, String string) {
        String string2 = SdkHttpUtils.appendUri(signableRequest.getEndpoint().getPath(), signableRequest.getResourcePath());
        StringBuilder stringBuilder = new StringBuilder(signableRequest.getHttpMethod().toString());
        stringBuilder.append("\n").append(this.getCanonicalizedResourcePath(string2, this.doubleUrlEncode)).append("\n").append(this.getCanonicalizedQueryString(signableRequest)).append("\n").append(this.getCanonicalizedHeaderString(signableRequest)).append("\n").append(this.getSignedHeadersString(signableRequest)).append("\n").append(string);
        String string3 = stringBuilder.toString();
        if (log.isDebugEnabled()) {
            log.debug("AWS4 Canonical Request: '\"" + string3 + "\"");
        }
        return string3;
    }

    protected String createStringToSign(String string, AWS4SignerRequestParams aWS4SignerRequestParams) {
        StringBuilder stringBuilder = new StringBuilder(aWS4SignerRequestParams.getSigningAlgorithm());
        stringBuilder.append("\n").append(aWS4SignerRequestParams.getFormattedSigningDateTime()).append("\n").append(aWS4SignerRequestParams.getScope()).append("\n").append(BinaryUtils.toHex(this.hash(string)));
        String string2 = stringBuilder.toString();
        if (log.isDebugEnabled()) {
            log.debug("AWS4 String to Sign: '\"" + string2 + "\"");
        }
        return string2;
    }

    private final byte[] deriveSigningKey(AWSCredentials aWSCredentials, AWS4SignerRequestParams aWS4SignerRequestParams) {
        String string = this.computeSigningCacheKeyName(aWSCredentials, aWS4SignerRequestParams);
        long l = DateUtils.numberOfDaysSinceEpoch(aWS4SignerRequestParams.getSigningDateTimeMilli());
        SignerKey signerKey = signerCache.get(string);
        if (signerKey != null && l == signerKey.getNumberOfDaysSinceEpoch()) {
            return signerKey.getSigningKey();
        }
        if (log.isDebugEnabled()) {
            log.debug("Generating a new signing key as the signing key not available in the cache for the date " + TimeUnit.DAYS.toMillis(l));
        }
        byte[] byArray = this.newSigningKey(aWSCredentials, aWS4SignerRequestParams.getFormattedSigningDate(), aWS4SignerRequestParams.getRegionName(), aWS4SignerRequestParams.getServiceName());
        signerCache.add(string, new SignerKey(l, byArray));
        return byArray;
    }

    private final String computeSigningCacheKeyName(AWSCredentials aWSCredentials, AWS4SignerRequestParams aWS4SignerRequestParams) {
        StringBuilder stringBuilder = new StringBuilder(aWSCredentials.getAWSSecretKey());
        return stringBuilder.append("-").append(aWS4SignerRequestParams.getRegionName()).append("-").append(aWS4SignerRequestParams.getServiceName()).toString();
    }

    protected final byte[] computeSignature(String string, byte[] byArray, AWS4SignerRequestParams aWS4SignerRequestParams) {
        return this.sign(string.getBytes(Charset.forName("UTF-8")), byArray, SigningAlgorithm.HmacSHA256);
    }

    private String buildAuthorizationHeader(SignableRequest<?> signableRequest, byte[] byArray, AWSCredentials aWSCredentials, AWS4SignerRequestParams aWS4SignerRequestParams) {
        String string = aWSCredentials.getAWSAccessKeyId() + "/" + aWS4SignerRequestParams.getScope();
        String string2 = "Credential=" + string;
        String string3 = "SignedHeaders=" + this.getSignedHeadersString(signableRequest);
        String string4 = "Signature=" + BinaryUtils.toHex(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AWS4-HMAC-SHA256").append(" ").append(string2).append(", ").append(string3).append(", ").append(string4);
        return stringBuilder.toString();
    }

    private void addPreSignInformationToRequest(SignableRequest<?> signableRequest, AWSCredentials aWSCredentials, AWS4SignerRequestParams aWS4SignerRequestParams, String string, long l) {
        String string2 = aWSCredentials.getAWSAccessKeyId() + "/" + aWS4SignerRequestParams.getScope();
        signableRequest.addParameter("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        signableRequest.addParameter("X-Amz-Date", string);
        signableRequest.addParameter("X-Amz-SignedHeaders", this.getSignedHeadersString(signableRequest));
        signableRequest.addParameter("X-Amz-Expires", Long.toString(l));
        signableRequest.addParameter("X-Amz-Credential", string2);
    }

    @Override
    protected void addSessionCredentials(SignableRequest<?> signableRequest, AWSSessionCredentials aWSSessionCredentials) {
        signableRequest.addHeader("X-Amz-Security-Token", aWSSessionCredentials.getSessionToken());
    }

    protected String getCanonicalizedHeaderString(SignableRequest<?> signableRequest) {
        ArrayList<String> arrayList = new ArrayList<String>(signableRequest.getHeaders().keySet());
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        Map<String, String> map = signableRequest.getHeaders();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            if (this.shouldExcludeHeaderFromSigning(string)) continue;
            String string2 = StringUtils.lowerCase(string);
            String string3 = map.get(string);
            StringUtils.appendCompactedString(stringBuilder, string2);
            stringBuilder.append(":");
            if (string3 != null) {
                StringUtils.appendCompactedString(stringBuilder, string3);
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    protected String getSignedHeadersString(SignableRequest<?> signableRequest) {
        ArrayList<String> arrayList = new ArrayList<String>(signableRequest.getHeaders().keySet());
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            if (this.shouldExcludeHeaderFromSigning(string)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(StringUtils.lowerCase(string));
        }
        return stringBuilder.toString();
    }

    protected boolean shouldExcludeHeaderFromSigning(String string) {
        return listOfHeadersToIgnoreInLowerCase.contains(string.toLowerCase());
    }

    protected void addHostHeader(SignableRequest<?> signableRequest) {
        URI uRI = signableRequest.getEndpoint();
        if (uRI.getHost() == null) {
            throw new IllegalArgumentException("Request endpoint must have a valid hostname, but it did not: " + uRI);
        }
        StringBuilder stringBuilder = new StringBuilder(uRI.getHost());
        if (SdkHttpUtils.isUsingNonDefaultPort(uRI)) {
            stringBuilder.append(":").append(uRI.getPort());
        }
        signableRequest.addHeader("Host", stringBuilder.toString());
    }

    protected String calculateContentHash(SignableRequest<?> signableRequest) {
        InputStream inputStream2 = this.getBinaryRequestPayloadStream(signableRequest);
        ReadLimitInfo readLimitInfo = signableRequest.getReadLimitInfo();
        inputStream2.mark(readLimitInfo == null ? -1 : readLimitInfo.getReadLimit());
        String string = BinaryUtils.toHex(this.hash(inputStream2));
        try {
            inputStream2.reset();
        }
        catch (IOException iOException) {
            throw new SdkClientException("Unable to reset stream after calculating AWS4 signature", iOException);
        }
        return string;
    }

    protected void processRequestPayload(SignableRequest<?> signableRequest, byte[] byArray, byte[] byArray2, AWS4SignerRequestParams aWS4SignerRequestParams) {
    }

    protected String calculateContentHashPresign(SignableRequest<?> signableRequest) {
        return this.calculateContentHash(signableRequest);
    }

    private boolean isAnonymous(AWSCredentials aWSCredentials) {
        return aWSCredentials instanceof AnonymousAWSCredentials;
    }

    private long generateExpirationDate(Date date) {
        long l;
        long l2 = l = date != null ? (date.getTime() - this.clock.currentTimeMillis()) / 1000L : 604800L;
        if (l > 604800L) {
            throw new SdkClientException("Requests that are pre-signed by SigV4 algorithm are valid for at most 7 days. The expiration date set on the current request [" + AWS4SignerUtils.formatTimestamp(date.getTime()) + "] has exceeded this limit.");
        }
        return l;
    }

    protected byte[] newSigningKey(AWSCredentials aWSCredentials, String string, String string2, String string3) {
        byte[] byArray = ("AWS4" + aWSCredentials.getAWSSecretKey()).getBytes(Charset.forName("UTF-8"));
        byte[] byArray2 = this.sign(string, byArray, SigningAlgorithm.HmacSHA256);
        byte[] byArray3 = this.sign(string2, byArray2, SigningAlgorithm.HmacSHA256);
        byte[] byArray4 = this.sign(string3, byArray3, SigningAlgorithm.HmacSHA256);
        return this.sign("aws4_request", byArray4, SigningAlgorithm.HmacSHA256);
    }
}

