/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.arn;

import com.amazonaws.arn.ArnResource;
import com.amazonaws.util.ValidationUtils;

public class Arn {
    private final String partition;
    private final String service;
    private final String region;
    private final String accountId;
    private final String resource;
    private final ArnResource arnResource;

    private Arn(Builder builder) {
        this.partition = ValidationUtils.assertStringNotEmpty(builder.partition, "partition");
        this.service = ValidationUtils.assertStringNotEmpty(builder.service, "service");
        this.region = builder.region;
        this.accountId = builder.accountId;
        this.resource = ValidationUtils.assertStringNotEmpty(builder.resource, "resource");
        this.arnResource = ArnResource.fromString(this.resource);
    }

    public String getPartition() {
        return this.partition;
    }

    public String getService() {
        return this.service;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public ArnResource getResource() {
        return this.arnResource;
    }

    public String getResourceAsString() {
        return this.resource;
    }

    public Builder toBuilder() {
        return Arn.builder().withPartition(this.getPartition()).withService(this.getService()).withAccountId(this.getAccountId()).withRegion(this.getRegion()).withResource(this.getResourceAsString());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Arn fromString(String string) {
        int n = string.indexOf(58);
        if (n < 0 || !"arn".equals(string.substring(0, n))) {
            throw new IllegalArgumentException("Malformed ARN - doesn't start with 'arn:'");
        }
        int n2 = string.indexOf(58, n + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Malformed ARN - no AWS partition specified");
        }
        String string2 = string.substring(n + 1, n2);
        int n3 = string.indexOf(58, n2 + 1);
        if (n3 < 0) {
            throw new IllegalArgumentException("Malformed ARN - no service specified");
        }
        String string3 = string.substring(n2 + 1, n3);
        int n4 = string.indexOf(58, n3 + 1);
        if (n4 < 0) {
            throw new IllegalArgumentException("Malformed ARN - no AWS region partition specified");
        }
        String string4 = string.substring(n3 + 1, n4);
        int n5 = string.indexOf(58, n4 + 1);
        if (n5 < 0) {
            throw new IllegalArgumentException("Malformed ARN - no AWS account specified");
        }
        String string5 = string.substring(n4 + 1, n5);
        String string6 = string.substring(n5 + 1);
        if (string6.isEmpty()) {
            throw new IllegalArgumentException("Malformed ARN - no resource specified");
        }
        return Arn.builder().withPartition(string2).withService(string3).withRegion(string4).withAccountId(string5).withResource(string6).build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("arn:");
        stringBuilder.append(this.partition);
        stringBuilder.append(":");
        stringBuilder.append(this.service);
        stringBuilder.append(":");
        stringBuilder.append(this.region);
        stringBuilder.append(":");
        stringBuilder.append(this.accountId);
        stringBuilder.append(":");
        stringBuilder.append(this.resource);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Arn arn = (Arn)object;
        if (!this.partition.equals(arn.partition)) {
            return false;
        }
        if (!this.service.equals(arn.service)) {
            return false;
        }
        if (this.region != null ? !this.region.equals(arn.region) : arn.region != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(arn.accountId) : arn.accountId != null) {
            return false;
        }
        return this.resource.equals(arn.resource);
    }

    public int hashCode() {
        int n = this.partition.hashCode();
        n = 31 * n + this.service.hashCode();
        n = 31 * n + (this.region != null ? this.region.hashCode() : 0);
        n = 31 * n + (this.accountId != null ? this.accountId.hashCode() : 0);
        n = 31 * n + this.resource.hashCode();
        return n;
    }

    public static final class Builder {
        private String partition;
        private String service;
        private String region;
        private String accountId;
        private String resource;

        private Builder() {
        }

        public void setPartition(String string) {
            this.partition = string;
        }

        public Builder withPartition(String string) {
            this.setPartition(string);
            return this;
        }

        public void setService(String string) {
            this.service = string;
        }

        public Builder withService(String string) {
            this.setService(string);
            return this;
        }

        public void setRegion(String string) {
            this.region = string;
        }

        public Builder withRegion(String string) {
            this.setRegion(string);
            return this;
        }

        public void setAccountId(String string) {
            this.accountId = string;
        }

        public Builder withAccountId(String string) {
            this.setAccountId(string);
            return this;
        }

        public void setResource(String string) {
            this.resource = string;
        }

        public Builder withResource(String string) {
            this.setResource(string);
            return this;
        }

        public Arn build() {
            return new Arn(this);
        }
    }
}

