/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ReadLimitInfo;
import com.amazonaws.Request;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.event.ProgressInputStream;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.Jackson;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@NotThreadSafe
public class DefaultRequest<T>
implements Request<T> {
    private String resourcePath;
    private Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
    private Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private URI endpoint;
    private String serviceName;
    private final AmazonWebServiceRequest originalRequest;
    private HttpMethodName httpMethod = HttpMethodName.POST;
    private InputStream content;
    private int timeOffset;
    private AWSRequestMetrics metrics;
    private final Map<HandlerContextKey<?>, Object> handlerContext = new HashMap();

    public DefaultRequest(AmazonWebServiceRequest amazonWebServiceRequest, String string) {
        this.serviceName = string;
        this.originalRequest = amazonWebServiceRequest == null ? AmazonWebServiceRequest.NOOP : amazonWebServiceRequest;
        this.handlerContext.putAll(this.originalRequest.getHandlerContext());
    }

    public DefaultRequest(String string) {
        this(null, string);
    }

    @Override
    public AmazonWebServiceRequest getOriginalRequest() {
        return this.originalRequest;
    }

    @Override
    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setResourcePath(String string) {
        this.resourcePath = string;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void addParameter(String string, String string2) {
        List<String> list = this.parameters.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.parameters.put(string, list);
        }
        list.add(string2);
    }

    @Override
    public void addParameters(String string, List<String> list) {
        if (list == null) {
            return;
        }
        for (String string2 : list) {
            this.addParameter(string, string2);
        }
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    @Override
    public Request<T> withParameter(String string, String string2) {
        this.addParameter(string, string2);
        return this;
    }

    @Override
    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethodName httpMethodName) {
        this.httpMethod = httpMethodName;
    }

    @Override
    public void setEndpoint(URI uRI) {
        this.endpoint = uRI;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public void setContent(InputStream inputStream2) {
        this.content = inputStream2;
    }

    @Override
    public void setHeaders(Map<String, String> map) {
        this.headers.clear();
        this.headers.putAll(map);
    }

    @Override
    public void setParameters(Map<String, List<String>> map) {
        this.parameters.clear();
        this.parameters.putAll(map);
    }

    @Override
    public int getTimeOffset() {
        return this.timeOffset;
    }

    @Override
    public void setTimeOffset(int n) {
        this.timeOffset = n;
    }

    @Override
    public Request<T> withTimeOffset(int n) {
        this.setTimeOffset(n);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.getHttpMethod()).append(" ");
        stringBuilder.append(this.getEndpoint()).append(" ");
        String string = this.getResourcePath();
        if (string == null) {
            stringBuilder.append("/");
        } else {
            if (!string.startsWith("/")) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(" ");
        if (!this.getParameters().isEmpty()) {
            stringBuilder.append("Parameters: (").append(Jackson.toJsonString(this.parameters));
        }
        if (!this.getHeaders().isEmpty()) {
            stringBuilder.append("Headers: (");
            for (String string2 : this.getHeaders().keySet()) {
                String string3 = this.getHeaders().get(string2);
                stringBuilder.append(string2).append(": ").append(string3).append(", ");
            }
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }

    @Override
    public AWSRequestMetrics getAWSRequestMetrics() {
        return this.metrics;
    }

    @Override
    public void setAWSRequestMetrics(AWSRequestMetrics aWSRequestMetrics) {
        if (this.metrics != null) {
            throw new IllegalStateException("AWSRequestMetrics has already been set on this request");
        }
        this.metrics = aWSRequestMetrics;
    }

    @Override
    public <X> void addHandlerContext(HandlerContextKey<X> handlerContextKey, X x) {
        this.handlerContext.put(handlerContextKey, x);
    }

    @Override
    public <X> X getHandlerContext(HandlerContextKey<X> handlerContextKey) {
        return (X)this.handlerContext.get(handlerContextKey);
    }

    @Override
    public InputStream getContentUnwrapped() {
        InputStream inputStream2 = this.getContent();
        if (inputStream2 == null) {
            return null;
        }
        while (inputStream2 instanceof ProgressInputStream) {
            ProgressInputStream progressInputStream = (ProgressInputStream)inputStream2;
            inputStream2 = progressInputStream.getWrappedInputStream();
        }
        return inputStream2;
    }

    @Override
    public ReadLimitInfo getReadLimitInfo() {
        return this.originalRequest;
    }

    @Override
    public Object getOriginalRequestObject() {
        return this.originalRequest;
    }
}

