/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.util;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.impl.PrivateListWriter;
import software.amazon.ion.util.GzipOrRawInputStream;

public class IonStreamUtils {
    public static boolean isIonBinary(byte[] byArray) {
        return byArray != null && IonStreamUtils.isIonBinary(byArray, 0, byArray.length);
    }

    public static boolean isIonBinary(byte[] byArray, int n, int n2) {
        return IonStreamUtils.cookieMatches(PrivateIonConstants.BINARY_VERSION_MARKER_1_0, byArray, n, n2);
    }

    public static boolean isGzip(byte[] byArray, int n, int n2) {
        return IonStreamUtils.cookieMatches(GzipOrRawInputStream.GZIP_HEADER, byArray, n, n2);
    }

    private static boolean cookieMatches(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray2 == null || n2 < byArray.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[n + i]) continue;
            return false;
        }
        return true;
    }

    public static InputStream unGzip(InputStream inputStream2) throws IOException {
        return new GzipOrRawInputStream(inputStream2);
    }

    public static void writeBoolList(IonWriter ionWriter, boolean[] blArray) throws IOException {
        if (ionWriter instanceof PrivateListWriter) {
            ((PrivateListWriter)ionWriter).writeBoolList(blArray);
            return;
        }
        ionWriter.stepIn(IonType.LIST);
        for (int i = 0; i < blArray.length; ++i) {
            ionWriter.writeBool(blArray[i]);
        }
        ionWriter.stepOut();
    }

    public static void writeFloatList(IonWriter ionWriter, float[] fArray) throws IOException {
        if (ionWriter instanceof PrivateListWriter) {
            ((PrivateListWriter)ionWriter).writeFloatList(fArray);
            return;
        }
        ionWriter.stepIn(IonType.LIST);
        for (int i = 0; i < fArray.length; ++i) {
            ionWriter.writeFloat(fArray[i]);
        }
        ionWriter.stepOut();
    }

    public static void writeFloatList(IonWriter ionWriter, double[] dArray) throws IOException {
        if (ionWriter instanceof PrivateListWriter) {
            ((PrivateListWriter)ionWriter).writeFloatList(dArray);
            return;
        }
        ionWriter.stepIn(IonType.LIST);
        for (int i = 0; i < dArray.length; ++i) {
            ionWriter.writeFloat(dArray[i]);
        }
        ionWriter.stepOut();
    }

    public static void writeIntList(IonWriter ionWriter, byte[] byArray) throws IOException {
        if (ionWriter instanceof PrivateListWriter) {
            ((PrivateListWriter)ionWriter).writeIntList(byArray);
            return;
        }
        ionWriter.stepIn(IonType.LIST);
        for (int i = 0; i < byArray.length; ++i) {
            ionWriter.writeInt(byArray[i]);
        }
        ionWriter.stepOut();
    }

    public static void writeIntList(IonWriter ionWriter, short[] sArray) throws IOException {
        if (ionWriter instanceof PrivateListWriter) {
            ((PrivateListWriter)ionWriter).writeIntList(sArray);
            return;
        }
        ionWriter.stepIn(IonType.LIST);
        for (int i = 0; i < sArray.length; ++i) {
            ionWriter.writeInt(sArray[i]);
        }
        ionWriter.stepOut();
    }

    public static void writeIntList(IonWriter ionWriter, int[] nArray) throws IOException {
        if (ionWriter instanceof PrivateListWriter) {
            ((PrivateListWriter)ionWriter).writeIntList(nArray);
            return;
        }
        ionWriter.stepIn(IonType.LIST);
        for (int i = 0; i < nArray.length; ++i) {
            ionWriter.writeInt(nArray[i]);
        }
        ionWriter.stepOut();
    }

    public static void writeIntList(IonWriter ionWriter, long[] lArray) throws IOException {
        if (ionWriter instanceof PrivateListWriter) {
            ((PrivateListWriter)ionWriter).writeIntList(lArray);
            return;
        }
        ionWriter.stepIn(IonType.LIST);
        for (int i = 0; i < lArray.length; ++i) {
            ionWriter.writeInt(lArray[i]);
        }
        ionWriter.stepOut();
    }

    public static void writeStringList(IonWriter ionWriter, String[] stringArray) throws IOException {
        if (ionWriter instanceof PrivateListWriter) {
            ((PrivateListWriter)ionWriter).writeStringList(stringArray);
            return;
        }
        ionWriter.stepIn(IonType.LIST);
        for (int i = 0; i < stringArray.length; ++i) {
            ionWriter.writeString(stringArray[i]);
        }
        ionWriter.stepOut();
    }
}

