/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.system;

import software.amazon.ion.IonCatalog;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.system.IonWriterBuilder;

abstract class IonWriterBuilderBase<T extends IonWriterBuilderBase>
extends IonWriterBuilder {
    private IonCatalog myCatalog;
    private SymbolTable[] myImports;

    protected IonWriterBuilderBase() {
    }

    protected IonWriterBuilderBase(IonWriterBuilderBase ionWriterBuilderBase) {
        this.myCatalog = ionWriterBuilderBase.myCatalog;
        this.myImports = ionWriterBuilderBase.myImports;
    }

    abstract T copy();

    abstract T immutable();

    abstract T mutable();

    protected void mutationCheck() {
        throw new UnsupportedOperationException("This builder is immutable");
    }

    public final IonCatalog getCatalog() {
        return this.myCatalog;
    }

    public void setCatalog(IonCatalog ionCatalog) {
        this.mutationCheck();
        this.myCatalog = ionCatalog;
    }

    public T withCatalog(IonCatalog ionCatalog) {
        T t2 = this.mutable();
        ((IonWriterBuilderBase)t2).setCatalog(ionCatalog);
        return t2;
    }

    private static SymbolTable[] safeCopy(SymbolTable[] symbolTableArray) {
        if (symbolTableArray != null && symbolTableArray.length != 0) {
            symbolTableArray = (SymbolTable[])symbolTableArray.clone();
        }
        return symbolTableArray;
    }

    public final SymbolTable[] getImports() {
        return IonWriterBuilderBase.safeCopy(this.myImports);
    }

    public void setImports(SymbolTable ... symbolTableArray) {
        this.mutationCheck();
        this.myImports = IonWriterBuilderBase.safeCopy(symbolTableArray);
    }

    public T withImports(SymbolTable ... symbolTableArray) {
        T t2 = this.mutable();
        ((IonWriterBuilderBase)t2).setImports(symbolTableArray);
        return t2;
    }
}

