/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonContainer;
import software.amazon.ion.IonDatagram;
import software.amazon.ion.IonException;
import software.amazon.ion.IonLoader;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonTimestamp;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.UnexpectedEofException;
import software.amazon.ion.UnsupportedIonVersionException;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.PrivateIonBinaryWriterBuilder;
import software.amazon.ion.impl.PrivateIonReaderFactory;
import software.amazon.ion.impl.PrivateIonSystem;
import software.amazon.ion.impl.PrivateIonWriterFactory;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.lite.IonContainerLite;
import software.amazon.ion.impl.lite.IonDatagramLite;
import software.amazon.ion.impl.lite.IonLoaderLite;
import software.amazon.ion.impl.lite.IonSymbolLite;
import software.amazon.ion.impl.lite.IonTimestampLite;
import software.amazon.ion.impl.lite.IonValueLite;
import software.amazon.ion.impl.lite.ValueFactoryLite;
import software.amazon.ion.system.IonTextWriterBuilder;
import software.amazon.ion.util.IonTextUtils;

final class IonSystemLite
extends ValueFactoryLite
implements PrivateIonSystem {
    private final SymbolTable _system_symbol_table;
    private final IonCatalog _catalog;
    private ValueFactoryLite _value_factory;
    private final IonLoader _loader;
    private final IonTextWriterBuilder myTextWriterBuilder;
    private final PrivateIonBinaryWriterBuilder myBinaryWriterBuilder;

    public IonSystemLite(IonTextWriterBuilder ionTextWriterBuilder, PrivateIonBinaryWriterBuilder privateIonBinaryWriterBuilder) {
        IonCatalog ionCatalog = ionTextWriterBuilder.getCatalog();
        assert (ionCatalog != null);
        assert (ionCatalog == privateIonBinaryWriterBuilder.getCatalog());
        this._catalog = ionCatalog;
        this._loader = new IonLoaderLite(this, ionCatalog);
        this._system_symbol_table = privateIonBinaryWriterBuilder.getInitialSymbolTable();
        assert (this._system_symbol_table.isSystemTable());
        this.myTextWriterBuilder = ionTextWriterBuilder.immutable();
        this._value_factory = this;
        this._value_factory.set_system(this);
        privateIonBinaryWriterBuilder.setSymtabValueFactory(this._value_factory);
        this.myBinaryWriterBuilder = privateIonBinaryWriterBuilder.immutable();
    }

    @Override
    public boolean isStreamCopyOptimized() {
        return this.myBinaryWriterBuilder.isStreamCopyOptimized();
    }

    @Override
    public <T extends IonValue> T clone(T t2) throws IonException {
        if (t2.getSystem() == this) {
            return (T)t2.clone();
        }
        if (t2 instanceof IonDatagram) {
            IonDatagram ionDatagram = this.newDatagram();
            IonWriter ionWriter = PrivateIonWriterFactory.makeWriter(ionDatagram);
            IonReader ionReader = PrivateIonReaderFactory.makeSystemReader(t2.getSystem(), t2);
            try {
                ionWriter.writeValues(ionReader);
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
            return (T)ionDatagram;
        }
        IonReader ionReader = this.newReader(t2);
        ionReader.next();
        return (T)this.newValue(ionReader);
    }

    @Override
    public IonCatalog getCatalog() {
        return this._catalog;
    }

    @Override
    public synchronized IonLoader getLoader() {
        return this._loader;
    }

    @Override
    public IonLoader newLoader() {
        return new IonLoaderLite(this, this._catalog);
    }

    @Override
    public IonLoader newLoader(IonCatalog ionCatalog) {
        if (ionCatalog == null) {
            ionCatalog = this.getCatalog();
        }
        return new IonLoaderLite(this, ionCatalog);
    }

    @Override
    public final SymbolTable getSystemSymbolTable() {
        return this._system_symbol_table;
    }

    @Override
    public SymbolTable getSystemSymbolTable(String string) throws UnsupportedIonVersionException {
        if (!"$ion_1_0".equals(string)) {
            throw new UnsupportedIonVersionException(string);
        }
        return this.getSystemSymbolTable();
    }

    @Override
    public Iterator<IonValue> iterate(Reader reader) {
        IonReader ionReader = PrivateIonReaderFactory.makeReader((IonSystem)this, this._catalog, reader);
        ReaderIterator readerIterator = new ReaderIterator(this, ionReader);
        return readerIterator;
    }

    @Override
    public Iterator<IonValue> iterate(InputStream inputStream2) {
        IonReader ionReader = this.newReader(inputStream2);
        ReaderIterator readerIterator = new ReaderIterator(this, ionReader);
        return readerIterator;
    }

    @Override
    public Iterator<IonValue> iterate(String string) {
        IonReader ionReader = PrivateIonReaderFactory.makeReader((IonSystem)this, this._catalog, string);
        ReaderIterator readerIterator = new ReaderIterator(this, ionReader);
        return readerIterator;
    }

    @Override
    public Iterator<IonValue> iterate(byte[] byArray) {
        IonReader ionReader = PrivateIonReaderFactory.makeReader((IonSystem)this, this._catalog, byArray);
        ReaderIterator readerIterator = new ReaderIterator(this, ionReader);
        return readerIterator;
    }

    @Override
    public IonWriter newBinaryWriter(OutputStream outputStream2, SymbolTable ... symbolTableArray) {
        return this.myBinaryWriterBuilder.withImports(symbolTableArray).build(outputStream2);
    }

    @Override
    public IonWriter newTextWriter(Appendable appendable) {
        return this.myTextWriterBuilder.build(appendable);
    }

    @Override
    public IonWriter newTextWriter(Appendable appendable, SymbolTable ... symbolTableArray) throws IOException {
        return this.myTextWriterBuilder.withImports(symbolTableArray).build(appendable);
    }

    @Override
    public IonWriter newTextWriter(OutputStream outputStream2) {
        return this.myTextWriterBuilder.build(outputStream2);
    }

    @Override
    public IonWriter newTextWriter(OutputStream outputStream2, SymbolTable ... symbolTableArray) throws IOException {
        return this.myTextWriterBuilder.withImports(symbolTableArray).build(outputStream2);
    }

    @Override
    public SymbolTable newLocalSymbolTable(SymbolTable ... symbolTableArray) {
        return PrivateUtils.newLocalSymtab((ValueFactory)this, this.getSystemSymbolTable(), null, symbolTableArray);
    }

    @Override
    public SymbolTable newSharedSymbolTable(IonStruct ionStruct) {
        return PrivateUtils.newSharedSymtab(ionStruct);
    }

    @Override
    public SymbolTable newSharedSymbolTable(IonReader ionReader) {
        return PrivateUtils.newSharedSymtab(ionReader, false);
    }

    @Override
    public SymbolTable newSharedSymbolTable(IonReader ionReader, boolean bl) {
        return PrivateUtils.newSharedSymtab(ionReader, bl);
    }

    @Override
    public SymbolTable newSharedSymbolTable(String string, int n, Iterator<String> iterator2, SymbolTable ... symbolTableArray) {
        int n2;
        ArrayList arrayList = new ArrayList();
        SymbolTable symbolTable = null;
        if (n > 1 && ((symbolTable = this._catalog.getTable(string, n2 = n - 1)) == null || symbolTable.getVersion() != n2)) {
            String string2 = "Catalog does not contain symbol table " + IonTextUtils.printString(string) + " version " + n2 + " required to create version " + n;
            throw new IonException(string2);
        }
        for (SymbolTable symbolTable2 : symbolTableArray) {
            PrivateUtils.addAllNonNull(arrayList, symbolTable2.iterateDeclaredSymbolNames());
        }
        PrivateUtils.addAllNonNull(arrayList, iterator2);
        SymbolTable symbolTable3 = PrivateUtils.newSharedSymtab(string, n, symbolTable, arrayList.iterator());
        return symbolTable3;
    }

    @Override
    public IonValueLite newValue(IonReader ionReader) {
        IonValueLite ionValueLite = this.load_value_helper(ionReader, true);
        if (ionValueLite == null) {
            throw new IonException("No value available");
        }
        return ionValueLite;
    }

    private IonValueLite load_value_helper(IonReader ionReader, boolean bl) {
        Object object;
        IonValueLite ionValueLite;
        boolean bl2 = false;
        IonType ionType = ionReader.getType();
        if (ionType == null) {
            return null;
        }
        if (ionReader.isNullValue()) {
            ionValueLite = this.newNull(ionType);
        } else {
            switch (ionType) {
                case BOOL: {
                    ionValueLite = this.newBool(ionReader.booleanValue());
                    break;
                }
                case INT: {
                    ionValueLite = this.newInt(ionReader.bigIntegerValue());
                    break;
                }
                case FLOAT: {
                    ionValueLite = this.newFloat(ionReader.doubleValue());
                    break;
                }
                case DECIMAL: {
                    ionValueLite = this.newDecimal(ionReader.decimalValue());
                    break;
                }
                case TIMESTAMP: {
                    ionValueLite = this.newTimestamp(ionReader.timestampValue());
                    break;
                }
                case SYMBOL: {
                    ionValueLite = this.newSymbol(ionReader.symbolValue());
                    bl2 = true;
                    break;
                }
                case STRING: {
                    ionValueLite = this.newString(ionReader.stringValue());
                    break;
                }
                case CLOB: {
                    ionValueLite = this.newClob(ionReader.newBytes());
                    break;
                }
                case BLOB: {
                    ionValueLite = this.newBlob(ionReader.newBytes());
                    break;
                }
                case LIST: {
                    ionValueLite = this.newEmptyList();
                    break;
                }
                case SEXP: {
                    ionValueLite = this.newEmptySexp();
                    break;
                }
                case STRUCT: {
                    ionValueLite = this.newEmptyStruct();
                    break;
                }
                default: {
                    throw new IonException("unexpected type encountered reading value: " + ionType.toString());
                }
            }
        }
        if (!bl && ionReader.isInStruct()) {
            object = ionReader.getFieldNameSymbol();
            String string = object.getText();
            if (string != null && object.getSid() != -1) {
                object = PrivateUtils.newSymbolToken(string, -1);
            }
            ionValueLite.setFieldNameSymbol((SymbolToken)object);
            bl2 = true;
        }
        if (((SymbolToken[])(object = ionReader.getTypeAnnotationSymbols())).length != 0) {
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2 = object[i];
                String string = object2.getText();
                if (string == null || object2.getSid() == -1) continue;
                object[i] = PrivateUtils.newSymbolToken(string, -1);
            }
            ionValueLite.setTypeAnnotationSymbols((SymbolToken[])object);
            bl2 = true;
        }
        if (!ionReader.isNullValue()) {
            switch (ionType) {
                case BOOL: 
                case INT: 
                case FLOAT: 
                case DECIMAL: 
                case TIMESTAMP: 
                case SYMBOL: 
                case STRING: 
                case CLOB: 
                case BLOB: {
                    break;
                }
                case LIST: 
                case SEXP: 
                case STRUCT: {
                    if (!this.load_children((IonContainerLite)ionValueLite, ionReader)) break;
                    bl2 = true;
                    break;
                }
                default: {
                    throw new IonException("unexpected type encountered reading value: " + ionType.toString());
                }
            }
        }
        if (bl2) {
            ionValueLite._isSymbolPresent(true);
        }
        return ionValueLite;
    }

    private boolean load_children(IonContainerLite ionContainerLite, IonReader ionReader) {
        IonType ionType;
        boolean bl = false;
        ionReader.stepIn();
        while ((ionType = ionReader.next()) != null) {
            IonValueLite ionValueLite = this.load_value_helper(ionReader, false);
            ionContainerLite.add(ionValueLite);
            if (!ionValueLite._isSymbolPresent()) continue;
            bl = true;
        }
        ionReader.stepOut();
        return bl;
    }

    IonValueLite newValue(IonType ionType) {
        IonValueLite ionValueLite;
        if (ionType == null) {
            throw new IllegalArgumentException("the value type must be specified");
        }
        switch (ionType) {
            case NULL: {
                ionValueLite = this.newNull();
                break;
            }
            case BOOL: {
                ionValueLite = this.newNullBool();
                break;
            }
            case INT: {
                ionValueLite = this.newNullInt();
                break;
            }
            case FLOAT: {
                ionValueLite = this.newNullFloat();
                break;
            }
            case DECIMAL: {
                ionValueLite = this.newNullDecimal();
                break;
            }
            case TIMESTAMP: {
                ionValueLite = this.newNullTimestamp();
                break;
            }
            case SYMBOL: {
                ionValueLite = this.newNullSymbol();
                break;
            }
            case STRING: {
                ionValueLite = this.newNullString();
                break;
            }
            case CLOB: {
                ionValueLite = this.newNullClob();
                break;
            }
            case BLOB: {
                ionValueLite = this.newNullBlob();
                break;
            }
            case LIST: {
                ionValueLite = this.newEmptyList();
                break;
            }
            case SEXP: {
                ionValueLite = this.newEmptySexp();
                break;
            }
            case STRUCT: {
                ionValueLite = this.newEmptyStruct();
                break;
            }
            default: {
                throw new IonException("unexpected type encountered reading value: " + (Object)((Object)ionType));
            }
        }
        return ionValueLite;
    }

    @Override
    public IonWriter newWriter(IonContainer ionContainer) {
        IonWriter ionWriter = PrivateIonWriterFactory.makeWriter(ionContainer);
        return ionWriter;
    }

    private IonValue singleValue(Iterator<IonValue> iterator2) {
        IonValue ionValue;
        try {
            ionValue = iterator2.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new UnexpectedEofException("no value found on input stream");
        }
        if (iterator2.hasNext()) {
            throw new IonException("not a single value");
        }
        return ionValue;
    }

    @Override
    public IonValue singleValue(String string) {
        Iterator<IonValue> iterator2 = this.iterate(string);
        return this.singleValue(iterator2);
    }

    @Override
    public IonValue singleValue(byte[] byArray) {
        Iterator<IonValue> iterator2 = this.iterate(byArray);
        return this.singleValue(iterator2);
    }

    protected IonSymbolLite newSystemIdSymbol(String string) {
        if (!"$ion_1_0".equals(string)) {
            throw new IllegalArgumentException("name isn't an ion version marker");
        }
        IonSymbolLite ionSymbolLite = this.newSymbol(string);
        ionSymbolLite.setIsIonVersionMarker(true);
        return ionSymbolLite;
    }

    @Override
    public IonTimestamp newUtcTimestampFromMillis(long l) {
        IonTimestampLite ionTimestampLite = this.newNullTimestamp();
        ionTimestampLite.setMillisUtc(l);
        return ionTimestampLite;
    }

    @Override
    public IonTimestamp newUtcTimestamp(Date date) {
        IonTimestampLite ionTimestampLite = this.newNullTimestamp();
        if (date != null) {
            ionTimestampLite.setMillisUtc(date.getTime());
        }
        return ionTimestampLite;
    }

    @Override
    public IonTimestamp newCurrentUtcTimestamp() {
        IonTimestampLite ionTimestampLite = super.newNullTimestamp();
        ionTimestampLite.setCurrentTimeUtc();
        return ionTimestampLite;
    }

    @Override
    public IonDatagram newDatagram() {
        IonCatalog ionCatalog = this.getCatalog();
        IonDatagramLite ionDatagramLite = this.newDatagram(ionCatalog);
        return ionDatagramLite;
    }

    public IonDatagramLite newDatagram(IonCatalog ionCatalog) {
        if (ionCatalog == null) {
            ionCatalog = this.getCatalog();
        }
        IonDatagramLite ionDatagramLite = new IonDatagramLite(this, ionCatalog);
        return ionDatagramLite;
    }

    @Override
    public IonDatagram newDatagram(IonValue ionValue) {
        IonDatagram ionDatagram = this.newDatagram(null, ionValue);
        return ionDatagram;
    }

    public IonDatagram newDatagram(IonCatalog ionCatalog, IonValue ionValue) {
        IonDatagramLite ionDatagramLite = this.newDatagram(ionCatalog);
        if (ionValue != null) {
            if (ionValue.getSystem() != this) {
                throw new IonException("this Ion system can't mix with instances from other system impl's");
            }
            if (ionValue.getContainer() != null) {
                ionValue = this.clone(ionValue);
            }
            ionDatagramLite.add(ionValue);
        }
        assert (ionDatagramLite.getSystem() == this);
        return ionDatagramLite;
    }

    @Override
    public IonDatagram newDatagram(SymbolTable ... symbolTableArray) {
        IonDatagram ionDatagram = this.newDatagram((IonCatalog)null, symbolTableArray);
        return ionDatagram;
    }

    public IonDatagram newDatagram(IonCatalog ionCatalog, SymbolTable ... symbolTableArray) {
        SymbolTable symbolTable = this.getSystemSymbolTable();
        SymbolTable symbolTable2 = PrivateUtils.initialSymtab(this, symbolTable, symbolTableArray);
        IonDatagramLite ionDatagramLite = this.newDatagram(ionCatalog);
        ionDatagramLite.appendTrailingSymbolTable(symbolTable2);
        return ionDatagramLite;
    }

    @Override
    public IonReader newReader(byte[] byArray) {
        return PrivateIonReaderFactory.makeReader((IonSystem)this, this._catalog, byArray);
    }

    @Override
    public IonReader newSystemReader(byte[] byArray) {
        return PrivateIonReaderFactory.makeSystemReader((IonSystem)this, byArray);
    }

    @Override
    public IonReader newReader(byte[] byArray, int n, int n2) {
        return PrivateIonReaderFactory.makeReader((IonSystem)this, this._catalog, byArray, n, n2);
    }

    @Override
    public IonReader newSystemReader(byte[] byArray, int n, int n2) {
        return PrivateIonReaderFactory.makeSystemReader((IonSystem)this, byArray, n, n2);
    }

    @Override
    public IonReader newReader(String string) {
        return PrivateIonReaderFactory.makeReader((IonSystem)this, this._catalog, string);
    }

    @Override
    public IonReader newSystemReader(String string) {
        return PrivateIonReaderFactory.makeSystemReader((IonSystem)this, string);
    }

    @Override
    public IonReader newReader(InputStream inputStream2) {
        return PrivateIonReaderFactory.makeReader((IonSystem)this, this._catalog, inputStream2);
    }

    @Override
    public IonReader newSystemReader(InputStream inputStream2) {
        return PrivateIonReaderFactory.makeSystemReader((IonSystem)this, inputStream2);
    }

    @Override
    public IonReader newReader(Reader reader) {
        return PrivateIonReaderFactory.makeReader((IonSystem)this, this._catalog, reader);
    }

    @Override
    public IonReader newReader(IonValue ionValue) {
        return PrivateIonReaderFactory.makeReader((IonSystem)this, this._catalog, ionValue);
    }

    @Override
    public IonReader newSystemReader(Reader reader) {
        return PrivateIonReaderFactory.makeSystemReader((IonSystem)this, reader);
    }

    @Override
    public IonReader newSystemReader(IonValue ionValue) {
        return PrivateIonReaderFactory.makeSystemReader((IonSystem)this, ionValue);
    }

    @Override
    public IonWriter newTreeSystemWriter(IonContainer ionContainer) {
        IonWriter ionWriter = PrivateIonWriterFactory.makeSystemWriter(ionContainer);
        return ionWriter;
    }

    @Override
    public IonWriter newTreeWriter(IonContainer ionContainer) {
        IonWriter ionWriter = PrivateIonWriterFactory.makeWriter(ionContainer);
        return ionWriter;
    }

    @Override
    public Iterator<IonValue> systemIterate(Reader reader) {
        IonReader ionReader = this.newSystemReader(reader);
        return PrivateUtils.iterate(this, ionReader);
    }

    @Override
    public Iterator<IonValue> systemIterate(String string) {
        IonReader ionReader = this.newSystemReader(string);
        return PrivateUtils.iterate(this, ionReader);
    }

    @Override
    public Iterator<IonValue> systemIterate(InputStream inputStream2) {
        IonReader ionReader = this.newSystemReader(inputStream2);
        return PrivateUtils.iterate(this, ionReader);
    }

    @Override
    public Iterator<IonValue> systemIterate(byte[] byArray) {
        IonReader ionReader = this.newSystemReader(byArray);
        return PrivateUtils.iterate(this, ionReader);
    }

    @Override
    public boolean valueIsSharedSymbolTable(IonValue ionValue) {
        return ionValue instanceof IonStruct && ionValue.hasTypeAnnotation("$ion_symbol_table");
    }

    static class ReaderIterator
    implements Closeable,
    Iterator<IonValue> {
        private final IonReader _reader;
        private final IonSystemLite _system;
        private IonType _next;

        protected ReaderIterator(IonSystemLite ionSystemLite, IonReader ionReader) {
            this._reader = ionReader;
            this._system = ionSystemLite;
        }

        @Override
        public boolean hasNext() {
            if (this._next == null) {
                this._next = this._reader.next();
            }
            return this._next != null;
        }

        @Override
        public IonValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SymbolTable symbolTable = this._reader.getSymbolTable();
            IonValueLite ionValueLite = this._system.newValue(this._reader);
            this._next = null;
            ionValueLite.setSymbolTable(symbolTable);
            return ionValueLite;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

