/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import software.amazon.ion.EmptySymbolException;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.UnknownSymbolException;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonSymbol;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonTextLite;
import software.amazon.ion.impl.lite.IonValueLite;

final class IonSymbolLite
extends IonTextLite
implements PrivateIonSymbol {
    private static final int HASH_SIGNATURE = IonType.SYMBOL.toString().hashCode();
    private int _sid = -1;

    IonSymbolLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonSymbolLite(IonSymbolLite ionSymbolLite, IonContext ionContext) throws UnknownSymbolException {
        super(ionSymbolLite, ionContext);
    }

    IonSymbolLite(ContainerlessContext containerlessContext, SymbolToken symbolToken) {
        super(containerlessContext, symbolToken == null);
        if (symbolToken != null) {
            String string = symbolToken.getText();
            int n = symbolToken.getSid();
            assert (string != null || n > 0);
            if (string != null) {
                if (string.length() == 0) {
                    throw new EmptySymbolException();
                }
                super.setValue(string);
            } else {
                this._sid = n;
            }
        }
    }

    @Override
    IonSymbolLite clone(IonContext ionContext) {
        return new IonSymbolLite(this, ionContext);
    }

    @Override
    public IonSymbolLite clone() throws UnknownSymbolException {
        if (!this.isNullValue() && this._sid != -1 && this._stringValue() == null) {
            throw new UnknownSymbolException(this._sid);
        }
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = 127;
        int n2 = 31;
        int n3 = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            SymbolToken symbolToken = this.symbolValue(symbolTableProvider);
            String string = symbolToken.getText();
            int n4 = string == null ? symbolToken.getSid() * 127 : string.hashCode() * 31;
            n4 ^= n4 << 29 ^ n4 >> 3;
            n3 ^= n4;
        }
        return this.hashTypeAnnotations(n3, symbolTableProvider);
    }

    @Override
    public IonType getType() {
        return IonType.SYMBOL;
    }

    private String _stringValue() {
        return this._stringValue(new IonValueLite.LazySymbolTableProvider(this));
    }

    private String _stringValue(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        String string = this._get_value();
        if (string == null) {
            assert (this._sid > 0);
            SymbolTable symbolTable = symbolTableProvider.getSymbolTable();
            string = symbolTable.findKnownSymbol(this._sid);
            if (string != null && !this._isLocked()) {
                this._set_value(string);
            }
        }
        return string;
    }

    @Override
    public SymbolToken symbolValue() {
        return this.symbolValue(new IonValueLite.LazySymbolTableProvider(this));
    }

    private int resolveSymbolId() {
        SymbolToken symbolToken;
        this.validateThisNotNull();
        if (this._sid != -1 || this.isReadOnly()) {
            return this._sid;
        }
        SymbolTable symbolTable = this.getSymbolTable();
        if (symbolTable == null) {
            symbolTable = this.getSystem().getSystemSymbolTable();
        }
        assert (symbolTable != null);
        String string = this._get_value();
        if (!symbolTable.isLocalTable()) {
            this._sid = symbolTable.findSymbol(string);
            if (this._sid > 0 || this.isReadOnly()) {
                return this._sid;
            }
        }
        if ((symbolToken = symbolTable.find(string)) != null) {
            this._sid = symbolToken.getSid();
            this._set_value(symbolToken.getText());
        }
        return this._sid;
    }

    @Override
    public SymbolToken symbolValue(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        if (this.isNullValue()) {
            return null;
        }
        int n = this.resolveSymbolId();
        String string = this._stringValue(symbolTableProvider);
        return PrivateUtils.newSymbolToken(string, n);
    }

    @Override
    public void setValue(String string) {
        if ("".equals(string)) {
            throw new EmptySymbolException();
        }
        super.setValue(string);
        this._sid = -1;
    }

    protected boolean isIonVersionMarker() {
        return this._isIVM();
    }

    @Override
    void clearSymbolIDValues() {
        super.clearSymbolIDValues();
        if (!this.isNullValue() && this._stringValue() != null) {
            this._sid = -1;
        }
    }

    protected void setIsIonVersionMarker(boolean bl) {
        assert ("$ion_1_0".equals(this._get_value()) == bl);
        this._isIVM(bl);
        this._isSystemValue(bl);
        this._sid = 2;
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        SymbolToken symbolToken = this.symbolValue(symbolTableProvider);
        ionWriter.writeSymbolToken(symbolToken);
    }

    @Override
    public String stringValue() throws UnknownSymbolException {
        return this.stringValue(new IonValueLite.LazySymbolTableProvider(this));
    }

    private String stringValue(PrivateIonValue.SymbolTableProvider symbolTableProvider) throws UnknownSymbolException {
        if (this.isNullValue()) {
            return null;
        }
        String string = this._stringValue(symbolTableProvider);
        if (string == null) {
            assert (this._sid > 0);
            throw new UnknownSymbolException(this._sid);
        }
        return string;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }
}

