/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.lite;

import java.io.IOException;
import software.amazon.ion.IonString;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.ValueVisitor;
import software.amazon.ion.impl.PrivateIonValue;
import software.amazon.ion.impl.lite.ContainerlessContext;
import software.amazon.ion.impl.lite.IonContext;
import software.amazon.ion.impl.lite.IonTextLite;

final class IonStringLite
extends IonTextLite
implements IonString {
    private static final int HASH_SIGNATURE = IonType.STRING.toString().hashCode();

    IonStringLite(ContainerlessContext containerlessContext, boolean bl) {
        super(containerlessContext, bl);
    }

    IonStringLite(IonStringLite ionStringLite, IonContext ionContext) {
        super(ionStringLite, ionContext);
    }

    @Override
    IonStringLite clone(IonContext ionContext) {
        return new IonStringLite(this, ionContext);
    }

    @Override
    public IonStringLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int n = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            n ^= this.stringValue().hashCode();
        }
        return this.hashTypeAnnotations(n, symbolTableProvider);
    }

    @Override
    public IonType getType() {
        return IonType.STRING;
    }

    @Override
    final void writeBodyTo(IonWriter ionWriter, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        ionWriter.writeString(this._get_value());
    }

    @Override
    public void accept(ValueVisitor valueVisitor) throws Exception {
        valueVisitor.visit(this);
    }
}

