/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import software.amazon.ion.Decimal;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonType;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.impl.bin.AbstractIonWriter;
import software.amazon.ion.impl.bin.BlockAllocator;
import software.amazon.ion.impl.bin.BlockAllocatorProvider;
import software.amazon.ion.impl.bin.Symbols;
import software.amazon.ion.impl.bin.WriteBuffer;

final class IonRawBinaryWriter
extends AbstractIonWriter {
    private static final byte[] IVM = IonRawBinaryWriter.bytes(224, 1, 0, 234);
    private static final byte[] NULLS;
    private static final byte NULL_NULL;
    private static final byte BOOL_FALSE = 16;
    private static final byte BOOL_TRUE = 17;
    private static final byte INT_ZERO = 32;
    private static final byte POS_INT_TYPE = 32;
    private static final byte NEG_INT_TYPE = 48;
    private static final byte FLOAT_TYPE = 64;
    private static final byte DECIMAL_TYPE = 80;
    private static final byte TIMESTAMP_TYPE = 96;
    private static final byte SYMBOL_TYPE = 112;
    private static final byte STRING_TYPE = -128;
    private static final byte CLOB_TYPE = -112;
    private static final byte BLOB_TYPE = -96;
    private static final byte DECIMAL_POS_ZERO = 80;
    private static final byte DECIMAL_NEGATIVE_ZERO_MANTISSA = -128;
    private static final BigInteger BIG_INT_LONG_MAX_VALUE;
    private static final BigInteger BIG_INT_LONG_MIN_VALUE;
    private static final byte VARINT_NEG_ZERO = -64;
    private static final byte STRING_TYPE_EXTENDED_LENGTH = -114;
    private static final byte[] STRING_TYPED_PREALLOCATED_2;
    private static final byte[] STRING_TYPED_PREALLOCATED_3;
    private static final int MAX_ANNOTATION_LENGTH = 127;
    private final BlockAllocator allocator;
    private final OutputStream out;
    private final StreamCloseMode streamCloseMode;
    private final StreamFlushMode streamFlushMode;
    private final PreallocationMode preallocationMode;
    private final boolean isFloatBinary32Enabled;
    private final WriteBuffer buffer;
    private final WriteBuffer patchBuffer;
    private final PatchList patchPoints;
    private final LinkedList<ContainerInfo> containers;
    private int depth;
    private boolean hasWrittenValuesSinceFinished;
    private boolean hasWrittenValuesSinceConstructed;
    private SymbolToken currentFieldName;
    private final List<SymbolToken> currentAnnotations;
    private boolean hasTopLevelSymbolTableAnnotation;
    private boolean closed;

    private static byte[] bytes(int ... nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return byArray;
    }

    private static final byte[] makeTypedPreallocatedBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        byArray[0] = (byte)n;
        if (n2 > 1) {
            byArray[n2 - 1] = -128;
        }
        return byArray;
    }

    private static byte[][] makeContainerTypedPreallocatedTable(int n) {
        IonType[] ionTypeArray = IonType.values();
        byte[][] byArrayArray = new byte[ionTypeArray.length][];
        byArrayArray[IonType.LIST.ordinal()] = IonRawBinaryWriter.makeTypedPreallocatedBytes(190, n);
        byArrayArray[IonType.SEXP.ordinal()] = IonRawBinaryWriter.makeTypedPreallocatedBytes(206, n);
        byArrayArray[IonType.STRUCT.ordinal()] = IonRawBinaryWriter.makeTypedPreallocatedBytes(222, n);
        return byArrayArray;
    }

    IonRawBinaryWriter(BlockAllocatorProvider blockAllocatorProvider, int n, OutputStream outputStream2, AbstractIonWriter.WriteValueOptimization writeValueOptimization, StreamCloseMode streamCloseMode, StreamFlushMode streamFlushMode, PreallocationMode preallocationMode, boolean bl) throws IOException {
        super(writeValueOptimization);
        if (outputStream2 == null) {
            throw new NullPointerException();
        }
        this.allocator = blockAllocatorProvider.vendAllocator(n);
        this.out = outputStream2;
        this.streamCloseMode = streamCloseMode;
        this.streamFlushMode = streamFlushMode;
        this.preallocationMode = preallocationMode;
        this.isFloatBinary32Enabled = bl;
        this.buffer = new WriteBuffer(this.allocator);
        this.patchBuffer = new WriteBuffer(this.allocator);
        this.patchPoints = new PatchList();
        this.containers = new LinkedList();
        this.depth = 0;
        this.hasWrittenValuesSinceFinished = false;
        this.hasWrittenValuesSinceConstructed = false;
        this.currentFieldName = null;
        this.currentAnnotations = new ArrayList<SymbolToken>();
        this.hasTopLevelSymbolTableAnnotation = false;
        this.closed = false;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return Symbols.systemSymbolTable();
    }

    @Override
    public void setFieldName(String string) {
        throw new UnsupportedOperationException("Cannot set field name on a low-level binary writer via string");
    }

    @Override
    public void setFieldNameSymbol(SymbolToken symbolToken) {
        if (!this.isInStruct()) {
            throw new IonException("Cannot set field name outside of struct context");
        }
        this.currentFieldName = symbolToken;
    }

    @Override
    public void setTypeAnnotations(String ... stringArray) {
        throw new UnsupportedOperationException("Cannot set annotations on a low-level binary writer via string");
    }

    @Override
    public void setTypeAnnotationSymbols(SymbolToken ... symbolTokenArray) {
        this.currentAnnotations.clear();
        this.hasTopLevelSymbolTableAnnotation = false;
        if (symbolTokenArray != null) {
            for (SymbolToken symbolToken : symbolTokenArray) {
                this.addTypeAnnotationSymbol(symbolToken);
            }
        }
    }

    @Override
    public void addTypeAnnotation(String string) {
        throw new UnsupportedOperationException("Cannot add annotations on a low-level binary writer via string");
    }

    void addTypeAnnotationSymbol(SymbolToken symbolToken) {
        if (this.depth == 0 && symbolToken.getSid() == 3) {
            this.hasTopLevelSymbolTableAnnotation = true;
        }
        this.currentAnnotations.add(symbolToken);
    }

    boolean hasAnnotations() {
        return !this.currentAnnotations.isEmpty();
    }

    boolean hasWrittenValuesSinceFinished() {
        return this.hasWrittenValuesSinceFinished;
    }

    boolean hasWrittenValuesSinceConstructed() {
        return this.hasWrittenValuesSinceConstructed;
    }

    boolean hasTopLevelSymbolTableAnnotation() {
        return this.hasTopLevelSymbolTableAnnotation;
    }

    int getFieldId() {
        return this.currentFieldName.getSid();
    }

    @Override
    public IonCatalog getCatalog() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFieldNameSet() {
        return this.currentFieldName != null;
    }

    @Override
    public void writeIonVersionMarker() throws IOException {
        this.buffer.writeBytes(IVM);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    private void updateLength(long l) {
        if (this.containers.isEmpty()) {
            return;
        }
        this.containers.getLast().length += l;
    }

    private void pushContainer(ContainerType containerType) {
        this.containers.add(new ContainerInfo(containerType, this.buffer.position() + 1L));
    }

    private ContainerInfo currentContainer() {
        return this.containers.isEmpty() ? null : this.containers.getLast();
    }

    private void addPatchPoint(long l, int n, long l2) {
        long l3 = this.patchBuffer.position();
        int n2 = this.patchBuffer.writeVarUInt(l2);
        PatchPoint patchPoint = new PatchPoint(l, n, l3, n2);
        ContainerInfo containerInfo = this.currentContainer();
        if (containerInfo == null) {
            this.patchPoints.append(patchPoint);
        } else {
            containerInfo.appendPatch(patchPoint);
        }
        this.updateLength(n2 - n);
    }

    private void extendPatchPoints(PatchList patchList) {
        ContainerInfo containerInfo = this.currentContainer();
        if (containerInfo == null) {
            this.patchPoints.extend(patchList);
        } else {
            containerInfo.extendPatches(patchList);
        }
    }

    private ContainerInfo popContainer() {
        ContainerInfo containerInfo = this.currentContainer();
        if (containerInfo == null) {
            throw new IllegalStateException("Tried to pop container state without said container");
        }
        this.containers.removeLast();
        long l = containerInfo.length;
        if (containerInfo.type != ContainerType.VALUE) {
            long l2 = containerInfo.position;
            if (containerInfo.length <= (long)this.preallocationMode.contentMaxLength && this.preallocationMode != PreallocationMode.PREALLOCATE_0) {
                this.preallocationMode.patchLength(this.buffer, l2, l);
            } else if (containerInfo.length <= 13L && this.preallocationMode == PreallocationMode.PREALLOCATE_0) {
                long l3 = l2 - 1L;
                long l4 = (long)(this.buffer.getUInt8At(l3) & 0xF0) | containerInfo.length;
                this.buffer.writeUInt8At(l3, l4);
            } else {
                this.addPatchPoint(l2, this.preallocationMode.typedLength - 1, l);
            }
        }
        if (containerInfo.patches != null) {
            this.extendPatchPoints(containerInfo.patches);
        }
        this.updateLength(l);
        return containerInfo;
    }

    private void writeVarUInt(long l) {
        if (l < 0L) {
            throw new IonException("Cannot write negative value as unsigned");
        }
        int n = this.buffer.writeVarUInt(l);
        this.updateLength(n);
    }

    private void writeVarInt(long l) {
        int n = this.buffer.writeVarInt(l);
        this.updateLength(n);
    }

    private static int checkSid(SymbolToken symbolToken) {
        int n = symbolToken.getSid();
        if (n < 1) {
            throw new IllegalArgumentException("Invalid symbol: " + symbolToken.getText() + " SID: " + n);
        }
        return n;
    }

    private void prepareValue() {
        if (this.isInStruct() && this.currentFieldName == null) {
            throw new IllegalStateException("IonWriter.setFieldName() must be called before writing a value into a struct.");
        }
        if (this.currentFieldName != null) {
            this.writeVarUInt(IonRawBinaryWriter.checkSid(this.currentFieldName));
            this.currentFieldName = null;
        }
        if (!this.currentAnnotations.isEmpty()) {
            this.updateLength(this.preallocationMode.typedLength);
            this.pushContainer(ContainerType.ANNOTATION);
            this.buffer.writeBytes(this.preallocationMode.annotationsTypedPreallocatedBytes);
            long l = this.buffer.position();
            this.buffer.writeVarUInt(0L);
            int n = 0;
            for (SymbolToken symbolToken : this.currentAnnotations) {
                int n2 = IonRawBinaryWriter.checkSid(symbolToken);
                int n3 = this.buffer.writeVarUInt(n2);
                n += n3;
            }
            if (n > 127) {
                throw new IonException("Annotations too large: " + this.currentAnnotations);
            }
            this.updateLength(1 + n);
            this.buffer.writeVarUIntDirect1At(l, n);
            this.currentAnnotations.clear();
            this.hasTopLevelSymbolTableAnnotation = false;
        }
    }

    private void finishValue() {
        ContainerInfo containerInfo = this.currentContainer();
        if (containerInfo != null && containerInfo.type == ContainerType.ANNOTATION) {
            this.popContainer();
        }
        this.hasWrittenValuesSinceFinished = true;
        this.hasWrittenValuesSinceConstructed = true;
    }

    @Override
    public void stepIn(IonType ionType) throws IOException {
        if (!IonType.isContainer(ionType)) {
            throw new IonException("Cannot step into " + (Object)((Object)ionType));
        }
        this.prepareValue();
        this.updateLength(this.preallocationMode.typedLength);
        this.pushContainer(ionType == IonType.STRUCT ? ContainerType.STRUCT : ContainerType.SEQUENCE);
        ++this.depth;
        this.buffer.writeBytes(this.preallocationMode.containerTypedPreallocatedBytes[ionType.ordinal()]);
    }

    @Override
    public void stepOut() throws IOException {
        if (this.currentFieldName != null) {
            throw new IonException("Cannot step out with field name set");
        }
        if (!this.currentAnnotations.isEmpty()) {
            throw new IonException("Cannot step out with field name set");
        }
        ContainerInfo containerInfo = this.currentContainer();
        if (containerInfo == null || !containerInfo.type.allowedInStepOut) {
            throw new IonException("Cannot step out when not in container");
        }
        this.popContainer();
        --this.depth;
        this.finishValue();
    }

    @Override
    public boolean isInStruct() {
        return !this.containers.isEmpty() && this.currentContainer().type == ContainerType.STRUCT;
    }

    @Override
    public void writeNull() throws IOException {
        this.prepareValue();
        this.updateLength(1L);
        this.buffer.writeByte(NULL_NULL);
        this.finishValue();
    }

    @Override
    public void writeNull(IonType ionType) throws IOException {
        byte by = NULL_NULL;
        if (ionType != null && (by = NULLS[ionType.ordinal()]) == 0) {
            throw new IllegalArgumentException("Cannot write a null for: " + (Object)((Object)ionType));
        }
        this.prepareValue();
        this.updateLength(1L);
        this.buffer.writeByte(by);
        this.finishValue();
    }

    @Override
    public void writeBool(boolean bl) throws IOException {
        this.prepareValue();
        this.updateLength(1L);
        if (bl) {
            this.buffer.writeByte((byte)17);
        } else {
            this.buffer.writeByte((byte)16);
        }
        this.finishValue();
    }

    private void writeTypedUInt(int n, long l) {
        if (l <= 255L) {
            this.updateLength(2L);
            this.buffer.writeUInt8(n | 1);
            this.buffer.writeUInt8(l);
        } else if (l <= 65535L) {
            this.updateLength(3L);
            this.buffer.writeUInt8(n | 2);
            this.buffer.writeUInt16(l);
        } else if (l <= 0xFFFFFFL) {
            this.updateLength(4L);
            this.buffer.writeUInt8(n | 3);
            this.buffer.writeUInt24(l);
        } else if (l <= 0xFFFFFFFFL) {
            this.updateLength(5L);
            this.buffer.writeUInt8(n | 4);
            this.buffer.writeUInt32(l);
        } else if (l <= 0xFFFFFFFFFFL) {
            this.updateLength(6L);
            this.buffer.writeUInt8(n | 5);
            this.buffer.writeUInt40(l);
        } else if (l <= 0xFFFFFFFFFFFFL) {
            this.updateLength(7L);
            this.buffer.writeUInt8(n | 6);
            this.buffer.writeUInt48(l);
        } else if (l <= 0xFFFFFFFFFFFFFFL) {
            this.updateLength(8L);
            this.buffer.writeUInt8(n | 7);
            this.buffer.writeUInt56(l);
        } else {
            this.updateLength(9L);
            this.buffer.writeUInt8(n | 8);
            this.buffer.writeUInt64(l);
        }
    }

    @Override
    public void writeInt(long l) throws IOException {
        this.prepareValue();
        if (l == 0L) {
            this.updateLength(1L);
            this.buffer.writeByte((byte)32);
        } else {
            int n = 32;
            if (l < 0L) {
                n = 48;
                if (l == Long.MIN_VALUE) {
                    this.updateLength(9L);
                    this.buffer.writeUInt8(56L);
                    this.buffer.writeUInt64(l);
                } else {
                    l = -l;
                    this.writeTypedUInt(n, l);
                }
            } else {
                this.writeTypedUInt(n, l);
            }
        }
        this.finishValue();
    }

    private void writeTypedBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = 1 + n3;
        if (n3 < 14) {
            this.buffer.writeUInt8(n | n3);
        } else {
            this.buffer.writeUInt8(n | 0xE);
            int n5 = this.buffer.writeVarUInt(n3);
            n4 += n5;
        }
        this.updateLength(n4);
        this.buffer.writeBytes(byArray, n2, n3);
    }

    @Override
    public void writeInt(BigInteger bigInteger) throws IOException {
        if (bigInteger == null) {
            this.writeNull(IonType.INT);
            return;
        }
        if (bigInteger.compareTo(BIG_INT_LONG_MIN_VALUE) >= 0 && bigInteger.compareTo(BIG_INT_LONG_MAX_VALUE) <= 0) {
            this.writeInt(bigInteger.longValue());
            return;
        }
        this.prepareValue();
        int n = 32;
        if (bigInteger.signum() < 0) {
            n = 48;
            bigInteger = bigInteger.negate();
        }
        byte[] byArray = bigInteger.toByteArray();
        this.writeTypedBytes(n, byArray, 0, byArray.length);
        this.finishValue();
    }

    @Override
    public void writeFloat(double d) throws IOException {
        this.prepareValue();
        if (this.isFloatBinary32Enabled && d == (double)((float)d)) {
            this.updateLength(5L);
            this.buffer.writeUInt8(68L);
            this.buffer.writeUInt32(Float.floatToRawIntBits((float)d));
        } else {
            this.updateLength(9L);
            this.buffer.writeUInt8(72L);
            this.buffer.writeUInt64(Double.doubleToRawLongBits(d));
        }
        this.finishValue();
    }

    private void writeDecimalValue(BigDecimal bigDecimal) {
        boolean bl = Decimal.isNegativeZero(bigDecimal);
        int n = bigDecimal.signum();
        int n2 = -bigDecimal.scale();
        this.writeVarInt(n2);
        BigInteger bigInteger = bigDecimal.unscaledValue();
        if (bigInteger.compareTo(BIG_INT_LONG_MIN_VALUE) >= 0 && bigInteger.compareTo(BIG_INT_LONG_MAX_VALUE) <= 0) {
            long l = bigInteger.longValue();
            if (n != 0 || bl) {
                if (bl) {
                    this.updateLength(1L);
                    this.buffer.writeByte((byte)-128);
                } else if (l == Long.MIN_VALUE) {
                    this.updateLength(9L);
                    this.buffer.writeUInt8(128L);
                    this.buffer.writeUInt64(l);
                } else if (l >= -127L && l <= 127L) {
                    this.updateLength(1L);
                    this.buffer.writeInt8(l);
                } else if (l >= -32767L && l <= 32767L) {
                    this.updateLength(2L);
                    this.buffer.writeInt16(l);
                } else if (l >= -8388607L && l <= 0x7FFFFFL) {
                    this.updateLength(3L);
                    this.buffer.writeInt24(l);
                } else if (l >= -2147483647L && l <= Integer.MAX_VALUE) {
                    this.updateLength(4L);
                    this.buffer.writeInt32(l);
                } else if (l >= -549755813887L && l <= 0x7FFFFFFFFFL) {
                    this.updateLength(5L);
                    this.buffer.writeInt40(l);
                } else if (l >= -140737488355327L && l <= 0x7FFFFFFFFFFFL) {
                    this.updateLength(6L);
                    this.buffer.writeInt48(l);
                } else if (l >= -36028797018963967L && l <= 0x7FFFFFFFFFFFFFL) {
                    this.updateLength(7L);
                    this.buffer.writeInt56(l);
                } else {
                    this.updateLength(8L);
                    this.buffer.writeInt64(l);
                }
            }
        } else {
            BigInteger bigInteger2 = n > 0 ? bigInteger : bigInteger.negate();
            byte[] byArray = bigInteger2.toByteArray();
            if (n < 0) {
                if ((byArray[0] & 0x80) == 0) {
                    byArray[0] = (byte)(byArray[0] | 0x80);
                } else {
                    this.updateLength(1L);
                    this.buffer.writeUInt8(128L);
                }
            }
            this.updateLength(byArray.length);
            this.buffer.writeBytes(byArray);
        }
    }

    private void patchSingleByteTypedOptimisticValue(byte by, ContainerInfo containerInfo) {
        if (containerInfo.length <= 13L) {
            this.buffer.writeUInt8At(containerInfo.position - 1L, (long)by | containerInfo.length);
        } else {
            this.buffer.writeUInt8At(containerInfo.position - 1L, by | 0xE);
            this.addPatchPoint(containerInfo.position, 0, containerInfo.length);
        }
    }

    @Override
    public void writeDecimal(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            this.writeNull(IonType.DECIMAL);
            return;
        }
        this.prepareValue();
        if (bigDecimal.signum() == 0 && bigDecimal.scale() == 0 && !Decimal.isNegativeZero(bigDecimal)) {
            this.updateLength(1L);
            this.buffer.writeUInt8(80L);
        } else {
            this.updateLength(1L);
            this.pushContainer(ContainerType.VALUE);
            this.buffer.writeByte((byte)80);
            this.writeDecimalValue(bigDecimal);
            ContainerInfo containerInfo = this.popContainer();
            this.patchSingleByteTypedOptimisticValue((byte)80, containerInfo);
        }
        this.finishValue();
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws IOException {
        int n;
        if (timestamp == null) {
            this.writeNull(IonType.TIMESTAMP);
            return;
        }
        this.prepareValue();
        this.updateLength(1L);
        this.pushContainer(ContainerType.VALUE);
        this.buffer.writeByte((byte)96);
        Integer n2 = timestamp.getLocalOffset();
        if (n2 == null) {
            this.updateLength(1L);
            this.buffer.writeByte((byte)-64);
        } else {
            this.writeVarInt(n2.intValue());
        }
        int n3 = timestamp.getZYear();
        this.writeVarUInt(n3);
        int n4 = timestamp.getPrecision().ordinal();
        if (n4 >= Timestamp.Precision.MONTH.ordinal()) {
            n = timestamp.getZMonth();
            this.writeVarUInt(n);
        }
        if (n4 >= Timestamp.Precision.DAY.ordinal()) {
            n = timestamp.getZDay();
            this.writeVarUInt(n);
        }
        if (n4 >= Timestamp.Precision.MINUTE.ordinal()) {
            n = timestamp.getZHour();
            this.writeVarUInt(n);
            int n5 = timestamp.getZMinute();
            this.writeVarUInt(n5);
        }
        if (n4 >= Timestamp.Precision.SECOND.ordinal()) {
            n = timestamp.getZSecond();
            this.writeVarUInt(n);
            BigDecimal bigDecimal = timestamp.getZFractionalSecond();
            if (bigDecimal != null && !BigDecimal.ZERO.equals(bigDecimal)) {
                this.writeDecimalValue(bigDecimal);
            }
        }
        ContainerInfo containerInfo = this.popContainer();
        this.patchSingleByteTypedOptimisticValue((byte)96, containerInfo);
        this.finishValue();
    }

    @Override
    public void writeSymbol(String string) throws IOException {
        throw new UnsupportedOperationException("Symbol writing via string is not supported in low-level binary writer");
    }

    @Override
    public void writeSymbolToken(SymbolToken symbolToken) throws IOException {
        if (symbolToken == null) {
            this.writeNull(IonType.SYMBOL);
            return;
        }
        int n = IonRawBinaryWriter.checkSid(symbolToken);
        this.prepareValue();
        this.writeTypedUInt(112, n);
        this.finishValue();
    }

    @Override
    public void writeString(String string) throws IOException {
        if (string == null) {
            this.writeNull(IonType.STRING);
            return;
        }
        this.prepareValue();
        int n = string.length();
        int n2 = 1;
        long l = this.buffer.position() + 1L;
        if (n <= 13) {
            n = 13;
            this.buffer.writeUInt8(-128L);
        } else if (n <= 127) {
            n = 127;
            n2 = 2;
            this.buffer.writeBytes(STRING_TYPED_PREALLOCATED_2);
        } else {
            n = 16383;
            n2 = 3;
            this.buffer.writeBytes(STRING_TYPED_PREALLOCATED_3);
        }
        this.updateLength(n2);
        int n3 = this.buffer.writeUTF8(string);
        if (n3 <= n) {
            if (n3 <= 13) {
                this.buffer.writeUInt8At(l - 1L, 0xFFFFFF80 | n3);
            } else if (n3 <= 127) {
                this.buffer.writeVarUIntDirect1At(l, n3);
            } else {
                this.buffer.writeVarUIntDirect2At(l, n3);
            }
        } else {
            if (n == 13) {
                this.buffer.writeUInt8At(l - 1L, -114L);
            }
            this.addPatchPoint(l, n2 - 1, n3);
        }
        this.updateLength(n3);
        this.finishValue();
    }

    @Override
    public void writeClob(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeNull(IonType.CLOB);
            return;
        }
        this.writeClob(byArray, 0, byArray.length);
    }

    @Override
    public void writeClob(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.writeNull(IonType.CLOB);
            return;
        }
        this.prepareValue();
        this.writeTypedBytes(-112, byArray, n, n2);
        this.finishValue();
    }

    @Override
    public void writeBlob(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeNull(IonType.BLOB);
            return;
        }
        this.writeBlob(byArray, 0, byArray.length);
    }

    @Override
    public void writeBlob(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.writeNull(IonType.BLOB);
            return;
        }
        this.prepareValue();
        this.writeTypedBytes(-96, byArray, n, n2);
        this.finishValue();
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.prepareValue();
        this.updateLength(n2);
        this.buffer.writeBytes(byArray, n, n2);
        this.finishValue();
    }

    long position() {
        return this.buffer.position();
    }

    void truncate(long l) {
        this.buffer.truncate(l);
        PatchPoint patchPoint = this.patchPoints.truncate(l);
        if (patchPoint != null) {
            this.patchBuffer.truncate(patchPoint.patchPosition);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void finish() throws IOException {
        if (!this.containers.isEmpty()) {
            throw new IllegalStateException("Cannot finish within container: " + this.containers);
        }
        if (this.patchPoints.isEmpty()) {
            this.buffer.writeTo(this.out);
        } else {
            long l = 0L;
            for (PatchPoint patchPoint : this.patchPoints) {
                long l2 = patchPoint.oldPosition - l;
                this.buffer.writeTo(this.out, l, l2);
                this.patchBuffer.writeTo(this.out, patchPoint.patchPosition, patchPoint.patchLength);
                l = patchPoint.oldPosition;
                l += (long)patchPoint.oldLength;
            }
            this.buffer.writeTo(this.out, l, this.buffer.position() - l);
        }
        this.patchPoints.clear();
        this.patchBuffer.reset();
        this.buffer.reset();
        if (this.streamFlushMode == StreamFlushMode.FLUSH) {
            this.out.flush();
        }
        this.hasWrittenValuesSinceFinished = false;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            try {
                this.finish();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.buffer.close();
            this.patchBuffer.close();
            this.allocator.close();
        }
        finally {
            if (this.streamCloseMode == StreamCloseMode.CLOSE) {
                this.out.close();
            }
        }
    }

    static {
        IonType[] ionTypeArray = IonType.values();
        NULLS = new byte[ionTypeArray.length];
        IonRawBinaryWriter.NULLS[IonType.NULL.ordinal()] = 15;
        IonRawBinaryWriter.NULLS[IonType.BOOL.ordinal()] = 31;
        IonRawBinaryWriter.NULLS[IonType.INT.ordinal()] = 47;
        IonRawBinaryWriter.NULLS[IonType.FLOAT.ordinal()] = 79;
        IonRawBinaryWriter.NULLS[IonType.DECIMAL.ordinal()] = 95;
        IonRawBinaryWriter.NULLS[IonType.TIMESTAMP.ordinal()] = 111;
        IonRawBinaryWriter.NULLS[IonType.SYMBOL.ordinal()] = 127;
        IonRawBinaryWriter.NULLS[IonType.STRING.ordinal()] = -113;
        IonRawBinaryWriter.NULLS[IonType.CLOB.ordinal()] = -97;
        IonRawBinaryWriter.NULLS[IonType.BLOB.ordinal()] = -81;
        IonRawBinaryWriter.NULLS[IonType.LIST.ordinal()] = -65;
        IonRawBinaryWriter.NULLS[IonType.SEXP.ordinal()] = -49;
        IonRawBinaryWriter.NULLS[IonType.STRUCT.ordinal()] = -33;
        NULL_NULL = NULLS[IonType.NULL.ordinal()];
        BIG_INT_LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
        BIG_INT_LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
        STRING_TYPED_PREALLOCATED_2 = IonRawBinaryWriter.makeTypedPreallocatedBytes(142, 2);
        STRING_TYPED_PREALLOCATED_3 = IonRawBinaryWriter.makeTypedPreallocatedBytes(142, 3);
    }

    static enum StreamFlushMode {
        NO_FLUSH,
        FLUSH;

    }

    static enum StreamCloseMode {
        NO_CLOSE,
        CLOSE;

    }

    private static class PatchList
    implements Iterable<PatchPoint> {
        private Node head = null;
        private Node tail = null;

        public boolean isEmpty() {
            return this.head == null && this.tail == null;
        }

        public void clear() {
            this.head = null;
            this.tail = null;
        }

        public void append(PatchPoint patchPoint) {
            Node node = new Node(patchPoint);
            if (this.head == null) {
                this.head = node;
                this.tail = node;
            } else {
                this.tail.next = node;
                this.tail = node;
            }
        }

        public void extend(PatchList patchList) {
            if (patchList != null) {
                if (this.head == null) {
                    if (patchList.head != null) {
                        this.head = patchList.head;
                        this.tail = patchList.tail;
                    }
                } else {
                    this.tail.next = patchList.head;
                    this.tail = patchList.tail;
                }
            }
        }

        public PatchPoint truncate(long l) {
            Node node = null;
            Node node2 = this.head;
            while (node2 != null) {
                PatchPoint patchPoint = node2.value;
                if (patchPoint.oldPosition >= l) {
                    this.tail = node;
                    if (this.tail == null) {
                        this.head = null;
                    } else {
                        this.tail.next = null;
                    }
                    return patchPoint;
                }
                node = node2;
                node2 = node2.next;
            }
            return null;
        }

        @Override
        public Iterator<PatchPoint> iterator() {
            return new Iterator<PatchPoint>(){
                Node curr;
                {
                    this.curr = head;
                }

                @Override
                public boolean hasNext() {
                    return this.curr != null;
                }

                @Override
                public PatchPoint next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    PatchPoint patchPoint = this.curr.value;
                    this.curr = this.curr.next;
                    return patchPoint;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(PATCHES");
            for (PatchPoint patchPoint : this) {
                stringBuilder.append(" ");
                stringBuilder.append(patchPoint);
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        private static class Node {
            public final PatchPoint value;
            public Node next;

            public Node(PatchPoint patchPoint) {
                this.value = patchPoint;
            }
        }
    }

    private static class PatchPoint {
        public final long oldPosition;
        public final int oldLength;
        public final long patchPosition;
        public final int patchLength;

        public PatchPoint(long l, int n, long l2, int n2) {
            this.oldPosition = l;
            this.oldLength = n;
            this.patchPosition = l2;
            this.patchLength = n2;
        }

        public String toString() {
            return "(PP old::(" + this.oldPosition + " " + this.oldLength + ") patch::(" + this.patchPosition + " " + this.patchLength + ")";
        }
    }

    private static class ContainerInfo {
        public final ContainerType type;
        public final long position;
        public long length;
        public PatchList patches;

        public ContainerInfo(ContainerType containerType, long l) {
            this.type = containerType;
            this.position = l;
            this.patches = null;
        }

        public void appendPatch(PatchPoint patchPoint) {
            if (this.patches == null) {
                this.patches = new PatchList();
            }
            this.patches.append(patchPoint);
        }

        public void extendPatches(PatchList patchList) {
            if (this.patches == null) {
                this.patches = patchList;
            } else {
                this.patches.extend(patchList);
            }
        }

        public String toString() {
            return "(CI " + (Object)((Object)this.type) + " pos:" + this.position + " len:" + this.length + ")";
        }
    }

    private static enum ContainerType {
        SEQUENCE(true),
        STRUCT(true),
        VALUE(false),
        ANNOTATION(false);

        public final boolean allowedInStepOut;

        private ContainerType(boolean bl) {
            this.allowedInStepOut = bl;
        }
    }

    static enum PreallocationMode {
        PREALLOCATE_0(0, 1){

            @Override
            void patchLength(WriteBuffer writeBuffer, long l, long l2) {
                throw new IllegalStateException("Cannot patch in PREALLOCATE 0 mode");
            }
        }
        ,
        PREALLOCATE_1(127, 2){

            @Override
            void patchLength(WriteBuffer writeBuffer, long l, long l2) {
                writeBuffer.writeVarUIntDirect1At(l, l2);
            }
        }
        ,
        PREALLOCATE_2(16383, 3){

            @Override
            void patchLength(WriteBuffer writeBuffer, long l, long l2) {
                writeBuffer.writeVarUIntDirect2At(l, l2);
            }
        };

        private final int contentMaxLength;
        private final int typedLength;
        private final byte[][] containerTypedPreallocatedBytes;
        private final byte[] annotationsTypedPreallocatedBytes;

        private PreallocationMode(int n2, int n3) {
            this.contentMaxLength = n2;
            this.typedLength = n3;
            this.containerTypedPreallocatedBytes = IonRawBinaryWriter.makeContainerTypedPreallocatedTable(n3);
            this.annotationsTypedPreallocatedBytes = IonRawBinaryWriter.makeTypedPreallocatedBytes(238, n3);
        }

        abstract void patchLength(WriteBuffer var1, long var2, long var4);

        static PreallocationMode withPadSize(int n) {
            switch (n) {
                case 0: {
                    return PREALLOCATE_0;
                }
                case 1: {
                    return PREALLOCATE_1;
                }
                case 2: {
                    return PREALLOCATE_2;
                }
            }
            throw new IllegalArgumentException("No such preallocation mode for: " + n);
        }
    }
}

