/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.ion.EmptySymbolException;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonType;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.bin.AbstractIonWriter;
import software.amazon.ion.impl.bin.AbstractSymbolTable;
import software.amazon.ion.impl.bin.IonRawBinaryWriter;
import software.amazon.ion.impl.bin.PrivateIonManagedBinaryWriterBuilder;
import software.amazon.ion.impl.bin.Symbols;

final class IonManagedBinaryWriter
extends AbstractIonWriter {
    static final ImportedSymbolContext ONLY_SYSTEM_IMPORTS = new ImportedSymbolContext(ImportedSymbolResolverMode.FLAT, Collections.emptyList());
    private static final SymbolTable[] EMPTY_SYMBOL_TABLE_ARRAY = new SymbolTable[0];
    private final IonCatalog catalog;
    private final ImportedSymbolContext bootstrapImports;
    private ImportedSymbolContext imports;
    private final Map<String, SymbolToken> locals;
    private boolean localsLocked;
    private SymbolTable localSymbolTableView;
    private final IonRawBinaryWriter symbols;
    private final IonRawBinaryWriter user;
    private UserState userState;
    private SymbolState symbolState;
    private long userSymbolTablePosition;
    private final List<SymbolTable> userImports;
    private final List<String> userSymbols;
    private final ImportDescriptor userCurrentImport;
    private boolean forceSystemOutput;
    private boolean closed;

    IonManagedBinaryWriter(PrivateIonManagedBinaryWriterBuilder privateIonManagedBinaryWriterBuilder, OutputStream outputStream2) throws IOException {
        super(privateIonManagedBinaryWriterBuilder.optimization);
        this.symbols = new IonRawBinaryWriter(privateIonManagedBinaryWriterBuilder.provider, privateIonManagedBinaryWriterBuilder.symbolsBlockSize, outputStream2, AbstractIonWriter.WriteValueOptimization.NONE, IonRawBinaryWriter.StreamCloseMode.NO_CLOSE, IonRawBinaryWriter.StreamFlushMode.NO_FLUSH, privateIonManagedBinaryWriterBuilder.preallocationMode, privateIonManagedBinaryWriterBuilder.isFloatBinary32Enabled);
        this.user = new IonRawBinaryWriter(privateIonManagedBinaryWriterBuilder.provider, privateIonManagedBinaryWriterBuilder.userBlockSize, outputStream2, AbstractIonWriter.WriteValueOptimization.NONE, IonRawBinaryWriter.StreamCloseMode.CLOSE, IonRawBinaryWriter.StreamFlushMode.FLUSH, privateIonManagedBinaryWriterBuilder.preallocationMode, privateIonManagedBinaryWriterBuilder.isFloatBinary32Enabled);
        this.catalog = privateIonManagedBinaryWriterBuilder.catalog;
        this.bootstrapImports = privateIonManagedBinaryWriterBuilder.imports;
        this.locals = new LinkedHashMap<String, SymbolToken>();
        this.localsLocked = false;
        this.localSymbolTableView = new LocalSymbolTableView();
        this.symbolState = SymbolState.SYSTEM_SYMBOLS;
        this.forceSystemOutput = false;
        this.closed = false;
        this.userState = UserState.NORMAL;
        this.userSymbolTablePosition = 0L;
        this.userImports = new ArrayList<SymbolTable>();
        this.userSymbols = new ArrayList<String>();
        this.userCurrentImport = new ImportDescriptor();
        SymbolTable symbolTable = privateIonManagedBinaryWriterBuilder.initialSymbolTable;
        if (symbolTable != null) {
            ImportedSymbolContext importedSymbolContext;
            List<SymbolTable> list = Arrays.asList(symbolTable.getImportedTables());
            this.imports = importedSymbolContext = new ImportedSymbolContext(ImportedSymbolResolverMode.DELEGATE, list);
            Iterator<String> iterator2 = symbolTable.iterateDeclaredSymbolNames();
            while (iterator2.hasNext()) {
                String string = iterator2.next();
                this.intern(string);
            }
            this.startLocalSymbolTableIfNeeded(true);
        } else {
            this.imports = privateIonManagedBinaryWriterBuilder.imports;
        }
    }

    @Override
    public IonCatalog getCatalog() {
        return this.catalog;
    }

    @Override
    public boolean isFieldNameSet() {
        return this.user.isFieldNameSet();
    }

    @Override
    public void writeIonVersionMarker() throws IOException {
        this.finish();
    }

    @Override
    public int getDepth() {
        return this.user.getDepth();
    }

    private void startLocalSymbolTableIfNeeded(boolean bl) throws IOException {
        if (this.symbolState == SymbolState.SYSTEM_SYMBOLS) {
            if (bl) {
                this.symbols.writeIonVersionMarker();
            }
            this.symbols.addTypeAnnotationSymbol(Symbols.systemSymbol(3));
            this.symbols.stepIn(IonType.STRUCT);
            if (this.imports.parents.size() > 0) {
                this.symbols.setFieldNameSymbol(Symbols.systemSymbol(6));
                this.symbols.stepIn(IonType.LIST);
                for (SymbolTable symbolTable : this.imports.parents) {
                    this.symbols.stepIn(IonType.STRUCT);
                    this.symbols.setFieldNameSymbol(Symbols.systemSymbol(4));
                    this.symbols.writeString(symbolTable.getName());
                    this.symbols.setFieldNameSymbol(Symbols.systemSymbol(5));
                    this.symbols.writeInt(symbolTable.getVersion());
                    this.symbols.setFieldNameSymbol(Symbols.systemSymbol(8));
                    this.symbols.writeInt(symbolTable.getMaxId());
                    this.symbols.stepOut();
                }
                this.symbols.stepOut();
            }
            this.symbolState = SymbolState.LOCAL_SYMBOLS_WITH_IMPORTS_ONLY;
        }
    }

    private void startLocalSymbolTableSymbolListIfNeeded() throws IOException {
        if (this.symbolState == SymbolState.LOCAL_SYMBOLS_WITH_IMPORTS_ONLY) {
            this.symbols.setFieldNameSymbol(Symbols.systemSymbol(7));
            this.symbols.stepIn(IonType.LIST);
            this.symbolState = SymbolState.LOCAL_SYMBOLS;
        }
    }

    private SymbolToken intern(String string) {
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            throw new EmptySymbolException();
        }
        try {
            SymbolToken symbolToken = this.imports.importedSymbols.get(string);
            if (symbolToken != null) {
                if (symbolToken.getSid() > 9) {
                    this.startLocalSymbolTableIfNeeded(true);
                }
                return symbolToken;
            }
            symbolToken = this.locals.get(string);
            if (symbolToken == null) {
                if (this.localsLocked) {
                    throw new IonException("Local symbol table was locked (made read-only)");
                }
                this.startLocalSymbolTableIfNeeded(true);
                this.startLocalSymbolTableSymbolListIfNeeded();
                symbolToken = Symbols.symbol(string, this.imports.localSidStart + this.locals.size());
                this.locals.put(string, symbolToken);
                this.symbols.writeString(string);
            }
            return symbolToken;
        }
        catch (IOException iOException) {
            throw new IonException("Error synthesizing symbols", iOException);
        }
    }

    private SymbolToken intern(SymbolToken symbolToken) {
        if (symbolToken == null) {
            return null;
        }
        String string = symbolToken.getText();
        if (string != null) {
            return this.intern(string);
        }
        return symbolToken;
    }

    @Override
    public SymbolTable getSymbolTable() {
        if (this.symbolState == SymbolState.SYSTEM_SYMBOLS && this.imports.parents.isEmpty()) {
            return Symbols.systemSymbolTable();
        }
        return this.localSymbolTableView;
    }

    @Override
    public void setFieldName(String string) {
        if (!this.isInStruct()) {
            throw new IllegalStateException("IonWriter.setFieldName() must be called before writing a value into a struct.");
        }
        if (string == null) {
            throw new NullPointerException("Null field name is not allowed.");
        }
        SymbolToken symbolToken = this.intern(string);
        this.user.setFieldNameSymbol(symbolToken);
    }

    @Override
    public void setFieldNameSymbol(SymbolToken symbolToken) {
        symbolToken = this.intern(symbolToken);
        this.user.setFieldNameSymbol(symbolToken);
    }

    @Override
    public void setTypeAnnotations(String ... stringArray) {
        if (stringArray == null) {
            this.user.setTypeAnnotationSymbols(null);
        } else {
            SymbolToken[] symbolTokenArray = new SymbolToken[stringArray.length];
            for (int i = 0; i < symbolTokenArray.length; ++i) {
                symbolTokenArray[i] = this.intern(stringArray[i]);
            }
            this.user.setTypeAnnotationSymbols(symbolTokenArray);
        }
    }

    @Override
    public void setTypeAnnotationSymbols(SymbolToken ... symbolTokenArray) {
        if (symbolTokenArray == null) {
            this.user.setTypeAnnotationSymbols(null);
        } else {
            for (int i = 0; i < symbolTokenArray.length; ++i) {
                symbolTokenArray[i] = this.intern(symbolTokenArray[i]);
            }
            this.user.setTypeAnnotationSymbols(symbolTokenArray);
        }
    }

    @Override
    public void addTypeAnnotation(String string) {
        SymbolToken symbolToken = this.intern(string);
        this.user.addTypeAnnotationSymbol(symbolToken);
    }

    @Override
    public void stepIn(IonType ionType) throws IOException {
        this.userState.beforeStepIn(this, ionType);
        this.user.stepIn(ionType);
    }

    @Override
    public void stepOut() throws IOException {
        this.user.stepOut();
        this.userState.afterStepOut(this);
    }

    @Override
    public boolean isInStruct() {
        return this.user.isInStruct();
    }

    @Override
    public void writeNull() throws IOException {
        this.user.writeNull();
    }

    @Override
    public void writeNull(IonType ionType) throws IOException {
        this.user.writeNull(ionType);
    }

    @Override
    public void writeBool(boolean bl) throws IOException {
        this.user.writeBool(bl);
    }

    @Override
    public void writeInt(long l) throws IOException {
        this.userState.writeInt(this, l);
        this.user.writeInt(l);
    }

    @Override
    public void writeInt(BigInteger bigInteger) throws IOException {
        this.userState.writeInt(this, bigInteger);
        this.user.writeInt(bigInteger);
    }

    @Override
    public void writeFloat(double d) throws IOException {
        this.user.writeFloat(d);
    }

    @Override
    public void writeDecimal(BigDecimal bigDecimal) throws IOException {
        this.user.writeDecimal(bigDecimal);
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws IOException {
        this.user.writeTimestamp(timestamp);
    }

    @Override
    public void writeSymbol(String string) throws IOException {
        SymbolToken symbolToken = this.intern(string);
        this.writeSymbolToken(symbolToken);
    }

    @Override
    public void writeSymbolToken(SymbolToken symbolToken) throws IOException {
        if ((symbolToken = this.intern(symbolToken)) != null && symbolToken.getSid() == 2 && this.user.getDepth() == 0 && !this.user.hasAnnotations()) {
            if (this.user.hasWrittenValuesSinceFinished()) {
                this.finish();
            } else {
                this.forceSystemOutput = true;
            }
            return;
        }
        this.user.writeSymbolToken(symbolToken);
    }

    @Override
    public void writeString(String string) throws IOException {
        this.userState.writeString(this, string);
        this.user.writeString(string);
    }

    @Override
    public void writeClob(byte[] byArray) throws IOException {
        this.user.writeClob(byArray);
    }

    @Override
    public void writeClob(byte[] byArray, int n, int n2) throws IOException {
        this.user.writeClob(byArray, n, n2);
    }

    @Override
    public void writeBlob(byte[] byArray) throws IOException {
        this.user.writeBlob(byArray);
    }

    @Override
    public void writeBlob(byte[] byArray, int n, int n2) throws IOException {
        this.user.writeBlob(byArray, n, n2);
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.startLocalSymbolTableIfNeeded(true);
        this.user.writeBytes(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        if (this.getDepth() == 0 && this.localsLocked) {
            this.unsafeFlush();
        }
    }

    private void unsafeFlush() throws IOException {
        if (this.user.hasWrittenValuesSinceFinished() || this.forceSystemOutput) {
            this.symbolState.closeTable(this.symbols);
        }
        this.symbolState = SymbolState.LOCAL_SYMBOLS_FLUSHED;
        this.forceSystemOutput = false;
        this.symbols.finish();
        this.user.finish();
    }

    @Override
    public void finish() throws IOException {
        if (this.getDepth() != 0) {
            throw new IllegalStateException("IonWriter.finish() can only be called at top-level.");
        }
        this.unsafeFlush();
        this.locals.clear();
        this.localsLocked = false;
        this.symbolState = SymbolState.SYSTEM_SYMBOLS;
        this.imports = this.bootstrapImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.finish();
        }
        catch (IllegalStateException illegalStateException) {
            try {
                this.symbols.close();
            }
            finally {
                this.user.close();
            }
        }
        finally {
            try {
                this.symbols.close();
            }
            finally {
                this.user.close();
            }
        }
    }

    private class LocalSymbolTableView
    extends AbstractSymbolTable {
        public LocalSymbolTableView() {
            super(null, 0);
        }

        @Override
        public Iterator<String> iterateDeclaredSymbolNames() {
            return IonManagedBinaryWriter.this.locals.keySet().iterator();
        }

        @Override
        public int getMaxId() {
            return this.getImportedMaxId() + IonManagedBinaryWriter.this.locals.size();
        }

        @Override
        public SymbolTable[] getImportedTables() {
            return ((IonManagedBinaryWriter)IonManagedBinaryWriter.this).imports.parents.toArray(EMPTY_SYMBOL_TABLE_ARRAY);
        }

        @Override
        public int getImportedMaxId() {
            return ((IonManagedBinaryWriter)IonManagedBinaryWriter.this).imports.localSidStart - 1;
        }

        @Override
        public boolean isSystemTable() {
            return false;
        }

        @Override
        public boolean isSubstitute() {
            return false;
        }

        @Override
        public boolean isSharedTable() {
            return false;
        }

        @Override
        public boolean isLocalTable() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return IonManagedBinaryWriter.this.localsLocked;
        }

        @Override
        public SymbolTable getSystemSymbolTable() {
            return Symbols.systemSymbolTable();
        }

        @Override
        public SymbolToken intern(String string) {
            SymbolToken symbolToken = this.find(string);
            if (symbolToken == null) {
                if (IonManagedBinaryWriter.this.localsLocked) {
                    throw new IonException("Cannot intern into locked (read-only) local symbol table");
                }
                symbolToken = IonManagedBinaryWriter.this.intern(string);
            }
            return symbolToken;
        }

        @Override
        public String findKnownSymbol(int n) {
            for (SymbolTable object : ((IonManagedBinaryWriter)IonManagedBinaryWriter.this).imports.parents) {
                String string = object.findKnownSymbol(n);
                if (string == null) continue;
                return string;
            }
            for (SymbolToken symbolToken : IonManagedBinaryWriter.this.locals.values()) {
                if (symbolToken.getSid() != n) continue;
                return symbolToken.getText();
            }
            return null;
        }

        @Override
        public SymbolToken find(String string) {
            SymbolToken symbolToken = ((IonManagedBinaryWriter)IonManagedBinaryWriter.this).imports.importedSymbols.get(string);
            if (symbolToken != null) {
                return symbolToken;
            }
            return (SymbolToken)IonManagedBinaryWriter.this.locals.get(string);
        }

        @Override
        public void makeReadOnly() {
            IonManagedBinaryWriter.this.localsLocked = true;
        }
    }

    private static enum UserState {
        NORMAL{

            @Override
            public void beforeStepIn(IonManagedBinaryWriter ionManagedBinaryWriter, IonType ionType) {
                if (ionManagedBinaryWriter.user.hasTopLevelSymbolTableAnnotation() && ionType == IonType.STRUCT) {
                    ionManagedBinaryWriter.userState = 1.LOCALS_AT_TOP;
                    ionManagedBinaryWriter.userSymbolTablePosition = ionManagedBinaryWriter.user.position();
                }
            }

            @Override
            public void afterStepOut(IonManagedBinaryWriter ionManagedBinaryWriter) {
            }

            @Override
            public void writeInt(IonManagedBinaryWriter ionManagedBinaryWriter, BigInteger bigInteger) {
            }
        }
        ,
        LOCALS_AT_TOP{

            @Override
            public void beforeStepIn(IonManagedBinaryWriter ionManagedBinaryWriter, IonType ionType) {
                if (ionManagedBinaryWriter.user.getDepth() == 1) {
                    switch (ionManagedBinaryWriter.user.getFieldId()) {
                        case 6: {
                            if (ionType != IonType.LIST) {
                                throw new IllegalArgumentException("Cannot step into Local Symbol Table 'symbols' field as non-list: " + (Object)((Object)ionType));
                            }
                            ionManagedBinaryWriter.userState = 2.LOCALS_AT_IMPORTS;
                            break;
                        }
                        case 7: {
                            if (ionType != IonType.LIST) {
                                throw new IllegalArgumentException("Cannot step into Local Symbol Table 'symbols' field as non-list: " + (Object)((Object)ionType));
                            }
                            ionManagedBinaryWriter.userState = 2.LOCALS_AT_SYMBOLS;
                        }
                    }
                }
            }

            @Override
            public void afterStepOut(IonManagedBinaryWriter ionManagedBinaryWriter) throws IOException {
                if (ionManagedBinaryWriter.user.getDepth() == 0) {
                    ionManagedBinaryWriter.user.truncate(ionManagedBinaryWriter.userSymbolTablePosition);
                    ionManagedBinaryWriter.finish();
                    ionManagedBinaryWriter.imports = new ImportedSymbolContext(ImportedSymbolResolverMode.DELEGATE, ionManagedBinaryWriter.userImports);
                    ionManagedBinaryWriter.startLocalSymbolTableIfNeeded(false);
                    for (String string : ionManagedBinaryWriter.userSymbols) {
                        ionManagedBinaryWriter.intern(string);
                    }
                    ionManagedBinaryWriter.userSymbolTablePosition = 0L;
                    ionManagedBinaryWriter.userCurrentImport.reset();
                    ionManagedBinaryWriter.userImports.clear();
                    ionManagedBinaryWriter.userSymbols.clear();
                    ionManagedBinaryWriter.userState = 2.NORMAL;
                }
            }
        }
        ,
        LOCALS_AT_IMPORTS{

            @Override
            public void beforeStepIn(IonManagedBinaryWriter ionManagedBinaryWriter, IonType ionType) {
                if (ionType != IonType.STRUCT) {
                    throw new IllegalArgumentException("Cannot step into non-struct in Local Symbol Table import list: " + (Object)((Object)ionType));
                }
            }

            @Override
            public void afterStepOut(IonManagedBinaryWriter ionManagedBinaryWriter) {
                switch (ionManagedBinaryWriter.user.getDepth()) {
                    case 2: {
                        boolean bl;
                        ImportDescriptor importDescriptor = ionManagedBinaryWriter.userCurrentImport;
                        if (importDescriptor.isMalformed()) {
                            throw new IllegalArgumentException("Invalid import: " + importDescriptor);
                        }
                        if (!importDescriptor.isDefined()) break;
                        SymbolTable symbolTable = ionManagedBinaryWriter.catalog.getTable(importDescriptor.name, importDescriptor.version);
                        if (symbolTable == null) {
                            if (importDescriptor.maxId == -1) {
                                throw new IllegalArgumentException("Import is not in catalog and no max ID provided: " + importDescriptor);
                            }
                            symbolTable = Symbols.unknownSharedSymbolTable(importDescriptor.name, importDescriptor.version, importDescriptor.maxId);
                        }
                        boolean bl2 = importDescriptor.maxId != -1;
                        boolean bl3 = importDescriptor.maxId == symbolTable.getMaxId();
                        boolean bl4 = bl = importDescriptor.version == symbolTable.getVersion();
                        if (!(!bl2 || bl3 && bl)) {
                            symbolTable = PrivateUtils.newSubstituteSymtab(symbolTable, importDescriptor.version, importDescriptor.maxId);
                        }
                        ionManagedBinaryWriter.userImports.add(symbolTable);
                        break;
                    }
                    case 1: {
                        ionManagedBinaryWriter.userState = 3.LOCALS_AT_TOP;
                    }
                }
            }

            @Override
            public void writeString(IonManagedBinaryWriter ionManagedBinaryWriter, String string) {
                if (ionManagedBinaryWriter.user.getDepth() == 3 && ionManagedBinaryWriter.user.getFieldId() == 4) {
                    if (string == null) {
                        throw new NullPointerException("Cannot have null import name");
                    }
                    ((IonManagedBinaryWriter)ionManagedBinaryWriter).userCurrentImport.name = string;
                }
            }

            @Override
            public void writeInt(IonManagedBinaryWriter ionManagedBinaryWriter, long l) {
                if (ionManagedBinaryWriter.user.getDepth() == 3) {
                    if (l > Integer.MAX_VALUE || l < 1L) {
                        throw new IllegalArgumentException("Invalid integer value in import: " + l);
                    }
                    switch (ionManagedBinaryWriter.user.getFieldId()) {
                        case 5: {
                            ((IonManagedBinaryWriter)ionManagedBinaryWriter).userCurrentImport.version = (int)l;
                            break;
                        }
                        case 8: {
                            ((IonManagedBinaryWriter)ionManagedBinaryWriter).userCurrentImport.maxId = (int)l;
                        }
                    }
                }
            }
        }
        ,
        LOCALS_AT_SYMBOLS{

            @Override
            public void beforeStepIn(IonManagedBinaryWriter ionManagedBinaryWriter, IonType ionType) {
            }

            @Override
            public void afterStepOut(IonManagedBinaryWriter ionManagedBinaryWriter) {
                if (ionManagedBinaryWriter.user.getDepth() == 1) {
                    ionManagedBinaryWriter.userState = 4.LOCALS_AT_TOP;
                }
            }

            @Override
            public void writeString(IonManagedBinaryWriter ionManagedBinaryWriter, String string) {
                if (ionManagedBinaryWriter.user.getDepth() == 2) {
                    ionManagedBinaryWriter.userSymbols.add(string);
                }
            }
        };


        public abstract void beforeStepIn(IonManagedBinaryWriter var1, IonType var2) throws IOException;

        public abstract void afterStepOut(IonManagedBinaryWriter var1) throws IOException;

        public void writeString(IonManagedBinaryWriter ionManagedBinaryWriter, String string) throws IOException {
        }

        public void writeInt(IonManagedBinaryWriter ionManagedBinaryWriter, long l) throws IOException {
        }

        public void writeInt(IonManagedBinaryWriter ionManagedBinaryWriter, BigInteger bigInteger) throws IOException {
            this.writeInt(ionManagedBinaryWriter, bigInteger.longValue());
        }
    }

    private static class ImportDescriptor {
        public String name;
        public int version;
        public int maxId;

        public ImportDescriptor() {
            this.reset();
        }

        public void reset() {
            this.name = null;
            this.version = -1;
            this.maxId = -1;
        }

        public boolean isDefined() {
            return this.name != null && this.version >= 1;
        }

        public boolean isUndefined() {
            return this.name == null && this.version == -1 && this.maxId == -1;
        }

        public boolean isMalformed() {
            return !this.isDefined() && !this.isUndefined();
        }

        public String toString() {
            return "{name: \"" + this.name + "\", version: " + this.version + ", max_id: " + this.maxId + "}";
        }
    }

    private static enum SymbolState {
        SYSTEM_SYMBOLS{

            @Override
            public void closeTable(IonRawBinaryWriter ionRawBinaryWriter) throws IOException {
                ionRawBinaryWriter.writeIonVersionMarker();
            }
        }
        ,
        LOCAL_SYMBOLS_WITH_IMPORTS_ONLY{

            @Override
            public void closeTable(IonRawBinaryWriter ionRawBinaryWriter) throws IOException {
                ionRawBinaryWriter.stepOut();
            }
        }
        ,
        LOCAL_SYMBOLS{

            @Override
            public void closeTable(IonRawBinaryWriter ionRawBinaryWriter) throws IOException {
                ionRawBinaryWriter.stepOut();
                ionRawBinaryWriter.stepOut();
            }
        }
        ,
        LOCAL_SYMBOLS_FLUSHED{

            @Override
            public void closeTable(IonRawBinaryWriter ionRawBinaryWriter) throws IOException {
            }
        };


        public abstract void closeTable(IonRawBinaryWriter var1) throws IOException;
    }

    static final class ImportedSymbolContext {
        public final List<SymbolTable> parents;
        public final SymbolResolver importedSymbols;
        public final int localSidStart;

        ImportedSymbolContext(ImportedSymbolResolverMode importedSymbolResolverMode, List<SymbolTable> list) {
            ArrayList<SymbolTable> arrayList = new ArrayList<SymbolTable>(list.size());
            SymbolResolverBuilder symbolResolverBuilder = importedSymbolResolverMode.createBuilder();
            int n = 10;
            for (SymbolTable symbolTable : list) {
                if (!symbolTable.isSharedTable()) {
                    throw new IonException("Imported symbol table is not shared: " + symbolTable);
                }
                if (symbolTable.isSystemTable()) continue;
                arrayList.add(symbolTable);
                n = symbolResolverBuilder.addSymbolTable(symbolTable, n);
            }
            this.parents = Collections.unmodifiableList(arrayList);
            this.importedSymbols = symbolResolverBuilder.build();
            this.localSidStart = n;
        }
    }

    static enum ImportedSymbolResolverMode {
        FLAT{

            @Override
            SymbolResolverBuilder createBuilder() {
                final HashMap<String, SymbolToken> hashMap = new HashMap<String, SymbolToken>();
                for (SymbolToken symbolToken : Symbols.systemSymbols()) {
                    hashMap.put(symbolToken.getText(), symbolToken);
                }
                return new SymbolResolverBuilder(){

                    @Override
                    public int addSymbolTable(SymbolTable symbolTable, int n) {
                        int n2 = n;
                        Iterator<String> iterator2 = symbolTable.iterateDeclaredSymbolNames();
                        while (iterator2.hasNext()) {
                            String string = iterator2.next();
                            if (string != null && !hashMap.containsKey(string)) {
                                hashMap.put(string, Symbols.symbol(string, n2));
                            }
                            ++n2;
                        }
                        return n2;
                    }

                    @Override
                    public SymbolResolver build() {
                        return new SymbolResolver(){

                            @Override
                            public SymbolToken get(String string) {
                                return (SymbolToken)hashMap.get(string);
                            }
                        };
                    }
                };
            }
        }
        ,
        DELEGATE{

            @Override
            SymbolResolverBuilder createBuilder() {
                final ArrayList<ImportTablePosition> arrayList = new ArrayList<ImportTablePosition>();
                arrayList.add(new ImportTablePosition(Symbols.systemSymbolTable(), 1));
                return new SymbolResolverBuilder(){

                    @Override
                    public int addSymbolTable(SymbolTable symbolTable, int n) {
                        arrayList.add(new ImportTablePosition(symbolTable, n));
                        return n + symbolTable.getMaxId();
                    }

                    @Override
                    public SymbolResolver build() {
                        return new SymbolResolver(){

                            @Override
                            public SymbolToken get(String string) {
                                for (ImportTablePosition importTablePosition : arrayList) {
                                    SymbolToken symbolToken = importTablePosition.table.find(string);
                                    if (symbolToken == null) continue;
                                    return Symbols.symbol(string, symbolToken.getSid() + importTablePosition.startId - 1);
                                }
                                return null;
                            }
                        };
                    }
                };
            }
        };


        abstract SymbolResolverBuilder createBuilder();
    }

    private static final class ImportTablePosition {
        public final SymbolTable table;
        public final int startId;

        public ImportTablePosition(SymbolTable symbolTable, int n) {
            this.table = symbolTable;
            this.startId = n;
        }
    }

    private static interface SymbolResolverBuilder {
        public int addSymbolTable(SymbolTable var1, int var2);

        public SymbolResolver build();
    }

    private static interface SymbolResolver {
        public SymbolToken get(String var1);
    }
}

