/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.io.IOException;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.impl.bin.Symbols;

abstract class AbstractSymbolTable
implements SymbolTable {
    private final String name;
    private final int version;

    public AbstractSymbolTable(String string, int n) {
        this.name = string;
        this.version = n;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getVersion() {
        return this.version;
    }

    @Override
    public final String getIonVersionId() {
        return "$ion_1_0";
    }

    @Override
    public final int findSymbol(String string) {
        SymbolToken symbolToken = this.find(string);
        if (symbolToken == null) {
            return -1;
        }
        return symbolToken.getSid();
    }

    @Override
    public final void writeTo(IonWriter ionWriter) throws IOException {
        SymbolTable[] symbolTableArray;
        if (this.isSharedTable()) {
            ionWriter.setTypeAnnotationSymbols(Symbols.systemSymbol(9));
        } else if (this.isLocalTable()) {
            ionWriter.setTypeAnnotationSymbols(Symbols.systemSymbol(3));
        } else {
            throw new IllegalStateException("Invalid symbol table, neither shared nor local");
        }
        ionWriter.stepIn(IonType.STRUCT);
        if (this.isSharedTable()) {
            ionWriter.setFieldNameSymbol(Symbols.systemSymbol(4));
            ionWriter.writeString(this.name);
            ionWriter.setFieldNameSymbol(Symbols.systemSymbol(5));
            ionWriter.writeInt(this.version);
        }
        if ((symbolTableArray = this.getImportedTables()) != null && symbolTableArray.length > 0) {
            ionWriter.setFieldNameSymbol(Symbols.systemSymbol(6));
            ionWriter.stepIn(IonType.LIST);
            for (SymbolTable symbolTable : symbolTableArray) {
                ionWriter.stepIn(IonType.STRUCT);
                ionWriter.setFieldNameSymbol(Symbols.systemSymbol(4));
                ionWriter.writeString(symbolTable.getName());
                ionWriter.setFieldNameSymbol(Symbols.systemSymbol(5));
                ionWriter.writeInt(symbolTable.getVersion());
                ionWriter.setFieldNameSymbol(Symbols.systemSymbol(8));
                ionWriter.writeInt(symbolTable.getMaxId());
                ionWriter.stepOut();
            }
            ionWriter.stepOut();
        }
        ionWriter.setFieldNameSymbol(Symbols.systemSymbol(7));
        ionWriter.stepIn(IonType.LIST);
        SymbolTable[] symbolTableArray2 = this.iterateDeclaredSymbolNames();
        while (symbolTableArray2.hasNext()) {
            ionWriter.writeString((String)symbolTableArray2.next());
        }
        ionWriter.stepOut();
        ionWriter.stepOut();
    }

    @Override
    public void makeReadOnly() {
    }
}

