/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import software.amazon.ion.impl.IonReaderTextRawTokensX;
import software.amazon.ion.impl.IonUTF8;
import software.amazon.ion.impl.UnifiedDataPageX;
import software.amazon.ion.impl.UnifiedInputBufferX;
import software.amazon.ion.impl.UnifiedSavePointManagerX;

abstract class UnifiedInputStreamX
implements Closeable {
    public static final int EOF = -1;
    private static final boolean _debug = false;
    static final int UNREAD_LIMIT = 10;
    static int DEFAULT_PAGE_SIZE = 32768;
    boolean _eof;
    boolean _is_byte_data;
    boolean _is_stream;
    UnifiedInputBufferX _buffer;
    int _max_char_value;
    int _pos;
    int _limit;
    Reader _reader;
    InputStream _stream;
    byte[] _bytes;
    char[] _chars;
    UnifiedSavePointManagerX _save_points;

    UnifiedInputStreamX() {
    }

    public static UnifiedInputStreamX makeStream(CharSequence charSequence) {
        return new FromCharArray(charSequence, 0, charSequence.length());
    }

    public static UnifiedInputStreamX makeStream(CharSequence charSequence, int n, int n2) {
        return new FromCharArray(charSequence, n, n2);
    }

    public static UnifiedInputStreamX makeStream(char[] cArray) {
        return new FromCharArray(cArray, 0, cArray.length);
    }

    public static UnifiedInputStreamX makeStream(char[] cArray, int n, int n2) {
        return new FromCharArray(cArray, n, n2);
    }

    public static UnifiedInputStreamX makeStream(Reader reader) throws IOException {
        return new FromCharStream(reader);
    }

    public static UnifiedInputStreamX makeStream(byte[] byArray) {
        return new FromByteArray(byArray, 0, byArray.length);
    }

    public static UnifiedInputStreamX makeStream(byte[] byArray, int n, int n2) {
        return new FromByteArray(byArray, n, n2);
    }

    public static UnifiedInputStreamX makeStream(InputStream inputStream2) throws IOException {
        return new FromByteStream(inputStream2);
    }

    public final InputStream getInputStream() {
        return this._stream;
    }

    public final Reader getReader() {
        return this._reader;
    }

    public final byte[] getByteArray() {
        return this._bytes;
    }

    public final char[] getCharArray() {
        return this._chars;
    }

    private final void init() {
        this._eof = false;
        this._max_char_value = this._buffer.maxValue();
        this._save_points = new UnifiedSavePointManagerX(this);
    }

    @Override
    public void close() throws IOException {
        this._eof = true;
        this._buffer.clear();
    }

    public final boolean isEOF() {
        return this._eof;
    }

    public long getPosition() {
        long l = 0L;
        UnifiedDataPageX unifiedDataPageX = this._buffer.getCurrentPage();
        if (unifiedDataPageX != null) {
            l = unifiedDataPageX.getFilePosition(this._pos);
        }
        return l;
    }

    public final UnifiedSavePointManagerX.SavePoint savePointAllocate() {
        UnifiedSavePointManagerX.SavePoint savePoint = this._save_points.savePointAllocate();
        return savePoint;
    }

    protected final void save_point_reset_to_prev(UnifiedSavePointManagerX.SavePoint savePoint) {
        int n = savePoint.getPrevIdx();
        UnifiedDataPageX unifiedDataPageX = this._buffer.getPage(n);
        int n2 = savePoint.getPrevPos();
        int n3 = savePoint.getPrevLimit();
        this.make_page_current(unifiedDataPageX, n, n2, n3);
    }

    protected final void make_page_current(UnifiedDataPageX unifiedDataPageX, int n, int n2, int n3) {
        this._limit = n3;
        this._pos = n2;
        this._eof = false;
        if (this.is_byte_data()) {
            this._bytes = unifiedDataPageX.getByteBuffer();
        } else {
            this._chars = unifiedDataPageX.getCharBuffer();
        }
        this._buffer.setCurrentPage(n, unifiedDataPageX);
        if (n2 > n3) {
            this.refill_is_eof();
            return;
        }
    }

    private final boolean is_byte_data() {
        return this._is_byte_data;
    }

    public final void unread(int n) {
        if (n == -1) {
            return;
        }
        if (n < 0 || n > this._max_char_value) {
            throw new IllegalArgumentException();
        }
        if (this._eof) {
            this._eof = false;
            if (this._limit == -1) {
                this._limit = this._pos;
            }
        }
        --this._pos;
        if (this._pos >= 0) {
            UnifiedDataPageX unifiedDataPageX = this._buffer.getCurrentPage();
            if (this._pos < unifiedDataPageX.getStartingOffset()) {
                unifiedDataPageX.inc_unread_count();
                if (this.is_byte_data()) {
                    this._bytes[this._pos] = (byte)n;
                } else {
                    this._chars[this._pos] = (char)n;
                }
            } else {
                this.verify_matched_unread(n);
            }
        } else {
            this._buffer.putCharAt(this.getPosition(), n);
        }
    }

    private final void verify_matched_unread(int n) {
    }

    public final boolean unread_optional_cr() {
        int n;
        boolean bl = false;
        UnifiedDataPageX unifiedDataPageX = this._buffer.getCurrentPage();
        if (this._pos > unifiedDataPageX.getStartingOffset() && (n = this.is_byte_data() ? this._bytes[this._pos - 1] & 0xFF : this._chars[this._pos - 1]) == 13) {
            --this._pos;
        }
        return bl;
    }

    public final int read() throws IOException {
        if (this._pos >= this._limit) {
            return this.read_helper();
        }
        assert (this._bytes == null ^ this._chars == null);
        return this._is_byte_data ? this._bytes[this._pos++] & 0xFF : this._chars[this._pos++];
    }

    protected final int read_helper() throws IOException {
        if (this._eof) {
            return -1;
        }
        if (this.refill_helper()) {
            return -1;
        }
        int n = this.is_byte_data() ? this._bytes[this._pos++] & 0xFF : this._chars[this._pos++];
        return n;
    }

    private final boolean refill_helper() throws IOException {
        this._limit = this.refill();
        if (this._pos >= this._limit) {
            this._eof = true;
            return true;
        }
        return false;
    }

    public final void skip(int n) throws IOException {
        int n2 = this._limit - this._pos;
        if (n2 >= n) {
            this._pos += n;
            n2 = 0;
        } else {
            n2 = n;
            while (n2 > 0) {
                int n3 = this._limit - this._pos;
                if (n3 > n2) {
                    n3 = n2;
                }
                this._pos += n3;
                if ((n2 -= n3) <= 0 || !this.refill_helper()) continue;
                break;
            }
        }
        if (n2 > 0) {
            String string = "unexpected EOF encountered during skip of " + n + " at position " + this.getPosition();
            throw new IOException(string);
        }
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (!this.is_byte_data()) {
            throw new IOException("byte read is not support over character sources");
        }
        for (n3 = n2; n3 > 0 && !this.isEOF(); n3 -= n4) {
            n4 = this._limit - this._pos;
            if (n4 > n3) {
                n4 = n3;
            }
            System.arraycopy(this._bytes, this._pos, byArray, n, n4);
            this._pos += n4;
            n += n4;
            if (this._pos >= this._limit && !this.refill_helper()) continue;
            break;
        }
        return n2 - n3;
    }

    public final int read(char[] cArray, int n, int n2) throws IOException {
        if (this.is_byte_data()) {
            throw new IOException("character read is not support over byte data sources");
        }
        int n3 = n2;
        while (n3 > 0 && !this.isEOF()) {
            int n4 = this._limit - this._pos;
            if (n4 > n3) {
                n4 = n3;
            }
            System.arraycopy(this._chars, this._pos, cArray, n, n4);
            this._pos += n4;
            n += n4;
            if (!this.refill_helper()) continue;
            break;
        }
        return n2 - n3;
    }

    public int readScalar() throws IOException {
        int n = this.read();
        if (n != -1 && this._is_byte_data && IonUTF8.isStartByte(n)) {
            n = this.read_utf8(n);
        }
        return n;
    }

    private int read_utf8(int n) throws IOException {
        int n2 = IonUTF8.getUTF8LengthFromFirstByte(n);
        for (int i = 1; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                throw new IonReaderTextRawTokensX.IonReaderTextTokenException("invalid UTF8 sequence encountered in stream");
            }
            n |= n3 << i * 8;
        }
        n = IonUTF8.getScalarFrom4BytesReversed(n);
        return n;
    }

    protected int refill() throws IOException {
        long l;
        UnifiedDataPageX unifiedDataPageX = this._buffer.getCurrentPage();
        UnifiedSavePointManagerX.SavePoint savePoint = this._save_points.savePointActiveTop();
        if (!this.can_fill_new_page()) {
            return this.refill_is_eof();
        }
        if (savePoint != null && savePoint.getEndIdx() == this._buffer.getCurrentPageIdx()) {
            return this.refill_is_eof();
        }
        int n = 10;
        if (unifiedDataPageX == null) {
            l = 0L;
            n = 0;
        } else {
            l = unifiedDataPageX.getFilePosition(this._pos);
            if (l == 0L) {
                n = 0;
            }
        }
        int n2 = this._buffer.getNextFilledPageIdx();
        if (n2 < 0) {
            int n3;
            unifiedDataPageX = this._buffer.getCurrentPage();
            boolean bl = unifiedDataPageX == null;
            n2 = this._buffer.getCurrentPageIdx();
            if (this._save_points.isSavePointOpen()) {
                ++n2;
                bl = true;
            }
            if (bl) {
                unifiedDataPageX = this._buffer.getEmptyPageIdx();
            }
            if ((n3 = this.load(unifiedDataPageX, n, l)) < 1) {
                return this.refill_is_eof();
            }
            assert (unifiedDataPageX != null && unifiedDataPageX.getOffsetOfFilePosition(l) == n);
            this.set_current_page(n2, unifiedDataPageX, n);
        } else {
            int n4;
            assert (!this.isEOF());
            if (savePoint != null && (n4 = savePoint.getEndIdx()) != -1 && n4 < n2) {
                return this.refill_is_eof();
            }
            unifiedDataPageX = this._buffer.getPage(n2);
            assert (unifiedDataPageX.getStartingFileOffset() == l);
            this.set_current_page(n2, unifiedDataPageX, unifiedDataPageX.getStartingOffset());
            if (savePoint != null && savePoint.getEndIdx() == n2) {
                this._limit = savePoint.getEndPos();
            }
        }
        assert (this.isEOF() ^ this._limit > 0);
        return this._limit;
    }

    private void set_current_page(int n, UnifiedDataPageX unifiedDataPageX, int n2) {
        assert (unifiedDataPageX != null && n >= 0 && n <= this._buffer.getPageCount() + 1);
        UnifiedDataPageX unifiedDataPageX2 = null;
        if (n < this._buffer.getPageCount()) {
            unifiedDataPageX2 = this._buffer.getPage(n);
        }
        if (unifiedDataPageX != unifiedDataPageX2) {
            this._buffer.setPage(n, unifiedDataPageX, true);
        }
        this.make_page_current(unifiedDataPageX, n, n2, unifiedDataPageX.getBufferLimit());
    }

    private int refill_is_eof() {
        this._eof = true;
        this._limit = -1;
        return this._limit;
    }

    private final boolean can_fill_new_page() {
        return this._is_stream;
    }

    protected final int load(UnifiedDataPageX unifiedDataPageX, int n, long l) throws IOException {
        int n2 = 0;
        if (this.can_fill_new_page()) {
            n2 = this.is_byte_data() ? unifiedDataPageX.load(this._stream, n, l) : unifiedDataPageX.load(this._reader, n, l);
        }
        return n2;
    }

    private static class FromByteStream
    extends UnifiedInputStreamX {
        FromByteStream(InputStream inputStream2) throws IOException {
            this._is_byte_data = true;
            this._is_stream = true;
            this._stream = inputStream2;
            this._buffer = UnifiedInputBufferX.makePageBuffer(UnifiedInputBufferX.BufferType.BYTES, DEFAULT_PAGE_SIZE);
            ((UnifiedInputStreamX)this).init();
            this._limit = this.refill();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this._stream.close();
        }
    }

    static class FromByteArray
    extends UnifiedInputStreamX {
        FromByteArray(byte[] byArray, int n, int n2) {
            this._is_byte_data = true;
            this._is_stream = false;
            this._buffer = UnifiedInputBufferX.makePageBuffer(byArray, n, n2);
            UnifiedDataPageX unifiedDataPageX = this._buffer.getCurrentPage();
            this.make_page_current(unifiedDataPageX, 0, n, n + n2);
            ((UnifiedInputStreamX)this).init();
        }
    }

    private static class FromCharStream
    extends UnifiedInputStreamX {
        FromCharStream(Reader reader) throws IOException {
            this._is_byte_data = false;
            this._is_stream = true;
            this._reader = reader;
            this._buffer = UnifiedInputBufferX.makePageBuffer(UnifiedInputBufferX.BufferType.CHARS, DEFAULT_PAGE_SIZE);
            ((UnifiedInputStreamX)this).init();
            this._limit = this.refill();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this._reader.close();
        }
    }

    private static class FromCharArray
    extends UnifiedInputStreamX {
        FromCharArray(CharSequence charSequence, int n, int n2) {
            this._is_byte_data = false;
            this._is_stream = false;
            this._buffer = UnifiedInputBufferX.makePageBuffer(charSequence, n, n2);
            UnifiedDataPageX unifiedDataPageX = this._buffer.getCurrentPage();
            this.make_page_current(unifiedDataPageX, 0, n, n + n2);
            ((UnifiedInputStreamX)this).init();
        }

        FromCharArray(char[] cArray, int n, int n2) {
            this._is_byte_data = false;
            this._is_stream = false;
            this._buffer = UnifiedInputBufferX.makePageBuffer(cArray, n, n2);
            UnifiedDataPageX unifiedDataPageX = this._buffer.getCurrentPage();
            this.make_page_current(unifiedDataPageX, 0, n, n + n2);
            ((UnifiedInputStreamX)this).init();
        }
    }
}

