/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import software.amazon.ion.impl.UnifiedDataPageX;

abstract class UnifiedInputBufferX {
    protected int _page_size;
    protected UnifiedDataPageX[] _buffers;
    protected int _buffer_current;
    protected int _buffer_count;
    protected int _locks;

    public static UnifiedInputBufferX makePageBuffer(byte[] byArray, int n, int n2) {
        Bytes bytes = new Bytes(byArray, n, n2);
        return bytes;
    }

    public static UnifiedInputBufferX makePageBuffer(char[] cArray, int n, int n2) {
        Chars chars = new Chars(cArray, n, n2);
        return chars;
    }

    public static UnifiedInputBufferX makePageBuffer(CharSequence charSequence, int n, int n2) {
        char[] cArray = UnifiedInputBufferX.chars_make_char_array(charSequence, n, n2);
        UnifiedInputBufferX unifiedInputBufferX = UnifiedInputBufferX.makePageBuffer(cArray, 0, n2);
        return unifiedInputBufferX;
    }

    public static UnifiedInputBufferX makePageBuffer(BufferType bufferType, int n) {
        UnifiedInputBufferX unifiedInputBufferX;
        switch (bufferType) {
            case CHARS: {
                unifiedInputBufferX = new Chars(n);
                break;
            }
            case BYTES: {
                unifiedInputBufferX = new Bytes(n);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid buffer type");
            }
        }
        return unifiedInputBufferX;
    }

    protected static final char[] chars_make_char_array(CharSequence charSequence, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = n; i < n2; ++i) {
            cArray[i] = charSequence.charAt(i);
        }
        return cArray;
    }

    private UnifiedInputBufferX(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("page size must be > 0");
        }
        this._page_size = n;
        this._buffers = new UnifiedDataPageX[10];
    }

    public abstract BufferType getType();

    public abstract int maxValue();

    public final void putCharAt(long l, int n) {
        int n2;
        if (n < 0 || n > this.maxValue()) {
            throw new IllegalArgumentException("value (" + n + ")is out of range (0 to " + this.maxValue() + ")");
        }
        UnifiedDataPageX unifiedDataPageX = null;
        for (n2 = this._buffer_current; n2 >= 0; --n2) {
            if (!this._buffers[n2].containsOffset(l)) continue;
            unifiedDataPageX = this._buffers[n2];
            break;
        }
        if (unifiedDataPageX == null) {
            throw new IllegalArgumentException();
        }
        n2 = (int)(l - unifiedDataPageX.getStartingFileOffset());
        unifiedDataPageX.putValue(n2, n);
    }

    public final UnifiedDataPageX getCurrentPage() {
        return this._buffers[this._buffer_current];
    }

    public final int getCurrentPageIdx() {
        return this._buffer_current;
    }

    public final int getPageCount() {
        return this._buffer_count;
    }

    public final void incLock() {
        ++this._locks;
    }

    public final boolean decLock() {
        --this._locks;
        return this._locks == 0;
    }

    public final UnifiedDataPageX getPage(int n) {
        if (n < 0 || n >= this._buffer_count) {
            throw new IndexOutOfBoundsException();
        }
        return this._buffers[n];
    }

    protected final int getNextFilledPageIdx() {
        UnifiedDataPageX unifiedDataPageX;
        int n = this._buffer_current + 1;
        if (n < this._buffer_count && (unifiedDataPageX = this._buffers[n]) != null) {
            this._buffer_current = n;
            return n;
        }
        return -1;
    }

    protected final UnifiedDataPageX getEmptyPageIdx() {
        UnifiedDataPageX unifiedDataPageX = null;
        if (this._buffer_count < this._buffers.length) {
            unifiedDataPageX = this._buffers[this._buffer_count];
        }
        if (unifiedDataPageX == null) {
            unifiedDataPageX = this.make_page(this._page_size);
        } else assert (this._buffer_count == this._buffer_current + 1);
        return unifiedDataPageX;
    }

    protected abstract UnifiedDataPageX make_page(int var1);

    protected final UnifiedDataPageX setCurrentPage(int n, UnifiedDataPageX unifiedDataPageX) {
        this.setPage(n, unifiedDataPageX, true);
        if (n != this._buffer_current) {
            this._buffer_current = n;
            if (n >= this._buffer_count) {
                this._buffer_count = n + 1;
            }
        }
        UnifiedDataPageX unifiedDataPageX2 = this._buffers[n];
        return unifiedDataPageX2;
    }

    protected final void setPage(int n, UnifiedDataPageX unifiedDataPageX, boolean bl) {
        int n2 = this._buffers.length;
        if (n >= n2) {
            int n3 = n2 * 2;
            UnifiedDataPageX[] unifiedDataPageXArray = new UnifiedDataPageX[n3];
            System.arraycopy(this._buffers, 0, unifiedDataPageXArray, 0, n2);
            this._buffers = unifiedDataPageXArray;
        }
        UnifiedDataPageX unifiedDataPageX2 = this._buffers[n];
        this._buffers[n] = unifiedDataPageX;
        if (n >= this._buffer_count) {
            this._buffer_count = n + 1;
        }
        if (bl && unifiedDataPageX2 != null && unifiedDataPageX2 != unifiedDataPageX && n + 1 < this._buffers.length) {
            this._buffers[n + 1] = unifiedDataPageX2;
        }
    }

    protected final void resetToCurrentPage() {
        int n = this.getCurrentPageIdx();
        if (n > 0) {
            this.release_pages_to(n);
        }
    }

    private final void release_pages_to(int n) {
        assert (n > 0);
        UnifiedDataPageX unifiedDataPageX = this._buffers[0];
        int n2 = 0;
        int n3 = n;
        while (n3 < this._buffer_count) {
            this._buffers[n2++] = this._buffers[n3++];
        }
        int n4 = this._buffer_count + 1;
        if (n4 >= this._buffers.length) {
            n4 = this._buffers.length;
        }
        while (n2 < n4) {
            this._buffers[n2++] = null;
        }
        this._buffer_current -= n;
        this._buffer_count -= n;
        this._buffers[this._buffer_count] = unifiedDataPageX;
    }

    protected final void clear() {
        UnifiedDataPageX unifiedDataPageX = this.getCurrentPage();
        for (int i = 0; i < this._buffers.length; ++i) {
            this._buffers[i] = null;
        }
        if (unifiedDataPageX != null) {
            this._buffers[0] = unifiedDataPageX;
            unifiedDataPageX.reset(0);
        }
        this._buffer_count = 0;
        this._buffer_current = 0;
    }

    static class Chars
    extends UnifiedInputBufferX {
        protected Chars(int n) {
            super(n);
        }

        protected Chars(char[] cArray, int n, int n2) {
            super(n + n2);
            this._buffers[0] = new UnifiedDataPageX.Chars(cArray, n, n2);
            this._buffer_current = 0;
            this._buffer_count = 1;
        }

        protected Chars(CharSequence charSequence, int n, int n2) {
            this(Chars.chars_make_char_array(charSequence, n, n2), 0, n2);
        }

        @Override
        public final BufferType getType() {
            return BufferType.CHARS;
        }

        @Override
        protected final UnifiedDataPageX make_page(int n) {
            UnifiedDataPageX.Chars chars = new UnifiedDataPageX.Chars(n);
            return chars;
        }

        @Override
        public final int maxValue() {
            return 65535;
        }
    }

    static class Bytes
    extends UnifiedInputBufferX {
        protected Bytes(int n) {
            super(n);
        }

        protected Bytes(byte[] byArray, int n, int n2) {
            super(n2);
            this._buffers[0] = new UnifiedDataPageX.Bytes(byArray, n, n2);
            this._buffer_current = 0;
            this._buffer_count = 1;
        }

        @Override
        public final BufferType getType() {
            return BufferType.BYTES;
        }

        @Override
        protected final UnifiedDataPageX make_page(int n) {
            UnifiedDataPageX.Bytes bytes = new UnifiedDataPageX.Bytes(n);
            return bytes;
        }

        @Override
        public final int maxValue() {
            return 255;
        }
    }

    public static enum BufferType {
        BYTES,
        CHARS;

    }
}

