/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import software.amazon.ion.IonWriter;
import software.amazon.ion.ReadOnlyValueException;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.impl.SymbolTableReader;

final class SubstituteSymbolTable
implements SymbolTable {
    private final SymbolTable myOriginalSymTab;
    private final String myName;
    private final int myVersion;
    private final int myMaxId;

    SubstituteSymbolTable(String string, int n, int n2) {
        this.myOriginalSymTab = null;
        this.myName = string;
        this.myVersion = n;
        this.myMaxId = n2;
    }

    SubstituteSymbolTable(SymbolTable symbolTable, int n, int n2) {
        assert (symbolTable.isSharedTable() && !symbolTable.isSystemTable());
        assert (symbolTable.getVersion() != n || symbolTable.getMaxId() != n2);
        this.myOriginalSymTab = symbolTable;
        this.myName = symbolTable.getName();
        this.myVersion = n;
        this.myMaxId = n2;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public int getVersion() {
        return this.myVersion;
    }

    @Override
    public boolean isSubstitute() {
        return true;
    }

    @Override
    public boolean isLocalTable() {
        return false;
    }

    @Override
    public boolean isSharedTable() {
        return true;
    }

    @Override
    public boolean isSystemTable() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void makeReadOnly() {
    }

    @Override
    public SymbolTable getSystemSymbolTable() {
        return null;
    }

    @Override
    public String getIonVersionId() {
        return null;
    }

    @Override
    public SymbolTable[] getImportedTables() {
        return null;
    }

    @Override
    public int getImportedMaxId() {
        return 0;
    }

    @Override
    public int getMaxId() {
        return this.myMaxId;
    }

    @Override
    public SymbolToken intern(String string) {
        SymbolToken symbolToken = this.find(string);
        if (symbolToken == null) {
            throw new ReadOnlyValueException(SymbolTable.class);
        }
        return symbolToken;
    }

    @Override
    public SymbolToken find(String string) {
        SymbolToken symbolToken = null;
        if (this.myOriginalSymTab != null && (symbolToken = this.myOriginalSymTab.find(string)) != null && symbolToken.getSid() > this.myMaxId) {
            symbolToken = null;
        }
        return symbolToken;
    }

    @Override
    public int findSymbol(String string) {
        int n = -1;
        if (this.myOriginalSymTab != null && (n = this.myOriginalSymTab.findSymbol(string)) > this.myMaxId) {
            n = -1;
        }
        return n;
    }

    @Override
    public String findKnownSymbol(int n) {
        if (n > this.myMaxId || this.myOriginalSymTab == null) {
            return null;
        }
        return this.myOriginalSymTab.findKnownSymbol(n);
    }

    @Override
    public Iterator<String> iterateDeclaredSymbolNames() {
        Iterator<String> iterator2 = this.myOriginalSymTab != null ? this.myOriginalSymTab.iterateDeclaredSymbolNames() : Collections.EMPTY_LIST.iterator();
        return new SymbolIterator(iterator2);
    }

    @Override
    public void writeTo(IonWriter ionWriter) throws IOException {
        SymbolTableReader symbolTableReader = new SymbolTableReader(this);
        ionWriter.writeValues(symbolTableReader);
    }

    private final class SymbolIterator
    implements Iterator<String> {
        private Iterator<String> myOriginalIterator;
        private int myIndex = 0;

        SymbolIterator(Iterator<String> iterator2) {
            this.myOriginalIterator = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex < SubstituteSymbolTable.this.myMaxId;
        }

        @Override
        public String next() {
            if (this.myIndex < SubstituteSymbolTable.this.myMaxId) {
                String string = null;
                if (this.myOriginalIterator.hasNext()) {
                    string = this.myOriginalIterator.next();
                }
                ++this.myIndex;
                return string;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

