/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import software.amazon.ion.EmptySymbolException;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonType;
import software.amazon.ion.IonValue;
import software.amazon.ion.SubstituteSymbolTableException;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.UnknownSymbolException;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.Base64Encoder;
import software.amazon.ion.impl.IonIteratorImpl;
import software.amazon.ion.impl.IonUTF8;
import software.amazon.ion.impl.LocalSymbolTable;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.impl.SharedSymbolTable;
import software.amazon.ion.impl.SubstituteSymbolTable;
import software.amazon.ion.impl.SymbolTokenImpl;
import software.amazon.ion.util.IonStreamUtils;

@Deprecated
public final class PrivateUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final String ASCII_CHARSET_NAME = "US-ASCII";
    public static final Charset ASCII_CHARSET = Charset.forName("US-ASCII");
    public static final String UTF8_CHARSET_NAME = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final ListIterator<?> EMPTY_ITERATOR = new ListIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }
    };

    public static final <T> ListIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static boolean safeEquals(Object object, Object object2) {
        return object != null ? object.equals(object2) : object2 == null;
    }

    public static byte[] copyOf(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n, byArray.length));
        return byArray2;
    }

    public static String[] copyOf(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(n, stringArray.length));
        return stringArray2;
    }

    public static <T> void addAll(Collection<T> collection, Iterator<T> iterator2) {
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T t2 = iterator2.next();
                collection.add(t2);
            }
        }
    }

    public static <T> void addAllNonNull(Collection<T> collection, Iterator<T> iterator2) {
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T t2 = iterator2.next();
                if (t2 == null) continue;
                collection.add(t2);
            }
        }
    }

    public static void ensureNonEmptySymbols(String[] stringArray) {
        for (String string : stringArray) {
            if (string != null && string.length() != 0) continue;
            throw new EmptySymbolException();
        }
    }

    public static void ensureNonEmptySymbols(SymbolToken[] symbolTokenArray) {
        for (SymbolToken symbolToken : symbolTokenArray) {
            if (symbolToken != null && (symbolToken.getText() == null || symbolToken.getText().length() != 0)) continue;
            throw new EmptySymbolException();
        }
    }

    public static SymbolTokenImpl newSymbolToken(String string, int n) {
        return new SymbolTokenImpl(string, n);
    }

    public static SymbolTokenImpl newSymbolToken(int n) {
        return new SymbolTokenImpl(n);
    }

    public static SymbolToken newSymbolToken(SymbolTable symbolTable, String string) {
        SymbolToken symbolToken;
        if (string == null || string.length() == 0) {
            throw new EmptySymbolException();
        }
        SymbolToken symbolToken2 = symbolToken = symbolTable == null ? null : symbolTable.find(string);
        if (symbolToken == null) {
            symbolToken = new SymbolTokenImpl(string, -1);
        }
        return symbolToken;
    }

    public static SymbolToken newSymbolToken(SymbolTable symbolTable, int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        String string = symbolTable == null ? null : symbolTable.findKnownSymbol(n);
        return new SymbolTokenImpl(string, n);
    }

    public static SymbolToken[] newSymbolTokens(SymbolTable symbolTable, String ... stringArray) {
        int n;
        if (stringArray != null && (n = stringArray.length) != 0) {
            SymbolToken[] symbolTokenArray = new SymbolToken[n];
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                symbolTokenArray[i] = PrivateUtils.newSymbolToken(symbolTable, string);
            }
            return symbolTokenArray;
        }
        return SymbolToken.EMPTY_ARRAY;
    }

    public static SymbolToken[] newSymbolTokens(SymbolTable symbolTable, int ... nArray) {
        if (nArray != null) {
            int n = nArray.length;
            if (nArray.length != 0) {
                SymbolToken[] symbolTokenArray = new SymbolToken[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray[i];
                    symbolTokenArray[i] = PrivateUtils.newSymbolToken(symbolTable, n2);
                }
                return symbolTokenArray;
            }
        }
        return SymbolToken.EMPTY_ARRAY;
    }

    public static SymbolToken localize(SymbolTable symbolTable, SymbolToken symbolToken) {
        String string = symbolToken.getText();
        int n = symbolToken.getSid();
        if (symbolTable != null) {
            if (string == null) {
                string = symbolTable.findKnownSymbol(n);
                if (string != null) {
                    symbolToken = new SymbolTokenImpl(string, n);
                }
            } else {
                SymbolToken symbolToken2 = symbolTable.find(string);
                if (symbolToken2 != null) {
                    symbolToken = symbolToken2;
                } else if (n >= 0) {
                    symbolToken = new SymbolTokenImpl(string, -1);
                }
            }
        } else if (string != null && n >= 0) {
            symbolToken = new SymbolTokenImpl(string, -1);
        }
        return symbolToken;
    }

    public static void localize(SymbolTable symbolTable, SymbolToken[] symbolTokenArray, int n) {
        for (int i = 0; i < n; ++i) {
            SymbolToken symbolToken = symbolTokenArray[i];
            SymbolToken symbolToken2 = PrivateUtils.localize(symbolTable, symbolToken);
            if (symbolToken2 == symbolToken) continue;
            symbolTokenArray[i] = symbolToken2;
        }
    }

    public static void localize(SymbolTable symbolTable, SymbolToken[] symbolTokenArray) {
        PrivateUtils.localize(symbolTable, symbolTokenArray, symbolTokenArray.length);
    }

    public static String[] toStrings(SymbolToken[] symbolTokenArray, int n) {
        if (n == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            SymbolToken symbolToken = symbolTokenArray[i];
            String string = symbolToken.getText();
            if (string == null) {
                throw new UnknownSymbolException(symbolToken.getSid());
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static int[] toSids(SymbolToken[] symbolTokenArray, int n) {
        if (n == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = symbolTokenArray[i].getSid();
        }
        return nArray;
    }

    public static byte[] encode(String string, Charset charset) {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        try {
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.limit();
            if (n < byArray.length) {
                byArray = PrivateUtils.copyOf(byArray, n);
            }
            return byArray;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IonException("Invalid string data", characterCodingException);
        }
    }

    public static String decode(byte[] byArray, Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        try {
            CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray));
            return charBuffer.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            String string = "Input is not valid " + charset.displayName() + " data";
            throw new IonException(string, characterCodingException);
        }
    }

    public static byte[] utf8(String string) {
        return PrivateUtils.encode(string, UTF8_CHARSET);
    }

    public static String utf8(byte[] byArray) {
        return PrivateUtils.decode(byArray, UTF8_CHARSET);
    }

    public static byte[] convertUtf16UnitsToUtf8(String string) {
        byte[] byArray = new byte[4 * string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            n += IonUTF8.convertToUTF8Bytes(c, byArray, n, byArray.length - n);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static int readFully(InputStream inputStream2, byte[] byArray) throws IOException {
        return PrivateUtils.readFully(inputStream2, byArray, 0, byArray.length);
    }

    public static int readFully(InputStream inputStream2, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream2.read(byArray, n, n2 - n3);
            if (n4 < 0) {
                return n3;
            }
            n3 += n4;
            n += n4;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileBytes(File file) throws IOException {
        long l = file.length();
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + file);
        }
        byte[] byArray = new byte[(int)l];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n = fileInputStream.read(byArray);
            if ((long)n != l || fileInputStream.read() != -1) {
                throw new IOException("Read the wrong number of bytes from " + file);
            }
        }
        return byArray;
    }

    public static String utf8FileToString(File file) throws IonException, IOException {
        byte[] byArray = PrivateUtils.loadFileBytes(file);
        String string = PrivateUtils.utf8(byArray);
        return string;
    }

    public static String loadReader(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(2048);
        char[] cArray = new char[2048];
        while ((n = reader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static boolean streamIsIonBinary(PushbackInputStream pushbackInputStream) throws IonException, IOException {
        boolean bl = false;
        byte[] byArray = new byte[PrivateIonConstants.BINARY_VERSION_MARKER_SIZE];
        int n = PrivateUtils.readFully(pushbackInputStream, byArray);
        if (n == PrivateIonConstants.BINARY_VERSION_MARKER_SIZE) {
            bl = IonStreamUtils.isIonBinary(byArray);
        }
        if (n > 0) {
            pushbackInputStream.unread(byArray, 0, n);
        }
        return bl;
    }

    public static Iterator<IonValue> iterate(ValueFactory valueFactory, IonReader ionReader) {
        return new IonIteratorImpl(valueFactory, ionReader);
    }

    public static boolean valueIsLocalSymbolTable(IonValue ionValue) {
        return ionValue instanceof IonStruct && ionValue.hasTypeAnnotation("$ion_symbol_table");
    }

    public static final boolean symtabIsSharedNotSystem(SymbolTable symbolTable) {
        return symbolTable != null && symbolTable.isSharedTable() && !symbolTable.isSystemTable();
    }

    public static boolean symtabIsLocalAndNonTrivial(SymbolTable symbolTable) {
        if (symbolTable == null) {
            return false;
        }
        if (!symbolTable.isLocalTable()) {
            return false;
        }
        if (symbolTable.getImportedTables().length > 0) {
            return true;
        }
        return symbolTable.getImportedMaxId() < symbolTable.getMaxId();
    }

    public static boolean isTrivialTable(SymbolTable symbolTable) {
        if (symbolTable == null) {
            return true;
        }
        if (symbolTable.isSystemTable()) {
            return true;
        }
        return symbolTable.isLocalTable() && symbolTable.getMaxId() == symbolTable.getSystemSymbolTable().getMaxId();
    }

    public static SymbolTable systemSymtab(int n) {
        return SharedSymbolTable.getSystemSymbolTable(n);
    }

    public static SymbolTable newSharedSymtab(IonStruct ionStruct) {
        return SharedSymbolTable.newSharedSymbolTable(ionStruct);
    }

    public static SymbolTable newSharedSymtab(IonReader ionReader, boolean bl) {
        return SharedSymbolTable.newSharedSymbolTable(ionReader, bl);
    }

    public static SymbolTable newSharedSymtab(String string, int n, SymbolTable symbolTable, Iterator<String> iterator2) {
        return SharedSymbolTable.newSharedSymbolTable(string, n, symbolTable, iterator2);
    }

    public static SymbolTable newLocalSymtab(ValueFactory valueFactory, SymbolTable symbolTable, List<String> list, SymbolTable ... symbolTableArray) {
        return LocalSymbolTable.makeNewLocalSymbolTable(valueFactory, symbolTable, list, symbolTableArray);
    }

    public static SymbolTable newLocalSymtab(ValueFactory valueFactory, SymbolTable symbolTable, SymbolTable ... symbolTableArray) {
        return LocalSymbolTable.makeNewLocalSymbolTable(valueFactory, symbolTable, null, symbolTableArray);
    }

    public static SymbolTable newLocalSymtab(SymbolTable symbolTable, IonCatalog ionCatalog, IonStruct ionStruct) {
        return LocalSymbolTable.makeNewLocalSymbolTable(symbolTable, ionCatalog, ionStruct);
    }

    public static SymbolTable newLocalSymtab(ValueFactory valueFactory, SymbolTable symbolTable, IonCatalog ionCatalog, IonReader ionReader, boolean bl) {
        return LocalSymbolTable.makeNewLocalSymbolTable(valueFactory, symbolTable, ionCatalog, ionReader, bl);
    }

    public static SymbolTable newSubstituteSymtab(SymbolTable symbolTable, int n, int n2) {
        return new SubstituteSymbolTable(symbolTable, n, n2);
    }

    public static SymbolTable copyLocalSymbolTable(SymbolTable symbolTable) throws SubstituteSymbolTableException {
        if (!symbolTable.isLocalTable()) {
            String string = "symtab should be a local symtab";
            throw new IllegalArgumentException(string);
        }
        SymbolTable[] symbolTableArray = ((LocalSymbolTable)symbolTable).getImportedTablesNoCopy();
        for (int i = 0; i < symbolTableArray.length; ++i) {
            if (!symbolTableArray[i].isSubstitute()) continue;
            String string = "local symtabs with substituted symtabs for imports (indicating no exact match within the catalog) cannot be copied";
            throw new SubstituteSymbolTableException(string);
        }
        return ((LocalSymbolTable)symbolTable).makeCopy();
    }

    public static SymbolTable initialSymtab(ValueFactory valueFactory, SymbolTable symbolTable, SymbolTable ... symbolTableArray) {
        if (symbolTableArray == null || symbolTableArray.length == 0) {
            return symbolTable;
        }
        if (symbolTableArray.length == 1 && symbolTableArray[0].isSystemTable()) {
            return symbolTableArray[0];
        }
        return LocalSymbolTable.makeNewLocalSymbolTable(valueFactory, symbolTable, null, symbolTableArray);
    }

    public static IonStruct symtabTree(ValueFactory valueFactory, SymbolTable symbolTable) {
        return ((LocalSymbolTable)symbolTable).getIonRepresentation(valueFactory);
    }

    private static boolean localSymtabExtends(SymbolTable symbolTable, SymbolTable symbolTable2) {
        Object object;
        Object object2;
        SymbolTable[] symbolTableArray;
        if (symbolTable2.getMaxId() > symbolTable.getMaxId()) {
            return false;
        }
        SymbolTable[] symbolTableArray2 = symbolTable.getImportedTables();
        if (symbolTableArray2.length != (symbolTableArray = symbolTable2.getImportedTables()).length) {
            return false;
        }
        for (int i = 0; i < symbolTableArray2.length; ++i) {
            object2 = symbolTableArray2[i];
            object = symbolTableArray[i];
            if (object2.getName().equals(object.getName()) && object2.getVersion() == object.getVersion()) continue;
            return false;
        }
        Iterator<String> iterator2 = symbolTable.iterateDeclaredSymbolNames();
        object2 = symbolTable2.iterateDeclaredSymbolNames();
        while (object2.hasNext()) {
            String string;
            object = (String)object2.next();
            if (((String)object).equals(string = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean symtabExtends(SymbolTable symbolTable, SymbolTable symbolTable2) {
        assert (symbolTable.isSystemTable() || symbolTable.isLocalTable());
        assert (symbolTable2.isSystemTable() || symbolTable2.isLocalTable());
        if (symbolTable == symbolTable2) {
            return true;
        }
        if (symbolTable2.isSystemTable()) {
            return true;
        }
        if (symbolTable.isLocalTable()) {
            if (symbolTable instanceof LocalSymbolTable && symbolTable2 instanceof LocalSymbolTable) {
                return ((LocalSymbolTable)symbolTable).symtabExtends(symbolTable2);
            }
            return PrivateUtils.localSymtabExtends(symbolTable, symbolTable2);
        }
        return symbolTable2.getMaxId() == symbolTable.getMaxId();
    }

    public static boolean isNonSymbolScalar(IonType ionType) {
        return !IonType.isContainer(ionType) && !ionType.equals((Object)IonType.SYMBOL);
    }

    public static final int getSidForSymbolTableField(String string) {
        int n = 4;
        if (string != null && string.length() >= 4) {
            char c = string.charAt(0);
            switch (c) {
                case 'v': {
                    if (!"version".equals(string)) break;
                    return 5;
                }
                case 'n': {
                    if (!"name".equals(string)) break;
                    return 4;
                }
                case 's': {
                    if (!"symbols".equals(string)) break;
                    return 7;
                }
                case 'i': {
                    if (!"imports".equals(string)) break;
                    return 6;
                }
                case 'm': {
                    if (!"max_id".equals(string)) break;
                    return 8;
                }
            }
        }
        return -1;
    }

    public static final Iterator<String> stringIterator(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return PrivateUtils.emptyIterator();
        }
        return new StringIterator(stringArray, stringArray.length);
    }

    public static final Iterator<String> stringIterator(String[] stringArray, int n) {
        if (stringArray == null || stringArray.length == 0 || n == 0) {
            return PrivateUtils.emptyIterator();
        }
        return new StringIterator(stringArray, n);
    }

    public static final Iterator<Integer> intIterator(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return PrivateUtils.emptyIterator();
        }
        return new IntIterator(nArray);
    }

    public static final Iterator<Integer> intIterator(int[] nArray, int n) {
        if (nArray == null || nArray.length == 0 || n == 0) {
            return PrivateUtils.emptyIterator();
        }
        return new IntIterator(nArray, 0, n);
    }

    public static void writeAsBase64(InputStream inputStream2, Appendable appendable) throws IOException {
        int n;
        Base64Encoder.TextStream textStream = new Base64Encoder.TextStream(inputStream2);
        while ((n = textStream.read()) != -1) {
            appendable.append((char)n);
        }
    }

    private static final class IntIterator
    implements Iterator<Integer> {
        private final int[] _values;
        private int _pos;
        private final int _len;

        IntIterator(int[] nArray) {
            this(nArray, 0, nArray.length);
        }

        IntIterator(int[] nArray, int n, int n2) {
            this._values = nArray;
            this._len = n2;
            this._pos = n;
        }

        @Override
        public boolean hasNext() {
            return this._pos < this._len;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this._values[this._pos++];
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class StringIterator
    implements Iterator<String> {
        private final String[] _values;
        private int _pos;
        private final int _len;

        StringIterator(String[] stringArray, int n) {
            this._values = stringArray;
            this._len = n;
        }

        @Override
        public boolean hasNext() {
            return this._pos < this._len;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._values[this._pos++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

