/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.math.BigDecimal;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.impl.PrivateReaderWriter;

@Deprecated
public abstract class PrivateIonWriterBase
implements IonWriter,
PrivateReaderWriter {
    protected static final String ERROR_MISSING_FIELD_NAME = "IonWriter.setFieldName() must be called before writing a value into a struct.";
    static final String ERROR_FINISH_NOT_AT_TOP_LEVEL = "IonWriter.finish() can only be called at top-level.";
    private static final boolean _debug_on = false;
    private int _symbol_table_top = 0;
    private SymbolTable[] _symbol_table_stack = new SymbolTable[3];

    protected abstract int getDepth();

    abstract void writeIonVersionMarker() throws IOException;

    public abstract void setSymbolTable(SymbolTable var1) throws IOException;

    abstract String assumeKnownSymbol(int var1);

    public abstract boolean isFieldNameSet();

    abstract boolean has_annotation(String var1, int var2);

    abstract String[] getTypeAnnotations();

    abstract int[] getTypeAnnotationIds();

    abstract void writeSymbol(int var1) throws IOException;

    @Override
    public void writeBlob(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeNull(IonType.BLOB);
        } else {
            this.writeBlob(byArray, 0, byArray.length);
        }
    }

    @Override
    public void writeClob(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeNull(IonType.CLOB);
        } else {
            this.writeClob(byArray, 0, byArray.length);
        }
    }

    @Override
    public abstract void writeDecimal(BigDecimal var1) throws IOException;

    public void writeFloat(float f) throws IOException {
        this.writeFloat((double)f);
    }

    @Override
    public void writeNull() throws IOException {
        this.writeNull(IonType.NULL);
    }

    @Override
    public final void writeSymbolToken(SymbolToken symbolToken) throws IOException {
        if (symbolToken == null) {
            this.writeNull(IonType.SYMBOL);
            return;
        }
        String string = symbolToken.getText();
        if (string != null) {
            this.writeSymbol(string);
        } else {
            int n = symbolToken.getSid();
            this.writeSymbol(n);
        }
    }

    @Override
    public void writeValues(IonReader ionReader) throws IOException {
        if (ionReader.getDepth() == 0) {
            this.clear_system_value_stack();
        }
        if (ionReader.getType() == null) {
            ionReader.next();
        }
        if (this.getDepth() == 0 && ionReader instanceof PrivateReaderWriter) {
            PrivateReaderWriter privateReaderWriter = (PrivateReaderWriter)((Object)ionReader);
            while (ionReader.getType() != null) {
                this.transfer_symbol_tables(privateReaderWriter);
                this.writeValue(ionReader);
                ionReader.next();
            }
        } else {
            while (ionReader.getType() != null) {
                this.writeValue(ionReader);
                ionReader.next();
            }
        }
    }

    private final void transfer_symbol_tables(PrivateReaderWriter privateReaderWriter) throws IOException {
        SymbolTable symbolTable = privateReaderWriter.pop_passed_symbol_table();
        if (symbolTable != null) {
            this.clear_system_value_stack();
            this.setSymbolTable(symbolTable);
            while (symbolTable != null) {
                this.push_symbol_table(symbolTable);
                symbolTable = privateReaderWriter.pop_passed_symbol_table();
            }
        }
    }

    private final void write_value_field_name_helper(IonReader ionReader) {
        if (this.isInStruct() && !this.isFieldNameSet()) {
            SymbolToken symbolToken = ionReader.getFieldNameSymbol();
            if (symbolToken == null) {
                throw new IllegalStateException("Field name not set");
            }
            this.setFieldNameSymbol(symbolToken);
        }
    }

    private final void write_value_annotations_helper(IonReader ionReader) {
        SymbolToken[] symbolTokenArray = ionReader.getTypeAnnotationSymbols();
        this.setTypeAnnotationSymbols(symbolTokenArray);
    }

    public boolean isStreamCopyOptimized() {
        return false;
    }

    @Override
    public void writeValue(IonReader ionReader) throws IOException {
        IonType ionType = ionReader.getType();
        this.writeValueRecursively(ionType, ionReader);
    }

    final void writeValueRecursively(IonType ionType, IonReader ionReader) throws IOException {
        this.write_value_field_name_helper(ionReader);
        this.write_value_annotations_helper(ionReader);
        if (ionReader.isNullValue()) {
            this.writeNull(ionType);
        } else {
            switch (ionType) {
                case NULL: {
                    this.writeNull();
                    break;
                }
                case BOOL: {
                    this.writeBool(ionReader.booleanValue());
                    break;
                }
                case INT: {
                    this.writeInt(ionReader.bigIntegerValue());
                    break;
                }
                case FLOAT: {
                    this.writeFloat(ionReader.doubleValue());
                    break;
                }
                case DECIMAL: {
                    this.writeDecimal(ionReader.decimalValue());
                    break;
                }
                case TIMESTAMP: {
                    this.writeTimestamp(ionReader.timestampValue());
                    break;
                }
                case STRING: {
                    this.writeString(ionReader.stringValue());
                    break;
                }
                case SYMBOL: {
                    this.writeSymbolToken(ionReader.symbolValue());
                    break;
                }
                case BLOB: {
                    this.writeBlob(ionReader.newBytes());
                    break;
                }
                case CLOB: {
                    this.writeClob(ionReader.newBytes());
                    break;
                }
                case STRUCT: {
                    this.writeContainerRecursively(IonType.STRUCT, ionReader);
                    break;
                }
                case LIST: {
                    this.writeContainerRecursively(IonType.LIST, ionReader);
                    break;
                }
                case SEXP: {
                    this.writeContainerRecursively(IonType.SEXP, ionReader);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void writeContainerRecursively(IonType ionType, IonReader ionReader) throws IOException {
        this.stepIn(ionType);
        ionReader.stepIn();
        while ((ionType = ionReader.next()) != null) {
            this.writeValueRecursively(ionType, ionReader);
        }
        ionReader.stepOut();
        this.stepOut();
    }

    private void clear_system_value_stack() {
        while (this._symbol_table_top > 0) {
            --this._symbol_table_top;
            this._symbol_table_stack[this._symbol_table_top] = null;
        }
    }

    private void push_symbol_table(SymbolTable symbolTable) {
        assert (symbolTable != null);
        if (this._symbol_table_top >= this._symbol_table_stack.length) {
            int n = this._symbol_table_stack.length * 2;
            SymbolTable[] symbolTableArray = new SymbolTable[n];
            System.arraycopy(this._symbol_table_stack, 0, symbolTableArray, 0, this._symbol_table_stack.length);
            this._symbol_table_stack = symbolTableArray;
        }
        this._symbol_table_stack[this._symbol_table_top++] = symbolTable;
    }

    @Override
    public final SymbolTable pop_passed_symbol_table() {
        if (this._symbol_table_top <= 0) {
            return null;
        }
        --this._symbol_table_top;
        SymbolTable symbolTable = this._symbol_table_stack[this._symbol_table_top];
        this._symbol_table_stack[this._symbol_table_top] = null;
        return symbolTable;
    }
}

