/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.util.PrivateFastAppendable;

final class OutputStreamFastAppendable
implements Closeable,
Flushable,
PrivateFastAppendable {
    private static final int MAX_BYTES_LEN = 4096;
    private final OutputStream _out;
    private final byte[] _byteBuffer;
    private int _pos;

    OutputStreamFastAppendable(OutputStream outputStream2) {
        outputStream2.getClass();
        this._out = outputStream2;
        this._pos = 0;
        this._byteBuffer = new byte[4096];
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (c < '\u0080') {
            this.appendAscii(c);
        } else {
            this.appendUtf16(c);
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence) throws IOException {
        this.append(charSequence, 0, charSequence.length());
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
        for (int i = n; i < n2; ++i) {
            this.append(charSequence.charAt(i));
        }
        return this;
    }

    @Override
    public final void appendAscii(char c) throws IOException {
        if (this._pos == this._byteBuffer.length) {
            this._out.write(this._byteBuffer, 0, this._pos);
            this._pos = 0;
        }
        assert (c < '\u0080');
        this._byteBuffer[this._pos++] = (byte)c;
    }

    @Override
    public final void appendAscii(CharSequence charSequence) throws IOException {
        this.appendAscii(charSequence, 0, charSequence.length());
    }

    @Override
    public final void appendAscii(CharSequence charSequence, int n, int n2) throws IOException {
        if (charSequence instanceof String) {
            String string = (String)charSequence;
            int n3 = n2 - n;
            if (this._pos + n3 < this._byteBuffer.length) {
                string.getBytes(n, n2, this._byteBuffer, this._pos);
                this._pos += n3;
            } else {
                do {
                    this._out.write(this._byteBuffer, 0, this._pos);
                    this._pos = n2 - n > this._byteBuffer.length ? this._byteBuffer.length : n2 - n;
                    string.getBytes(n, n + this._pos, this._byteBuffer, 0);
                } while ((n += this._pos) < n2);
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (this._pos == this._byteBuffer.length) {
                    this._out.write(this._byteBuffer, 0, this._pos);
                    this._pos = 0;
                }
                char c = charSequence.charAt(i);
                assert (c < '\u0080');
                this._byteBuffer[this._pos++] = (byte)c;
            }
        }
    }

    @Override
    public final void appendUtf16(char c) throws IOException {
        assert (c >= '\u0080');
        if (this._pos > this._byteBuffer.length - 3) {
            this._out.write(this._byteBuffer, 0, this._pos);
            this._pos = 0;
        }
        if (c < '\u0800') {
            this._byteBuffer[this._pos++] = (byte)(0xFF & (0xC0 | c >> 6));
            this._byteBuffer[this._pos++] = (byte)(0xFF & (0x80 | c & 0x3F));
        } else if (c < '\u10000') {
            this._byteBuffer[this._pos++] = (byte)(0xFF & (0xE0 | c >> 12));
            this._byteBuffer[this._pos++] = (byte)(0xFF & (0x80 | c >> 6 & 0x3F));
            this._byteBuffer[this._pos++] = (byte)(0xFF & (0x80 | c & 0x3F));
        }
    }

    @Override
    public final void appendUtf16Surrogate(char c, char c2) throws IOException {
        int n = PrivateIonConstants.makeUnicodeScalar(c, c2);
        assert (n >= 65536);
        if (this._pos > this._byteBuffer.length - 4) {
            this._out.write(this._byteBuffer, 0, this._pos);
            this._pos = 0;
        }
        this._byteBuffer[this._pos++] = (byte)(0xFF & (0xF0 | n >> 18));
        this._byteBuffer[this._pos++] = (byte)(0xFF & (0x80 | n >> 12 & 0x3F));
        this._byteBuffer[this._pos++] = (byte)(0xFF & (0x80 | n >> 6 & 0x3F));
        this._byteBuffer[this._pos++] = (byte)(0xFF & (0x80 | n & 0x3F));
    }

    @Override
    public final void flush() throws IOException {
        if (this._pos > 0) {
            this._out.write(this._byteBuffer, 0, this._pos);
            this._pos = 0;
        }
        this._out.flush();
    }

    @Override
    public final void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this._out.close();
        }
    }
}

