/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonStruct;
import software.amazon.ion.IonType;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.Timestamp;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.IonWriterSystem;
import software.amazon.ion.impl.IonWriterSystemTree;
import software.amazon.ion.impl.PrivateIonWriter;
import software.amazon.ion.impl.PrivateIonWriterBase;
import software.amazon.ion.impl.PrivateUtils;

class IonWriterUser
extends PrivateIonWriterBase
implements PrivateIonWriter {
    private final ValueFactory _symtab_value_factory;
    private final IonCatalog _catalog;
    final IonWriterSystem _system_writer;
    IonWriterSystem _current_writer;
    private IonStruct _symbol_table_value;

    IonWriterUser(IonCatalog ionCatalog, ValueFactory valueFactory, IonWriterSystem ionWriterSystem) {
        this._symtab_value_factory = valueFactory;
        this._catalog = ionCatalog;
        assert (ionWriterSystem != null);
        this._system_writer = ionWriterSystem;
        this._current_writer = ionWriterSystem;
    }

    IonWriterUser(IonCatalog ionCatalog, ValueFactory valueFactory, IonWriterSystem ionWriterSystem, SymbolTable symbolTable) {
        this(ionCatalog, valueFactory, ionWriterSystem);
        SymbolTable symbolTable2 = ionWriterSystem.getDefaultSystemSymtab();
        if (symbolTable.isLocalTable() || symbolTable != symbolTable2) {
            try {
                this.setSymbolTable(symbolTable);
            }
            catch (IOException iOException) {
                throw new IonException(iOException);
            }
        }
        assert (this._system_writer == this._current_writer && this._system_writer == ionWriterSystem);
    }

    @Override
    public IonCatalog getCatalog() {
        return this._catalog;
    }

    @Override
    boolean has_annotation(String string, int n) {
        return this._current_writer.has_annotation(string, n);
    }

    @Override
    public int getDepth() {
        return this._current_writer.getDepth();
    }

    @Override
    public boolean isInStruct() {
        return this._current_writer.isInStruct();
    }

    @Override
    public void flush() throws IOException {
        this._current_writer.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            try {
                if (this.getDepth() == 0) {
                    assert (this._current_writer == this._system_writer);
                    this.finish();
                }
            }
            finally {
                this._current_writer.close();
            }
        }
        finally {
            this._system_writer.close();
        }
    }

    @Override
    public final void finish() throws IOException {
        if (this.symbol_table_being_collected()) {
            throw new IllegalStateException("IonWriter.finish() can only be called at top-level.");
        }
        this._system_writer.finish();
    }

    SymbolTable activeSystemSymbolTable() {
        return this.getSymbolTable().getSystemSymbolTable();
    }

    private boolean symbol_table_being_collected() {
        return this._current_writer != this._system_writer;
    }

    private void open_local_symbol_table_copy() {
        assert (!this.symbol_table_being_collected());
        this._symbol_table_value = this._symtab_value_factory.newEmptyStruct();
        SymbolToken[] symbolTokenArray = this._system_writer.getTypeAnnotationSymbols();
        this._system_writer.clearAnnotations();
        this._symbol_table_value.setTypeAnnotationSymbols(symbolTokenArray);
        this._current_writer = new IonWriterSystemTree(this.activeSystemSymbolTable(), this._catalog, this._symbol_table_value, null);
    }

    private void close_local_symbol_table_copy() throws IOException {
        assert (this.symbol_table_being_collected());
        SymbolTable symbolTable = PrivateUtils.newLocalSymtab(this.activeSystemSymbolTable(), this._catalog, this._symbol_table_value);
        this._symbol_table_value = null;
        this._current_writer = this._system_writer;
        this.setSymbolTable(symbolTable);
    }

    @Override
    public final void setSymbolTable(SymbolTable symbolTable) throws IOException {
        if (symbolTable == null || PrivateUtils.symtabIsSharedNotSystem(symbolTable)) {
            String string = "symbol table must be local or system to be set, or reset";
            throw new IllegalArgumentException(string);
        }
        if (this.getDepth() > 0) {
            String string = "the symbol table cannot be set, or reset, while a container is open";
            throw new IllegalStateException(string);
        }
        if (symbolTable.isSystemTable()) {
            this.writeIonVersionMarker(symbolTable);
        } else {
            this._system_writer.writeLocalSymtab(symbolTable);
        }
    }

    @Override
    public final SymbolTable getSymbolTable() {
        SymbolTable symbolTable = this._system_writer.getSymbolTable();
        return symbolTable;
    }

    @Override
    final String assumeKnownSymbol(int n) {
        return this._system_writer.assumeKnownSymbol(n);
    }

    @Override
    public final void setFieldName(String string) {
        this._current_writer.setFieldName(string);
    }

    @Override
    public final void setFieldNameSymbol(SymbolToken symbolToken) {
        this._current_writer.setFieldNameSymbol(symbolToken);
    }

    @Override
    public final boolean isFieldNameSet() {
        return this._current_writer.isFieldNameSet();
    }

    @Override
    public void addTypeAnnotation(String string) {
        this._current_writer.addTypeAnnotation(string);
    }

    @Override
    public void setTypeAnnotations(String ... stringArray) {
        this._current_writer.setTypeAnnotations(stringArray);
    }

    @Override
    public void setTypeAnnotationSymbols(SymbolToken ... symbolTokenArray) {
        this._current_writer.setTypeAnnotationSymbols(symbolTokenArray);
    }

    @Override
    String[] getTypeAnnotations() {
        return this._current_writer.getTypeAnnotations();
    }

    @Override
    int[] getTypeAnnotationIds() {
        return this._current_writer.getTypeAnnotationIds();
    }

    final SymbolToken[] getTypeAnnotationSymbols() {
        return this._current_writer.getTypeAnnotationSymbols();
    }

    @Override
    public void stepIn(IonType ionType) throws IOException {
        if (ionType == IonType.STRUCT && this._current_writer.getDepth() == 0 && this.has_annotation("$ion_symbol_table", 3)) {
            this.open_local_symbol_table_copy();
        } else {
            this._current_writer.stepIn(ionType);
        }
    }

    @Override
    public void stepOut() throws IOException {
        if (this.symbol_table_being_collected() && this._current_writer.getDepth() == 1) {
            this.close_local_symbol_table_copy();
        } else {
            this._current_writer.stepOut();
        }
    }

    @Override
    public void writeBlob(byte[] byArray, int n, int n2) throws IOException {
        this._current_writer.writeBlob(byArray, n, n2);
    }

    @Override
    public void writeBool(boolean bl) throws IOException {
        this._current_writer.writeBool(bl);
    }

    @Override
    public void writeClob(byte[] byArray, int n, int n2) throws IOException {
        this._current_writer.writeClob(byArray, n, n2);
    }

    @Override
    public void writeDecimal(BigDecimal bigDecimal) throws IOException {
        this._current_writer.writeDecimal(bigDecimal);
    }

    @Override
    public void writeFloat(double d) throws IOException {
        this._current_writer.writeFloat(d);
    }

    public void writeInt(int n) throws IOException {
        this._current_writer.writeInt(n);
    }

    @Override
    public void writeInt(long l) throws IOException {
        this._current_writer.writeInt(l);
    }

    @Override
    public void writeInt(BigInteger bigInteger) throws IOException {
        this._current_writer.writeInt(bigInteger);
    }

    @Override
    public void writeNull(IonType ionType) throws IOException {
        this._current_writer.writeNull(ionType);
    }

    @Override
    public void writeString(String string) throws IOException {
        this._current_writer.writeString(string);
    }

    @Override
    final void writeSymbol(int n) throws IOException {
        this._current_writer.writeSymbol(n);
    }

    @Override
    public final void writeSymbol(String string) throws IOException {
        this._current_writer.writeSymbol(string);
    }

    final void writeIonVersionMarker(SymbolTable symbolTable) throws IOException {
        this._current_writer.writeIonVersionMarker(symbolTable);
    }

    @Override
    public final void writeIonVersionMarker() throws IOException {
        this._current_writer.writeIonVersionMarker();
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws IOException {
        this._current_writer.writeTimestamp(timestamp);
    }
}

