/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonType;
import software.amazon.ion.OffsetSpan;
import software.amazon.ion.SeekableReader;
import software.amazon.ion.Span;
import software.amazon.ion.SpanProvider;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.ValueFactory;
import software.amazon.ion.impl.DowncastingFaceted;
import software.amazon.ion.impl.IonReaderBinarySystemX;
import software.amazon.ion.impl.PrivateByteTransferReader;
import software.amazon.ion.impl.PrivateByteTransferSink;
import software.amazon.ion.impl.PrivateReaderWriter;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.impl.UnifiedInputStreamX;
import software.amazon.ion.impl.UnifiedSavePointManagerX;

final class IonReaderBinaryUserX
extends IonReaderBinarySystemX
implements PrivateReaderWriter {
    private final int _physical_start_offset;
    IonCatalog _catalog;
    private int _symbol_table_top = 0;
    private SymbolTable[] _symbol_table_stack = new SymbolTable[3];

    public IonReaderBinaryUserX(IonSystem ionSystem, IonCatalog ionCatalog, UnifiedInputStreamX unifiedInputStreamX, int n) {
        super(ionSystem, unifiedInputStreamX);
        this._physical_start_offset = n;
        this.init_user(ionCatalog);
    }

    public IonReaderBinaryUserX(IonSystem ionSystem, IonCatalog ionCatalog, UnifiedInputStreamX unifiedInputStreamX) {
        super(ionSystem, unifiedInputStreamX);
        this._physical_start_offset = 0;
        this.init_user(ionCatalog);
    }

    final void init_user(IonCatalog ionCatalog) {
        this._symbols = this._system.getSystemSymbolTable();
        this._catalog = ionCatalog;
    }

    public Span getCurrentPosition() {
        IonReaderBinarySpan ionReaderBinarySpan = new IonReaderBinarySpan();
        if (this.getType() == null) {
            String string = "IonReader isn't positioned on a value";
            throw new IllegalStateException(string);
        }
        if (this._position_start == -1L) {
            ionReaderBinarySpan._offset = this._input._pos;
            ionReaderBinarySpan._limit = this._input._limit;
            ionReaderBinarySpan._symbol_table = this._symbols;
        } else {
            ionReaderBinarySpan._offset = this._position_start - (long)this._physical_start_offset;
            ionReaderBinarySpan._limit = ionReaderBinarySpan._offset + this._position_len;
            ionReaderBinarySpan._symbol_table = this._symbols;
        }
        return ionReaderBinarySpan;
    }

    public void seek(IonReaderBinarySpan ionReaderBinarySpan) {
        UnifiedSavePointManagerX.SavePoint savePoint;
        IonReaderBinarySpan ionReaderBinarySpan2 = ionReaderBinarySpan;
        if (ionReaderBinarySpan2 == null) {
            throw new IllegalArgumentException("Position invalid for binary reader");
        }
        if (!(this._input instanceof UnifiedInputStreamX.FromByteArray)) {
            throw new UnsupportedOperationException("Binary seek not implemented for non-byte array backed sources");
        }
        UnifiedInputStreamX.FromByteArray fromByteArray = (UnifiedInputStreamX.FromByteArray)this._input;
        fromByteArray._pos = (int)(ionReaderBinarySpan2._offset + (long)this._physical_start_offset);
        fromByteArray._limit = (int)(ionReaderBinarySpan2._limit + (long)this._physical_start_offset);
        fromByteArray._eof = false;
        while ((savePoint = fromByteArray._save_points._active_stack) != null) {
            fromByteArray._save_points.savePointPopActive(savePoint);
            savePoint.free();
        }
        this.re_init_raw();
        this.init_user(this._catalog);
        this._symbols = ionReaderBinarySpan2._symbol_table;
    }

    @Override
    public IonType next() {
        IonType ionType = null;
        if (this.hasNext()) {
            this._has_next_needed = true;
            ionType = this._value_type;
        }
        return ionType;
    }

    @Override
    boolean hasNext() {
        if (!this._eof && this._has_next_needed) {
            this.clear_system_value_stack();
            try {
                while (!this._eof && this._has_next_needed) {
                    this.has_next_helper_user();
                }
            }
            catch (IOException iOException) {
                this.error(iOException);
            }
        }
        return !this._eof;
    }

    private final void has_next_helper_user() throws IOException {
        super.hasNext();
        if (this.getDepth() == 0 && !this._value_is_null) {
            if (this._value_tid == 7) {
                if (this.load_annotations() == 0) {
                    this.load_cached_value(3);
                    int n = this._v.getInt();
                    if (n == 2) {
                        this._symbols = this._system.getSystemSymbolTable();
                        this.push_symbol_table(this._symbols);
                        this._has_next_needed = true;
                    }
                }
            } else if (this._value_tid == 13) {
                int n = this.load_annotations();
                for (int i = 0; i < n; ++i) {
                    if (this._annotation_ids[i] != 3) continue;
                    this._symbols = PrivateUtils.newLocalSymtab((ValueFactory)this._system, this._system.getSystemSymbolTable(), this._catalog, this, false);
                    this.push_symbol_table(this._symbols);
                    this._has_next_needed = true;
                    break;
                }
            } else assert (this._value_tid != 14);
        }
    }

    private void clear_system_value_stack() {
        while (this._symbol_table_top > 0) {
            --this._symbol_table_top;
            this._symbol_table_stack[this._symbol_table_top] = null;
        }
    }

    private void push_symbol_table(SymbolTable symbolTable) {
        assert (symbolTable != null);
        if (this._symbol_table_top >= this._symbol_table_stack.length) {
            int n = this._symbol_table_stack.length * 2;
            SymbolTable[] symbolTableArray = new SymbolTable[n];
            System.arraycopy(this._symbol_table_stack, 0, symbolTableArray, 0, this._symbol_table_stack.length);
            this._symbol_table_stack = symbolTableArray;
        }
        this._symbol_table_stack[this._symbol_table_top++] = symbolTable;
    }

    @Override
    public SymbolTable pop_passed_symbol_table() {
        if (this._symbol_table_top <= 0) {
            return null;
        }
        --this._symbol_table_top;
        SymbolTable symbolTable = this._symbol_table_stack[this._symbol_table_top];
        this._symbol_table_stack[this._symbol_table_top] = null;
        return symbolTable;
    }

    @Override
    public <T> T asFacet(Class<T> clazz) {
        if (clazz == SpanProvider.class) {
            return clazz.cast(new SpanProviderFacet());
        }
        if (this._input instanceof UnifiedInputStreamX.FromByteArray && clazz == SeekableReader.class) {
            return clazz.cast(new SeekableReaderFacet());
        }
        if (clazz == PrivateByteTransferReader.class && this._input instanceof UnifiedInputStreamX.FromByteArray && this.getTypeAnnotationSymbols().length == 0 && !this.isInStruct()) {
            return clazz.cast(new ByteTransferReaderFacet());
        }
        return super.asFacet(clazz);
    }

    private class ByteTransferReaderFacet
    implements PrivateByteTransferReader {
        private ByteTransferReaderFacet() {
        }

        @Override
        public void transferCurrentValue(PrivateByteTransferSink privateByteTransferSink) throws IOException {
            if (!(IonReaderBinaryUserX.this._input instanceof UnifiedInputStreamX.FromByteArray)) {
                throw new UnsupportedOperationException();
            }
            int n = (int)IonReaderBinaryUserX.this._position_start;
            int n2 = (int)IonReaderBinaryUserX.this._position_len;
            privateByteTransferSink.writeBytes(IonReaderBinaryUserX.this._input._bytes, n, n2);
        }
    }

    private class SeekableReaderFacet
    extends SpanProviderFacet
    implements SeekableReader {
        private SeekableReaderFacet() {
        }

        @Override
        public void hoist(Span span) {
            if (!(span instanceof IonReaderBinarySpan)) {
                throw new IllegalArgumentException("Span isn't compatible with this reader.");
            }
            IonReaderBinaryUserX.this.seek((IonReaderBinarySpan)span);
        }
    }

    private class SpanProviderFacet
    implements SpanProvider {
        private SpanProviderFacet() {
        }

        @Override
        public Span currentSpan() {
            return IonReaderBinaryUserX.this.getCurrentPosition();
        }
    }

    private static final class IonReaderBinarySpan
    extends DowncastingFaceted
    implements OffsetSpan,
    Span {
        long _offset;
        long _limit;
        SymbolTable _symbol_table;

        private IonReaderBinarySpan() {
        }

        @Override
        public long getStartOffset() {
            return this._offset;
        }

        @Override
        public long getFinishOffset() {
            return this._limit;
        }
    }
}

