/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import software.amazon.ion.IonException;
import software.amazon.ion.util.IonTextUtils;

final class Base64Encoder {
    private static final EL[] Base64Alphabet = new EL[]{new EL(-1, '='), new EL(0, 'A'), new EL(17, 'R'), new EL(34, 'i'), new EL(51, 'z'), new EL(1, 'B'), new EL(18, 'S'), new EL(35, 'j'), new EL(52, '0'), new EL(2, 'C'), new EL(19, 'T'), new EL(36, 'k'), new EL(53, '1'), new EL(3, 'D'), new EL(20, 'U'), new EL(37, 'l'), new EL(54, '2'), new EL(4, 'E'), new EL(21, 'V'), new EL(38, 'm'), new EL(55, '3'), new EL(5, 'F'), new EL(22, 'W'), new EL(39, 'n'), new EL(56, '4'), new EL(6, 'G'), new EL(23, 'X'), new EL(40, 'o'), new EL(57, '5'), new EL(7, 'H'), new EL(24, 'Y'), new EL(41, 'p'), new EL(58, '6'), new EL(8, 'I'), new EL(25, 'Z'), new EL(42, 'q'), new EL(59, '7'), new EL(9, 'J'), new EL(26, 'a'), new EL(43, 'r'), new EL(60, '8'), new EL(10, 'K'), new EL(27, 'b'), new EL(44, 's'), new EL(61, '9'), new EL(11, 'L'), new EL(28, 'c'), new EL(45, 't'), new EL(62, '+'), new EL(12, 'M'), new EL(29, 'd'), new EL(46, 'u'), new EL(63, '/'), new EL(13, 'N'), new EL(30, 'e'), new EL(47, 'v'), new EL(14, 'O'), new EL(31, 'f'), new EL(48, 'w'), new EL(15, 'P'), new EL(32, 'g'), new EL(49, 'x'), new EL(16, 'Q'), new EL(33, 'h'), new EL(50, 'y')};
    static final char URLSafe64IntToCharTerminator = Base64Encoder.init64IntToCharTerminator(Base64Alphabet);
    static final int[] URLSafe64IntToChar = Base64Encoder.init64IntToChar(Base64Alphabet);
    static final int[] URLSafe64CharToInt = Base64Encoder.init64CharToInt(Base64Alphabet);
    static final int[] Base64EncodingIntToChar = Base64Encoder.init64IntToChar(Base64Alphabet);
    static final int[] Base64EncodingCharToInt = Base64Encoder.init64CharToInt(Base64Alphabet);
    static final char Base64EncodingTerminator = Base64Encoder.init64IntToCharTerminator(Base64Alphabet);
    static final int BUFSIZE = 1024;
    static final int BUFSIZE_BIN = 384;
    static final int BUFSIZE_TEXT = 512;

    private static char init64IntToCharTerminator(EL[] eLArray) {
        for (EL eL : eLArray) {
            if (eL.value != -1) continue;
            return eL.letter;
        }
        throw new RuntimeException(new IonException("fatal: invalid char map definition - missing terminator"));
    }

    private static int[] init64IntToChar(EL[] eLArray) {
        int[] nArray = new int[64];
        for (EL eL : eLArray) {
            if (eL.value == -1) continue;
            nArray[eL.value] = eL.letter;
        }
        return nArray;
    }

    private static int[] init64CharToInt(EL[] eLArray) {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray[i] = -1;
        }
        for (EL eL : eLArray) {
            if (eL.letter > '\u00ff') {
                throw new RuntimeException("fatal base 64 encoding static initializer: letter out of bounds");
            }
            if (eL.value < 0) continue;
            nArray[eL.letter] = eL.value;
        }
        return nArray;
    }

    static final boolean isBase64Character(int n) {
        if (n < 32 || n > 255) {
            return false;
        }
        return URLSafe64CharToInt[n] >= 0;
    }

    private Base64Encoder() {
    }

    static final class TextStream
    extends Reader {
        final InputStream _source;
        final int[] _bintochar;
        final char _padding;
        boolean _ready;
        int _state;
        byte[] _inbuf = new byte[385];
        char[] _outbuf = new char[512];
        int _outBufEnd;
        int _outBufPos;

        TextStream(InputStream inputStream2, int[] nArray, char c) {
            this._source = inputStream2;
            this._bintochar = nArray;
            this._padding = c;
            this._ready = true;
        }

        public TextStream(InputStream inputStream2) {
            this(inputStream2, URLSafe64IntToChar, URLSafe64IntToCharTerminator);
        }

        @Override
        public void close() throws IOException {
            if (this._ready) {
                this._ready = false;
                this._source.close();
            }
            this._inbuf = null;
            this._outbuf = null;
        }

        @Override
        public void mark(int n) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        private void loadNextBuffer() throws IOException {
            this._outBufEnd = 0;
            this._outBufPos = 0;
            int n = this._source.read(this._inbuf, 0, 384);
            if (n < 0) {
                this._state = 1;
                return;
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = this._inbuf[n2++] & 0xFF;
                int n4 = n3 << 16;
                if (n2 >= n) {
                    this._outbuf[this._outBufEnd++] = (char)this._bintochar[(n4 & 0xFC0000) >> 18];
                    this._outbuf[this._outBufEnd++] = (char)this._bintochar[(n4 & 0x3F000) >> 12];
                    this._outbuf[this._outBufEnd++] = this._padding;
                    this._outbuf[this._outBufEnd++] = this._padding;
                    break;
                }
                n3 = this._inbuf[n2++] & 0xFF;
                n4 |= n3 << 8;
                if (n2 >= n) {
                    this._outbuf[this._outBufEnd++] = (char)this._bintochar[(n4 & 0xFC0000) >> 18];
                    this._outbuf[this._outBufEnd++] = (char)this._bintochar[(n4 & 0x3F000) >> 12];
                    this._outbuf[this._outBufEnd++] = (char)this._bintochar[(n4 & 0xFC0) >> 6];
                    this._outbuf[this._outBufEnd++] = this._padding;
                    break;
                }
                n3 = this._inbuf[n2++] & 0xFF;
                this._outbuf[this._outBufEnd++] = (char)this._bintochar[((n4 |= n3 << 0) & 0xFC0000) >> 18];
                this._outbuf[this._outBufEnd++] = (char)this._bintochar[(n4 & 0x3F000) >> 12];
                this._outbuf[this._outBufEnd++] = (char)this._bintochar[(n4 & 0xFC0) >> 6];
                this._outbuf[this._outBufEnd++] = (char)this._bintochar[(n4 & 0x3F) >> 0];
            }
        }

        @Override
        public int read() throws IOException {
            int n = -1;
            if (!this._ready) {
                throw new IOException(this.getClass().getName() + " is closed");
            }
            if (this._state != 0) {
                return -1;
            }
            if (this._outBufPos >= this._outBufEnd) {
                this.loadNextBuffer();
            }
            if (this._outBufPos < this._outBufEnd) {
                n = this._outbuf[this._outBufPos++];
            }
            return n;
        }

        @Override
        public int read(char[] cArray) throws IOException {
            int n;
            if (!this._ready) {
                throw new IOException(this.getClass().getName() + " is closed");
            }
            if (this._state != 0) {
                return -1;
            }
            int n2 = 0;
            for (int i = cArray.length; i > 0; i -= n) {
                if (this._outBufPos >= this._outBufEnd) {
                    this.loadNextBuffer();
                }
                if (this._outBufPos >= this._outBufEnd) break;
                n = this._outBufEnd - this._outBufPos;
                if (n > i) {
                    n = i;
                }
                System.arraycopy(this._outbuf, this._outBufPos, cArray, n2, n);
                this._outBufPos += n;
            }
            return n2;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            if (!this._ready) {
                throw new IOException(this.getClass().getName() + " is closed");
            }
            if (this._state != 0) {
                return -1;
            }
            int n4 = n;
            for (int i = n2; i > 0; i -= n3) {
                if (this._outBufPos >= this._outBufEnd) {
                    this.loadNextBuffer();
                }
                if (this._outBufPos >= this._outBufEnd) break;
                n3 = this._outBufEnd - this._outBufPos;
                if (n3 > i) {
                    n3 = i;
                }
                System.arraycopy(this._outbuf, this._outBufPos, cArray, n4, n3);
                this._outBufPos += n3;
                n4 += n3;
            }
            return n4;
        }

        @Override
        public boolean ready() throws IOException {
            return this._ready && this._source.available() > 0;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("reset not supported");
        }

        @Override
        public long skip(long l) throws IOException {
            if (!this._ready) {
                throw new IOException(this.getClass().getName() + " is closed");
            }
            if (l < 0L) {
                throw new IllegalArgumentException("error skip only support non-negative a values for n");
            }
            long l2 = l;
            while (l2 > 0L) {
                int n = this._outBufEnd - this._outBufPos;
                if (n < 1) {
                    this.loadNextBuffer();
                    n = this._outBufEnd - this._outBufPos;
                    if (n < 1) break;
                }
                if ((long)n > l2) {
                    this._outBufPos += (int)l2;
                    l2 = 0L;
                    break;
                }
                l2 -= (long)n;
                this._outBufPos += n;
            }
            return l - l2;
        }
    }

    static final class BinaryStream
    extends Reader {
        boolean _ready;
        Reader _source;
        int[] _chartobin;
        int _terminator;
        int _otherTerminator;
        int _terminatingChar;
        int _state;
        char[] _buffer;
        int _bufEnd;
        int _bufPos;

        BinaryStream(Reader reader, int[] nArray, char c, char c2) {
            this._source = reader;
            this._chartobin = nArray;
            this._terminator = c;
            this._otherTerminator = c2;
            this._terminatingChar = -1;
            this._buffer = new char[5];
            this._ready = true;
        }

        BinaryStream(Reader reader, char c) {
            this(reader, URLSafe64CharToInt, URLSafe64IntToCharTerminator, c);
        }

        int terminatingChar() {
            return this._terminatingChar;
        }

        private int characterToBinary(int n) throws IOException {
            int n2 = -1;
            if (n >= 0 && n < this._chartobin.length) {
                n2 = this._chartobin[n];
            }
            if (n2 < 0) {
                throw new IonException("invalid base64 character (" + n + ")");
            }
            return n2;
        }

        private void loadNextBuffer() throws IOException {
            int n;
            int n2 = 0;
            int n3 = -1;
            this._bufEnd = 0;
            this._bufPos = 0;
            if (this._state == 1) {
                return;
            }
            while (n2 < 4) {
                n3 = this._source.read();
                if (n3 == -1 || n3 == 65535 || n3 == this._terminator || n3 == this._otherTerminator) {
                    this._terminatingChar = n3;
                    break;
                }
                if (IonTextUtils.isWhitespace(n3)) continue;
                int n4 = this.characterToBinary(n3);
                this._buffer[n2++] = (char)n4;
            }
            if (n2 != 4) {
                if (n2 == 0 && n3 != this._terminator) {
                    this._state = 1;
                    return;
                }
                n = n2;
                while (n3 == this._terminator) {
                    ++n;
                    n3 = this._source.read();
                }
                if (n != 4) {
                    throw new IonException("base64 character count must be divisible by 4, using '=' for padding");
                }
                if (n2 < 1) {
                    throw new IonException("base64 character count must be divisible by 4, but using no more than 3 '=' chars for padding");
                }
                this._terminatingChar = n3;
            }
            n = 0;
            n3 = this._buffer[n++];
            int n5 = n3 << 18;
            n3 = this._buffer[n++];
            n5 |= n3 << 12;
            if (n2 < 3) {
                this._buffer[this._bufEnd++] = (char)((n5 & 0xFF0000) >> 16);
                this._state = 1;
            } else {
                n3 = this._buffer[n++];
                n5 |= n3 << 6;
                if (n2 < 4) {
                    this._buffer[this._bufEnd++] = (char)((n5 & 0xFF0000) >> 16);
                    this._buffer[this._bufEnd++] = (char)((n5 & 0xFF00) >> 8);
                    this._state = 1;
                } else {
                    n3 = this._buffer[n++];
                    this._buffer[this._bufEnd++] = (char)(((n5 |= n3 << 0) & 0xFF0000) >> 16);
                    this._buffer[this._bufEnd++] = (char)((n5 & 0xFF00) >> 8);
                    this._buffer[this._bufEnd++] = (char)((n5 & 0xFF) >> 0);
                }
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void close() throws IOException {
            this._source.close();
        }

        @Override
        public int read() throws IOException {
            int n = -1;
            if (!this._ready) {
                throw new IOException(this.getClass().getName() + " is not ready");
            }
            if (this._bufPos >= this._bufEnd) {
                this.loadNextBuffer();
            }
            if (this._bufPos < this._bufEnd) {
                n = this._buffer[this._bufPos++];
            }
            return n;
        }

        @Override
        public int read(char[] cArray) throws IOException {
            int n;
            int n2 = 0;
            for (n2 = 0; n2 < cArray.length && (n = this.read()) != -1; ++n2) {
                cArray[n2] = (char)n;
            }
            return n2;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3;
            int n4 = 0;
            for (n4 = 0; n4 < n2 && (n3 = this.read()) != -1; ++n4) {
                cArray[n + n4] = (char)n3;
            }
            return n4;
        }
    }

    static class EL {
        public int value;
        public char letter;

        public EL(int n, char c) {
            this.value = n;
            this.letter = c;
        }
    }
}

