/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.apps;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.system.IonSystemBuilder;
import software.amazon.ion.system.SimpleCatalog;

abstract class BaseApp {
    protected SimpleCatalog myCatalog = new SimpleCatalog();
    protected IonSystem mySystem = IonSystemBuilder.standard().withCatalog(this.myCatalog).build();

    BaseApp() {
    }

    protected static byte[] loadAsByteArray(InputStream inputStream2) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream2.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] loadAsByteArray(File file) throws FileNotFoundException, IOException {
        long l = file.length();
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + file);
        }
        byte[] byArray = new byte[(int)l];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n = fileInputStream.read(byArray);
            if ((long)n != l || fileInputStream.read() != -1) {
                System.err.println("Read the wrong number of bytes from " + file);
                byte[] byArray2 = null;
                return byArray2;
            }
        }
        return byArray;
    }

    public void doMain(String[] stringArray) {
        int n = this.processOptions(stringArray);
        int n2 = stringArray.length - n;
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        if (this.optionsAreValid(stringArray2)) {
            this.processFiles(stringArray2);
        }
    }

    protected int processOptions(String[] stringArray) {
        return 0;
    }

    protected boolean optionsAreValid(String[] stringArray) {
        return true;
    }

    protected void processFiles(String[] stringArray) {
        if (stringArray.length == 0) {
            this.processStdIn();
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                this.processFile(string);
            }
        }
    }

    protected boolean processFile(String string) {
        File file = new File(string);
        if (file.canRead() && file.isFile()) {
            try {
                this.process(file);
                return true;
            }
            catch (IonException ionException) {
                System.err.println("An error occurred while processing " + string);
                System.err.println(ionException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println("An error occurred while processing " + string);
                System.err.println(iOException.getMessage());
            }
        } else {
            System.err.println("Skipping unreadable file: " + string);
        }
        return false;
    }

    protected void processStdIn() {
        try {
            byte[] byArray = BaseApp.loadAsByteArray(System.in);
            IonReader ionReader = this.mySystem.newReader(byArray);
            this.process(ionReader);
        }
        catch (IonException ionException) {
            System.err.println("An error occurred while processing stdin");
            System.err.println(ionException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println("An error occurred while processing stdin");
            System.err.println(iOException.getMessage());
        }
    }

    protected void process(File file) throws IOException, IonException {
        byte[] byArray = BaseApp.loadAsByteArray(file);
        IonReader ionReader = this.mySystem.newReader(byArray);
        this.process(file, ionReader);
    }

    protected void process(File file, IonReader ionReader) throws IOException, IonException {
        this.process(ionReader);
    }

    protected void process(IonReader ionReader) throws IOException, IonException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCatalog(String string) {
        Object object;
        System.err.println("Loading catalog from " + string);
        File file = new File(string);
        try {
            object = new BufferedInputStream(new FileInputStream(file));
            try {
                IonReader ionReader = this.mySystem.newReader((InputStream)object);
                while (ionReader.next() != null) {
                    SymbolTable symbolTable = this.mySystem.newSharedSymbolTable(ionReader, true);
                    this.myCatalog.putTable(symbolTable);
                }
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error loading catalog from " + string + ": " + exception.getMessage(), exception);
        }
        object = this.mySystem.getCatalog();
        assert (this.myCatalog == object);
    }

    protected SymbolTable getLatestSharedSymtab(String string) {
        IonCatalog ionCatalog = this.mySystem.getCatalog();
        SymbolTable symbolTable = ionCatalog.getTable(string);
        if (symbolTable == null) {
            String string2 = "There's no symbol table in the catalog named " + string;
            throw new RuntimeException(string2);
        }
        this.logDebug("Found shared symbol table " + string + "@" + symbolTable.getVersion());
        return symbolTable;
    }

    protected void logDebug(String string) {
        System.err.println(string);
    }
}

