/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import software.amazon.ion.impl.PrivateUtils;
import software.amazon.ion.util.IonTextUtils;

public final class Timestamp
implements Cloneable,
Comparable<Timestamp> {
    private static final boolean APPLY_OFFSET_YES = true;
    private static final boolean APPLY_OFFSET_NO = false;
    private static final int NO_MONTH = 0;
    private static final int NO_DAY = 0;
    private static final int NO_HOURS = 0;
    private static final int NO_MINUTES = 0;
    private static final int NO_SECONDS = 0;
    private static final BigDecimal NO_FRACTIONAL_SECONDS = null;
    public static final Integer UNKNOWN_OFFSET = null;
    public static final Integer UTC_OFFSET = 0;
    private static final int FLAG_YEAR = 1;
    private static final int FLAG_MONTH = 2;
    private static final int FLAG_DAY = 4;
    private static final int FLAG_MINUTE = 8;
    private static final int FLAG_SECOND = 16;
    private static final int HASH_SIGNATURE = "INTERNAL TIMESTAMP".hashCode();
    private Precision _precision;
    private short _year;
    private byte _month = 1;
    private byte _day = 1;
    private byte _hour;
    private byte _minute;
    private byte _second;
    private BigDecimal _fraction;
    private Integer _offset;
    private static final int[] LEAP_DAYS_IN_MONTH = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] NORMAL_DAYS_IN_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final String NULL_TIMESTAMP_IMAGE = "null.timestamp";
    static final int LEN_OF_NULL_IMAGE = "null.timestamp".length();
    static final int END_OF_YEAR = 4;
    static final int END_OF_MONTH = 7;
    static final int END_OF_DAY = 10;
    static final int END_OF_MINUTES = 16;
    static final int END_OF_SECONDS = 19;

    private static int last_day_in_month(int n, int n2) {
        boolean bl = n % 4 == 0 ? (n % 100 == 0 ? n % 400 == 0 : true) : false;
        return bl ? LEAP_DAYS_IN_MONTH[n2] : NORMAL_DAYS_IN_MONTH[n2];
    }

    private void apply_offset(int n) {
        if (n == 0) {
            return;
        }
        if (n < -1440 || n > 1440) {
            throw new IllegalArgumentException("bad offset " + n);
        }
        n = -n;
        int n2 = n / 60;
        int n3 = n - n2 * 60;
        if (n < 0) {
            this._minute = (byte)(this._minute + n3);
            this._hour = (byte)(this._hour + n2);
            if (this._minute < 0) {
                this._minute = (byte)(this._minute + 60);
                this._hour = (byte)(this._hour - 1);
            }
            if (this._hour >= 0) {
                return;
            }
            this._hour = (byte)(this._hour + 24);
            this._day = (byte)(this._day - 1);
            if (this._day >= 1) {
                return;
            }
            this._month = (byte)(this._month - 1);
            if (this._month >= 1) {
                this._day = (byte)(this._day + Timestamp.last_day_in_month(this._year, this._month));
                assert (this._day == Timestamp.last_day_in_month(this._year, this._month));
                return;
            }
            this._month = (byte)(this._month + 12);
            this._year = (short)(this._year - 1);
            if (this._year < 1) {
                throw new IllegalArgumentException("year is less than 1");
            }
            this._day = (byte)(this._day + Timestamp.last_day_in_month(this._year, this._month));
            assert (this._day == Timestamp.last_day_in_month(this._year, this._month));
        } else {
            this._minute = (byte)(this._minute + n3);
            this._hour = (byte)(this._hour + n2);
            if (this._minute > 59) {
                this._minute = (byte)(this._minute - 60);
                this._hour = (byte)(this._hour + 1);
            }
            if (this._hour < 24) {
                return;
            }
            this._hour = (byte)(this._hour - 24);
            this._day = (byte)(this._day + 1);
            if (this._day <= Timestamp.last_day_in_month(this._year, this._month)) {
                return;
            }
            this._day = 1;
            this._month = (byte)(this._month + 1);
            if (this._month <= 12) {
                return;
            }
            this._month = (byte)(this._month - 12);
            this._year = (short)(this._year + 1);
            if (this._year > 9999) {
                throw new IllegalArgumentException("year exceeds 9999");
            }
        }
    }

    private void set_fields_from_millis(long l) {
        Date date = new Date(l);
        this._year = Timestamp.checkAndCastYear(date.getYear() + 1900);
        this._month = Timestamp.checkAndCastMonth(date.getMonth() + 1);
        this._day = Timestamp.checkAndCastDay(date.getDate(), this._year, this._month);
        this._hour = Timestamp.checkAndCastHour(date.getHours());
        this._minute = Timestamp.checkAndCastMinute(date.getMinutes());
        this._second = Timestamp.checkAndCastSecond(date.getSeconds());
        int n = date.getTimezoneOffset();
        this.apply_offset(-n);
    }

    private void set_fields_from_calendar(Calendar calendar, Precision precision, boolean bl) {
        this._precision = precision;
        this._offset = UNKNOWN_OFFSET;
        boolean bl2 = false;
        boolean bl3 = calendar.isSet(14);
        switch (this._precision) {
            case SECOND: {
                this._second = Timestamp.checkAndCastSecond(calendar.get(13));
                if (bl3) {
                    BigDecimal bigDecimal = BigDecimal.valueOf(calendar.get(14));
                    this._fraction = bigDecimal.movePointLeft(3);
                }
            }
            case MINUTE: {
                this._hour = Timestamp.checkAndCastHour(calendar.get(11));
                this._minute = Timestamp.checkAndCastMinute(calendar.get(12));
                if (bl && calendar.isSet(15)) {
                    int n = calendar.get(15);
                    if (calendar.isSet(16)) {
                        n += calendar.get(16);
                    }
                    this._offset = n / 60000;
                }
            }
            case DAY: {
                bl2 = true;
            }
            case MONTH: {
                this._month = Timestamp.checkAndCastMonth(calendar.get(2) + 1);
            }
            case YEAR: {
                this._year = Timestamp.checkAndCastYear(calendar.get(1));
            }
        }
        if (bl2) {
            this._day = Timestamp.checkAndCastDay(calendar.get(5), this._year, this._month);
        }
        if (this._offset != UNKNOWN_OFFSET) {
            this.apply_offset(this._offset);
        }
    }

    private Timestamp(int n) {
        this(Precision.YEAR, n, 0, 0, 0, 0, 0, NO_FRACTIONAL_SECONDS, UNKNOWN_OFFSET, false);
    }

    private Timestamp(int n, int n2) {
        this(Precision.MONTH, n, n2, 0, 0, 0, 0, NO_FRACTIONAL_SECONDS, UNKNOWN_OFFSET, false);
    }

    @Deprecated
    private Timestamp(int n, int n2, int n3) {
        this(Precision.DAY, n, n2, n3, 0, 0, 0, NO_FRACTIONAL_SECONDS, UNKNOWN_OFFSET, false);
    }

    @Deprecated
    private Timestamp(int n, int n2, int n3, int n4, int n5, Integer n6) {
        this(Precision.MINUTE, n, n2, n3, n4, n5, 0, NO_FRACTIONAL_SECONDS, n6, true);
    }

    @Deprecated
    private Timestamp(int n, int n2, int n3, int n4, int n5, int n6, Integer n7) {
        this(Precision.SECOND, n, n2, n3, n4, n5, n6, NO_FRACTIONAL_SECONDS, n7, true);
    }

    private Timestamp(Precision precision, int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, Integer n7, boolean bl) {
        boolean bl2 = false;
        switch (precision) {
            default: {
                throw new IllegalArgumentException("invalid Precision passed to constructor");
            }
            case SECOND: {
                this._fraction = bigDecimal == null || bigDecimal.equals(BigDecimal.ZERO) ? null : bigDecimal.abs();
                this._second = Timestamp.checkAndCastSecond(n6);
            }
            case MINUTE: {
                this._minute = Timestamp.checkAndCastMinute(n5);
                this._hour = Timestamp.checkAndCastHour(n4);
                this._offset = n7;
            }
            case DAY: {
                bl2 = true;
            }
            case MONTH: {
                this._month = Timestamp.checkAndCastMonth(n2);
            }
            case YEAR: 
        }
        this._year = Timestamp.checkAndCastYear(n);
        if (bl2) {
            this._day = Timestamp.checkAndCastDay(n3, n, n2);
        }
        this._precision = Timestamp.checkFraction(precision, this._fraction);
        if (bl && n7 != null) {
            this.apply_offset(n7);
        }
    }

    @Deprecated
    public static Timestamp createFromUtcFields(Precision precision, int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, Integer n7) {
        return new Timestamp(precision, n, n2, n3, n4, n5, n6, bigDecimal, n7, false);
    }

    @Deprecated
    private Timestamp(Calendar calendar) {
        Precision precision;
        if (calendar.isSet(14) || calendar.isSet(13)) {
            precision = Precision.SECOND;
        } else if (calendar.isSet(11) || calendar.isSet(12)) {
            precision = Precision.MINUTE;
        } else if (calendar.isSet(5)) {
            precision = Precision.DAY;
        } else if (calendar.isSet(2)) {
            precision = Precision.MONTH;
        } else if (calendar.isSet(1)) {
            precision = Precision.YEAR;
        } else {
            throw new IllegalArgumentException("Calendar has no fields set");
        }
        this.set_fields_from_calendar(calendar, precision, true);
    }

    private Timestamp(Calendar calendar, Precision precision, BigDecimal bigDecimal, Integer n) {
        this.set_fields_from_calendar(calendar, precision, false);
        this._fraction = bigDecimal;
        if (n != null) {
            this._offset = n;
            this.apply_offset(n);
        }
    }

    private Timestamp(BigDecimal bigDecimal, Precision precision, Integer n) {
        long l = bigDecimal.longValue();
        this.set_fields_from_millis(l);
        switch (precision) {
            case YEAR: {
                this._month = 1;
            }
            case MONTH: {
                this._day = 1;
            }
            case DAY: {
                this._hour = 0;
                this._minute = 0;
            }
            case MINUTE: {
                this._second = 0;
                this._fraction = null;
                break;
            }
            case SECOND: {
                BigDecimal bigDecimal2 = bigDecimal.movePointLeft(3);
                BigDecimal bigDecimal3 = bigDecimal2.setScale(0, RoundingMode.FLOOR);
                this._fraction = bigDecimal2.subtract(bigDecimal3);
            }
        }
        this._precision = Timestamp.checkFraction(precision, this._fraction);
        this._offset = n;
    }

    @Deprecated
    private Timestamp(BigDecimal bigDecimal, Integer n) {
        if (bigDecimal == null) {
            throw new NullPointerException("millis is null");
        }
        long l = bigDecimal.longValue();
        this.set_fields_from_millis(l);
        this._precision = Precision.SECOND;
        int n2 = bigDecimal.scale();
        if (n2 <= -3) {
            this._fraction = null;
        } else {
            BigDecimal bigDecimal2 = bigDecimal.movePointLeft(3);
            BigDecimal bigDecimal3 = bigDecimal2.setScale(0, RoundingMode.FLOOR);
            this._fraction = bigDecimal2.subtract(bigDecimal3);
        }
        this._offset = n;
    }

    @Deprecated
    private Timestamp(long l, Integer n) {
        this.set_fields_from_millis(l);
        BigDecimal bigDecimal = BigDecimal.valueOf(l).movePointLeft(3);
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, RoundingMode.FLOOR);
        this._fraction = bigDecimal.subtract(bigDecimal2);
        this._precision = Timestamp.checkFraction(Precision.SECOND, this._fraction);
        this._offset = n;
    }

    private static IllegalArgumentException fail(CharSequence charSequence, String string) {
        charSequence = IonTextUtils.printString(charSequence);
        return new IllegalArgumentException("invalid timestamp: " + string + ": " + charSequence);
    }

    private static IllegalArgumentException fail(CharSequence charSequence) {
        charSequence = IonTextUtils.printString(charSequence);
        return new IllegalArgumentException("invalid timestamp: " + charSequence);
    }

    public static Timestamp valueOf(CharSequence charSequence) {
        Integer n;
        int n2;
        CharSequence charSequence2 = charSequence;
        int n3 = charSequence2.length();
        if (n3 == 0) {
            throw Timestamp.fail(charSequence2);
        }
        if (charSequence2.charAt(0) == 'n') {
            if (n3 >= LEN_OF_NULL_IMAGE && NULL_TIMESTAMP_IMAGE.contentEquals(charSequence2.subSequence(0, LEN_OF_NULL_IMAGE))) {
                if (n3 > LEN_OF_NULL_IMAGE && !Timestamp.isValidFollowChar(charSequence2.charAt(LEN_OF_NULL_IMAGE))) {
                    throw Timestamp.fail(charSequence2);
                }
                return null;
            }
            throw Timestamp.fail(charSequence2);
        }
        int n4 = 1;
        int n5 = 1;
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        BigDecimal bigDecimal = null;
        if (n3 < 5) {
            throw Timestamp.fail(charSequence2, "year is too short (must be at least yyyyT)");
        }
        int n10 = 4;
        Precision precision = Precision.YEAR;
        n4 = Timestamp.read_digits(charSequence2, 0, 4, -1, "year");
        char c = charSequence2.charAt(4);
        if (c != 'T') {
            if (c != '-') {
                throw Timestamp.fail(charSequence2, "expected \"-\" between year and month, found " + IonTextUtils.printCodePointAsString(c));
            }
            if (n3 < 8) {
                throw Timestamp.fail(charSequence2, "month is too short (must be yyyy-mmT)");
            }
            n10 = 7;
            precision = Precision.MONTH;
            n5 = Timestamp.read_digits(charSequence2, 5, 2, -1, "month");
            c = charSequence2.charAt(7);
            if (c != 'T') {
                if (c != '-') {
                    throw Timestamp.fail(charSequence2, "expected \"-\" between month and day, found " + IonTextUtils.printCodePointAsString(c));
                }
                if (n3 < 10) {
                    throw Timestamp.fail(charSequence2, "too short for yyyy-mm-dd");
                }
                n10 = 10;
                precision = Precision.DAY;
                n6 = Timestamp.read_digits(charSequence2, 8, 2, -1, "day");
                if (n3 != 10) {
                    c = charSequence2.charAt(10);
                    if (c != 'T') {
                        throw Timestamp.fail(charSequence2, "expected \"T\" after day, found " + IonTextUtils.printCodePointAsString(c));
                    }
                    if (n3 != 11) {
                        if (n3 < 16) {
                            throw Timestamp.fail(charSequence2, "too short for yyyy-mm-ddThh:mm");
                        }
                        n7 = Timestamp.read_digits(charSequence2, 11, 2, 58, "hour");
                        n8 = Timestamp.read_digits(charSequence2, 14, 2, -1, "minutes");
                        n10 = 16;
                        precision = Precision.MINUTE;
                        if (n3 > 16 && charSequence2.charAt(16) == ':') {
                            if (n3 < 19) {
                                throw Timestamp.fail(charSequence2, "too short for yyyy-mm-ddThh:mm:ss");
                            }
                            n9 = Timestamp.read_digits(charSequence2, 17, 2, -1, "seconds");
                            n10 = 19;
                            precision = Precision.SECOND;
                            if (n3 > 19 && charSequence2.charAt(19) == '.') {
                                precision = Precision.SECOND;
                                for (n10 = 20; n3 > n10 && Character.isDigit(charSequence2.charAt(n10)); ++n10) {
                                }
                                if (n10 <= 20) {
                                    throw Timestamp.fail(charSequence2, "must have at least one digit after decimal point");
                                }
                                bigDecimal = new BigDecimal(charSequence2.subSequence(19, n10).toString());
                            }
                        }
                    }
                }
            }
        }
        int n11 = n2 = n10 < n3 ? (int)charSequence2.charAt(n10) : 10;
        if (n2 == 90) {
            n = 0;
            ++n10;
        } else if (n2 == 43 || n2 == 45) {
            int n12;
            if (n3 < n10 + 5) {
                throw Timestamp.fail(charSequence2, "local offset too short");
            }
            if ((n12 = Timestamp.read_digits(charSequence2, ++n10, 2, 58, "local offset hours")) < 0 || n12 > 23) {
                throw Timestamp.fail(charSequence2, "local offset hours must be between 0 and 23 inclusive");
            }
            int n13 = Timestamp.read_digits(charSequence2, n10 += 3, 2, -1, "local offset minutes");
            if (n13 > 59) {
                throw Timestamp.fail(charSequence2, "local offset minutes must be between 0 and 59 inclusive");
            }
            n10 += 2;
            int n14 = n12 * 60 + n13;
            if (n2 == 45) {
                n14 = -n14;
            }
            n = n14 == 0 && n2 == 45 ? null : Integer.valueOf(n14);
        } else {
            switch (precision) {
                case DAY: 
                case MONTH: 
                case YEAR: {
                    break;
                }
                default: {
                    throw Timestamp.fail(charSequence2, "missing local offset");
                }
            }
            n = null;
        }
        if (n3 > n10 + 1 && !Timestamp.isValidFollowChar(charSequence2.charAt(n10 + 1))) {
            throw Timestamp.fail(charSequence2, "invalid excess characters");
        }
        Timestamp timestamp = new Timestamp(precision, n4, n5, n6, n7, n8, n9, bigDecimal, n, true);
        return timestamp;
    }

    private static int read_digits(CharSequence charSequence, int n, int n2, int n3, String string) {
        int n4;
        int n5 = 0;
        int n6 = n + n2;
        if (charSequence.length() < n6) {
            throw Timestamp.fail(charSequence, string + " requires " + n2 + " digits");
        }
        for (n4 = n; n4 < n6; ++n4) {
            char c = charSequence.charAt(n4);
            if (!Character.isDigit(c)) {
                throw Timestamp.fail(charSequence, string + " has non-digit character " + IonTextUtils.printCodePointAsString(c));
            }
            n5 *= 10;
            n5 += c - 48;
        }
        if (n3 != -1) {
            if (n4 >= charSequence.length() || charSequence.charAt(n4) != n3) {
                throw Timestamp.fail(charSequence, string + " should end with " + IonTextUtils.printCodePointAsString(n3));
            }
        } else if (n4 < charSequence.length() && Character.isDigit(charSequence.charAt(n4))) {
            throw Timestamp.fail(charSequence, string + " requires " + n2 + " digits but has more");
        }
        return n5;
    }

    private static boolean isValidFollowChar(char c) {
        switch (c) {
            default: {
                return false;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case '\"': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': 
        }
        return true;
    }

    public Timestamp clone() {
        return new Timestamp(this._precision, this._year, this._month, this._day, this._hour, this._minute, this._second, this._fraction, this._offset, false);
    }

    private Timestamp make_localtime() {
        int n = this._offset != null ? this._offset : 0;
        Timestamp timestamp = new Timestamp(this._precision, this._year, this._month, this._day, this._hour, this._minute, this._second, this._fraction, this._offset, false);
        timestamp.apply_offset(-n);
        assert (timestamp._offset == this._offset);
        return timestamp;
    }

    public static Timestamp forYear(int n) {
        return new Timestamp(n);
    }

    public static Timestamp forMonth(int n, int n2) {
        return new Timestamp(n, n2);
    }

    public static Timestamp forDay(int n, int n2, int n3) {
        return new Timestamp(n, n2, n3);
    }

    public static Timestamp forMinute(int n, int n2, int n3, int n4, int n5, Integer n6) {
        return new Timestamp(n, n2, n3, n4, n5, n6);
    }

    public static Timestamp forSecond(int n, int n2, int n3, int n4, int n5, int n6, Integer n7) {
        return new Timestamp(n, n2, n3, n4, n5, n6, n7);
    }

    public static Timestamp forSecond(int n, int n2, int n3, int n4, int n5, BigDecimal bigDecimal, Integer n6) {
        int n7 = bigDecimal.intValue();
        BigDecimal bigDecimal2 = bigDecimal.subtract(BigDecimal.valueOf(n7));
        return new Timestamp(Precision.SECOND, n, n2, n3, n4, n5, n7, bigDecimal2, n6, true);
    }

    public static Timestamp forMillis(long l, Integer n) {
        return new Timestamp(l, n);
    }

    public static Timestamp forMillis(BigDecimal bigDecimal, Integer n) {
        return new Timestamp(bigDecimal, n);
    }

    public static Timestamp forCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return new Timestamp(calendar);
    }

    public static Timestamp forDateZ(Date date) {
        if (date == null) {
            return null;
        }
        long l = date.getTime();
        return new Timestamp(l, UTC_OFFSET);
    }

    public static Timestamp forSqlTimestampZ(java.sql.Timestamp timestamp) {
        BigDecimal bigDecimal;
        if (timestamp == null) {
            return null;
        }
        long l = timestamp.getTime();
        Timestamp timestamp2 = new Timestamp(l, UTC_OFFSET);
        int n = timestamp.getNanos();
        timestamp2._fraction = bigDecimal = BigDecimal.valueOf(n).movePointLeft(9);
        return timestamp2;
    }

    public static Timestamp now() {
        long l = System.currentTimeMillis();
        return new Timestamp(l, UNKNOWN_OFFSET);
    }

    public static Timestamp nowZ() {
        long l = System.currentTimeMillis();
        return new Timestamp(l, UTC_OFFSET);
    }

    public Date dateValue() {
        long l = this.getMillis();
        return new Date(l);
    }

    public Calendar calendarValue() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(PrivateUtils.UTC);
        long l = this.getMillis();
        Integer n = this._offset;
        if (n != null && n != 0) {
            int n2 = n * 60 * 1000;
            gregorianCalendar.setTimeInMillis(l += (long)n2);
            gregorianCalendar.set(15, n2);
        } else {
            gregorianCalendar.setTimeInMillis(l);
        }
        return gregorianCalendar;
    }

    public long getMillis() {
        long l = Date.UTC(this._year - 1900, this._month - 1, this._day, this._hour, this._minute, this._second);
        if (this._fraction != null) {
            int n = this._fraction.movePointRight(3).intValue();
            l += (long)n;
        }
        return l;
    }

    public BigDecimal getDecimalMillis() {
        switch (this._precision) {
            case SECOND: 
            case MINUTE: 
            case DAY: 
            case MONTH: 
            case YEAR: {
                long l = Date.UTC(this._year - 1900, this._month - 1, this._day, this._hour, this._minute, this._second);
                BigDecimal bigDecimal = BigDecimal.valueOf(l);
                if (this._fraction != null) {
                    bigDecimal = bigDecimal.add(this._fraction.movePointRight(3));
                }
                return bigDecimal;
            }
        }
        throw new IllegalArgumentException();
    }

    public Precision getPrecision() {
        return this._precision;
    }

    public Integer getLocalOffset() {
        return this._offset;
    }

    public int getYear() {
        Timestamp timestamp = this;
        if (this._offset != null && this._offset != 0) {
            timestamp = this.make_localtime();
        }
        return timestamp._year;
    }

    public int getMonth() {
        Timestamp timestamp = this;
        if (this._offset != null && this._offset != 0) {
            timestamp = this.make_localtime();
        }
        return timestamp._month;
    }

    public int getDay() {
        Timestamp timestamp = this;
        if (this._offset != null && this._offset != 0) {
            timestamp = this.make_localtime();
        }
        return timestamp._day;
    }

    public int getHour() {
        Timestamp timestamp = this;
        if (this._offset != null && this._offset != 0) {
            timestamp = this.make_localtime();
        }
        return timestamp._hour;
    }

    public int getMinute() {
        Timestamp timestamp = this;
        if (this._offset != null && this._offset != 0) {
            timestamp = this.make_localtime();
        }
        return timestamp._minute;
    }

    public int getSecond() {
        return this._second;
    }

    public BigDecimal getDecimalSecond() {
        BigDecimal bigDecimal = BigDecimal.valueOf(this._second);
        if (this._fraction != null) {
            bigDecimal = bigDecimal.add(this._fraction);
        }
        return bigDecimal;
    }

    public int getZYear() {
        return this._year;
    }

    public int getZMonth() {
        return this._month;
    }

    public int getZDay() {
        return this._day;
    }

    public int getZHour() {
        return this._hour;
    }

    public int getZMinute() {
        return this._minute;
    }

    public int getZSecond() {
        return this._second;
    }

    public BigDecimal getZDecimalSecond() {
        return this.getDecimalSecond();
    }

    @Deprecated
    public BigDecimal getZFractionalSecond() {
        return this._fraction;
    }

    public Timestamp withLocalOffset(Integer n) {
        Precision precision = this.getPrecision();
        if (precision.alwaysUnknownOffset() || PrivateUtils.safeEquals(n, this.getLocalOffset())) {
            return this;
        }
        Timestamp timestamp = Timestamp.createFromUtcFields(precision, this.getZYear(), this.getZMonth(), this.getZDay(), this.getZHour(), this.getZMinute(), this.getZSecond(), this.getZFractionalSecond(), n);
        return timestamp;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        try {
            this.print(stringBuilder);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Exception printing to StringBuilder", iOException);
        }
        return stringBuilder.toString();
    }

    public String toZString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        try {
            this.printZ(stringBuilder);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Exception printing to StringBuilder", iOException);
        }
        return stringBuilder.toString();
    }

    public void print(Appendable appendable) throws IOException {
        Timestamp timestamp = this;
        if (this._offset != null && this._offset != 0) {
            timestamp = this.make_localtime();
        }
        Timestamp.print(appendable, timestamp);
    }

    public void printZ(Appendable appendable) throws IOException {
        switch (this._precision) {
            case DAY: 
            case MONTH: 
            case YEAR: {
                assert (this._offset == UNKNOWN_OFFSET);
                this.print(appendable);
                break;
            }
            case SECOND: 
            case MINUTE: {
                Timestamp timestamp = this.clone();
                timestamp._offset = UTC_OFFSET;
                timestamp.print(appendable);
                break;
            }
        }
    }

    private static void print(Appendable appendable, Timestamp timestamp) throws IOException {
        if (timestamp == null) {
            appendable.append(NULL_TIMESTAMP_IMAGE);
            return;
        }
        Timestamp.print_digits(appendable, timestamp._year, 4);
        if (timestamp._precision == Precision.YEAR) {
            assert (timestamp._offset == UNKNOWN_OFFSET);
            appendable.append("T");
            return;
        }
        appendable.append("-");
        Timestamp.print_digits(appendable, timestamp._month, 2);
        if (timestamp._precision == Precision.MONTH) {
            assert (timestamp._offset == UNKNOWN_OFFSET);
            appendable.append("T");
            return;
        }
        appendable.append("-");
        Timestamp.print_digits(appendable, timestamp._day, 2);
        if (timestamp._precision == Precision.DAY) {
            assert (timestamp._offset == UNKNOWN_OFFSET);
            return;
        }
        appendable.append("T");
        Timestamp.print_digits(appendable, timestamp._hour, 2);
        appendable.append(":");
        Timestamp.print_digits(appendable, timestamp._minute, 2);
        if (timestamp._precision == Precision.SECOND) {
            appendable.append(":");
            Timestamp.print_digits(appendable, timestamp._second, 2);
            if (timestamp._fraction != null) {
                Timestamp.print_fractional_digits(appendable, timestamp._fraction);
            }
        }
        if (timestamp._offset != UNKNOWN_OFFSET) {
            int n = timestamp._offset;
            if (n == 0) {
                appendable.append('Z');
            } else {
                if (n < 0) {
                    n = -n;
                    appendable.append('-');
                } else {
                    appendable.append('+');
                }
                int n2 = n / 60;
                Timestamp.print_digits(appendable, n2, 2);
                appendable.append(":");
                Timestamp.print_digits(appendable, n -= n2 * 60, 2);
            }
        } else {
            appendable.append("-00:00");
        }
    }

    private static void print_digits(Appendable appendable, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        while (n2 > 0) {
            int n3 = n / 10;
            cArray[--n2] = (char)(48 + (n - n3 * 10));
            n = n3;
        }
        while (n2 > 0) {
            cArray[--n2] = 48;
        }
        for (char c : cArray) {
            appendable.append(c);
        }
    }

    private static void print_fractional_digits(Appendable appendable, BigDecimal bigDecimal) throws IOException {
        String string = bigDecimal.toPlainString();
        if (string.charAt(0) == '0') {
            string = string.substring(1);
        }
        appendable.append(string);
    }

    public final Timestamp addMillis(long l) {
        if (l == 0L) {
            return this;
        }
        BigDecimal bigDecimal = this.make_localtime().getDecimalMillis();
        bigDecimal = bigDecimal.add(BigDecimal.valueOf(l));
        Timestamp timestamp = new Timestamp(bigDecimal, this._precision, this._offset);
        timestamp._fraction = this._fraction;
        if (this._offset != null && this._offset != 0) {
            timestamp.apply_offset(this._offset);
        }
        return timestamp;
    }

    public final Timestamp addSecond(int n) {
        long l = (long)n * 1000L;
        return this.addMillis(l);
    }

    public final Timestamp addMinute(int n) {
        long l = (long)n * 60L * 1000L;
        return this.addMillis(l);
    }

    public final Timestamp addHour(int n) {
        long l = (long)n * 60L * 60L * 1000L;
        return this.addMillis(l);
    }

    public final Timestamp addDay(int n) {
        long l = (long)n * 24L * 60L * 60L * 1000L;
        return this.addMillis(l);
    }

    public final Timestamp addMonth(int n) {
        if (n == 0) {
            return this;
        }
        Calendar calendar = this.calendarValue();
        calendar.add(2, n);
        return new Timestamp(calendar, this._precision, this._fraction, this._offset);
    }

    public final Timestamp addYear(int n) {
        if (n == 0) {
            return this;
        }
        Calendar calendar = this.calendarValue();
        calendar.add(1, n);
        return new Timestamp(calendar, this._precision, this._fraction, this._offset);
    }

    public int hashCode() {
        int n = 8191;
        int n2 = HASH_SIGNATURE;
        n2 = 8191 * n2 + (this._fraction != null ? this._fraction.hashCode() : 0);
        n2 ^= n2 << 19 ^ n2 >> 13;
        n2 = 8191 * n2 + this._year;
        n2 = 8191 * n2 + this._month;
        n2 = 8191 * n2 + this._day;
        n2 = 8191 * n2 + this._hour;
        n2 = 8191 * n2 + this._minute;
        n2 = 8191 * n2 + this._second;
        n2 ^= n2 << 19 ^ n2 >> 13;
        n2 = 8191 * n2 + this._precision.toString().hashCode();
        n2 ^= n2 << 19 ^ n2 >> 13;
        n2 = 8191 * n2 + (this._offset == null ? 0 : this._offset.hashCode());
        n2 ^= n2 << 19 ^ n2 >> 13;
        return n2;
    }

    @Override
    public int compareTo(Timestamp timestamp) {
        long l;
        long l2 = this.getMillis();
        if (l2 != (l = timestamp.getMillis())) {
            return l2 < l ? -1 : 1;
        }
        BigDecimal bigDecimal = this._fraction == null ? BigDecimal.ZERO : this._fraction;
        BigDecimal bigDecimal2 = timestamp._fraction == null ? BigDecimal.ZERO : timestamp._fraction;
        return bigDecimal.compareTo(bigDecimal2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Timestamp)) {
            return false;
        }
        return this.equals((Timestamp)object);
    }

    public boolean equals(Timestamp timestamp) {
        if (this == timestamp) {
            return true;
        }
        if (timestamp == null) {
            return false;
        }
        if (this._precision != timestamp._precision) {
            return false;
        }
        if (this._offset == null ? timestamp._offset != null : timestamp._offset == null) {
            return false;
        }
        if (this._year != timestamp._year) {
            return false;
        }
        if (this._month != timestamp._month) {
            return false;
        }
        if (this._day != timestamp._day) {
            return false;
        }
        if (this._hour != timestamp._hour) {
            return false;
        }
        if (this._minute != timestamp._minute) {
            return false;
        }
        if (this._second != timestamp._second) {
            return false;
        }
        if (this._offset != null && this._offset.intValue() != timestamp._offset.intValue()) {
            return false;
        }
        if (this._fraction != null && timestamp._fraction == null || this._fraction == null && timestamp._fraction != null) {
            return false;
        }
        if (this._fraction == null && timestamp._fraction == null) {
            return true;
        }
        return this._fraction.equals(timestamp._fraction);
    }

    private static short checkAndCastYear(int n) {
        if (n < 1 || n > 9999) {
            throw new IllegalArgumentException(String.format("Year %s must be between 1 and 9999 inclusive", n));
        }
        return (short)n;
    }

    private static byte checkAndCastMonth(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException(String.format("Month %s must be between 1 and 12 inclusive", n));
        }
        return (byte)n;
    }

    private static byte checkAndCastDay(int n, int n2, int n3) {
        int n4 = Timestamp.last_day_in_month(n2, n3);
        if (n < 1 || n > n4) {
            throw new IllegalArgumentException(String.format("Day %s for year %s and month %s must be between 1 and %s inclusive", n, n2, n3, n4));
        }
        return (byte)n;
    }

    private static byte checkAndCastHour(int n) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException(String.format("Hour %s must be between 0 and 23 inclusive", n));
        }
        return (byte)n;
    }

    private static byte checkAndCastMinute(int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException(String.format("Minute %s must be between between 0 and 59 inclusive", n));
        }
        return (byte)n;
    }

    private static byte checkAndCastSecond(int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException(String.format("Second %s must be between between 0 and 59 inclusive", n));
        }
        return (byte)n;
    }

    private static Precision checkFraction(Precision precision, BigDecimal bigDecimal) {
        if (precision == Precision.SECOND) {
            if (bigDecimal != null && (bigDecimal.signum() == -1 || BigDecimal.ONE.compareTo(bigDecimal) != 1)) {
                throw new IllegalArgumentException(String.format("Fractional seconds %s must be greater than or equal to 0 and less than 1", bigDecimal));
            }
        } else if (bigDecimal != null) {
            throw new IllegalArgumentException("Fraction must be null for non-second precision: " + bigDecimal);
        }
        return precision;
    }

    public static enum Precision {
        YEAR(1),
        MONTH(3),
        DAY(7),
        MINUTE(15),
        SECOND(31);

        private final int flags;

        private Precision(int n2) {
            this.flags = n2;
        }

        private boolean alwaysUnknownOffset() {
            return this.ordinal() <= DAY.ordinal();
        }

        public boolean includes(Precision precision) {
            switch (precision) {
                case SECOND: {
                    return (this.flags & 0x10) != 0;
                }
                case MINUTE: {
                    return (this.flags & 8) != 0;
                }
                case DAY: {
                    return (this.flags & 4) != 0;
                }
                case MONTH: {
                    return (this.flags & 2) != 0;
                }
                case YEAR: {
                    return (this.flags & 1) != 0;
                }
            }
            throw new IllegalStateException("unrecognized precision" + (Object)((Object)precision));
        }
    }
}

