/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.List;
import java.util.function.Supplier;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;
import org.springframework.util.xml.ListBasedXMLEventReader;
import org.springframework.util.xml.StaxEventHandler;
import org.springframework.util.xml.StaxEventXMLReader;
import org.springframework.util.xml.StaxResult;
import org.springframework.util.xml.StaxSource;
import org.springframework.util.xml.StaxStreamHandler;
import org.springframework.util.xml.StaxStreamXMLReader;
import org.springframework.util.xml.XMLEventStreamReader;
import org.springframework.util.xml.XMLEventStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLReader;

public abstract class StaxUtils {
    private static final XMLResolver NO_OP_XML_RESOLVER = (string, string2, string3, string4) -> StreamUtils.emptyInput();

    public static XMLInputFactory createDefensiveInputFactory() {
        return StaxUtils.createDefensiveInputFactory(XMLInputFactory::newInstance);
    }

    public static <T extends XMLInputFactory> T createDefensiveInputFactory(Supplier<T> supplier) {
        XMLInputFactory xMLInputFactory = (XMLInputFactory)supplier.get();
        xMLInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xMLInputFactory.setXMLResolver(NO_OP_XML_RESOLVER);
        return (T)xMLInputFactory;
    }

    public static Source createStaxSource(XMLStreamReader xMLStreamReader) {
        return new StAXSource(xMLStreamReader);
    }

    public static Source createStaxSource(XMLEventReader xMLEventReader) throws XMLStreamException {
        return new StAXSource(xMLEventReader);
    }

    public static Source createCustomStaxSource(XMLStreamReader xMLStreamReader) {
        return new StaxSource(xMLStreamReader);
    }

    public static Source createCustomStaxSource(XMLEventReader xMLEventReader) {
        return new StaxSource(xMLEventReader);
    }

    public static boolean isStaxSource(Source source2) {
        return source2 instanceof StAXSource || source2 instanceof StaxSource;
    }

    @Nullable
    public static XMLStreamReader getXMLStreamReader(Source source2) {
        if (source2 instanceof StAXSource) {
            return ((StAXSource)source2).getXMLStreamReader();
        }
        if (source2 instanceof StaxSource) {
            return ((StaxSource)source2).getXMLStreamReader();
        }
        throw new IllegalArgumentException("Source '" + source2 + "' is neither StaxSource nor StAXSource");
    }

    @Nullable
    public static XMLEventReader getXMLEventReader(Source source2) {
        if (source2 instanceof StAXSource) {
            return ((StAXSource)source2).getXMLEventReader();
        }
        if (source2 instanceof StaxSource) {
            return ((StaxSource)source2).getXMLEventReader();
        }
        throw new IllegalArgumentException("Source '" + source2 + "' is neither StaxSource nor StAXSource");
    }

    public static Result createStaxResult(XMLStreamWriter xMLStreamWriter) {
        return new StAXResult(xMLStreamWriter);
    }

    public static Result createStaxResult(XMLEventWriter xMLEventWriter) {
        return new StAXResult(xMLEventWriter);
    }

    public static Result createCustomStaxResult(XMLStreamWriter xMLStreamWriter) {
        return new StaxResult(xMLStreamWriter);
    }

    public static Result createCustomStaxResult(XMLEventWriter xMLEventWriter) {
        return new StaxResult(xMLEventWriter);
    }

    public static boolean isStaxResult(Result result) {
        return result instanceof StAXResult || result instanceof StaxResult;
    }

    @Nullable
    public static XMLStreamWriter getXMLStreamWriter(Result result) {
        if (result instanceof StAXResult) {
            return ((StAXResult)result).getXMLStreamWriter();
        }
        if (result instanceof StaxResult) {
            return ((StaxResult)result).getXMLStreamWriter();
        }
        throw new IllegalArgumentException("Result '" + result + "' is neither StaxResult nor StAXResult");
    }

    @Nullable
    public static XMLEventWriter getXMLEventWriter(Result result) {
        if (result instanceof StAXResult) {
            return ((StAXResult)result).getXMLEventWriter();
        }
        if (result instanceof StaxResult) {
            return ((StaxResult)result).getXMLEventWriter();
        }
        throw new IllegalArgumentException("Result '" + result + "' is neither StaxResult nor StAXResult");
    }

    public static XMLEventReader createXMLEventReader(List<XMLEvent> list) {
        return new ListBasedXMLEventReader(list);
    }

    public static ContentHandler createContentHandler(XMLStreamWriter xMLStreamWriter) {
        return new StaxStreamHandler(xMLStreamWriter);
    }

    public static ContentHandler createContentHandler(XMLEventWriter xMLEventWriter) {
        return new StaxEventHandler(xMLEventWriter);
    }

    public static XMLReader createXMLReader(XMLStreamReader xMLStreamReader) {
        return new StaxStreamXMLReader(xMLStreamReader);
    }

    public static XMLReader createXMLReader(XMLEventReader xMLEventReader) {
        return new StaxEventXMLReader(xMLEventReader);
    }

    public static XMLStreamReader createEventStreamReader(XMLEventReader xMLEventReader) throws XMLStreamException {
        return new XMLEventStreamReader(xMLEventReader);
    }

    public static XMLStreamWriter createEventStreamWriter(XMLEventWriter xMLEventWriter) {
        return new XMLEventStreamWriter(xMLEventWriter, XMLEventFactory.newFactory());
    }

    public static XMLStreamWriter createEventStreamWriter(XMLEventWriter xMLEventWriter, XMLEventFactory xMLEventFactory) {
        return new XMLEventStreamWriter(xMLEventWriter, xMLEventFactory);
    }
}

