/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.AbstractStaxXMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;

class StaxStreamXMLReader
extends AbstractStaxXMLReader {
    private static final String DEFAULT_XML_VERSION = "1.0";
    private final XMLStreamReader reader;
    private String xmlVersion = "1.0";
    @Nullable
    private String encoding;

    StaxStreamXMLReader(XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getEventType();
        if (n != 7 && n != 1) {
            throw new IllegalStateException("XMLEventReader not at start of document or element");
        }
        this.reader = xMLStreamReader;
    }

    @Override
    protected void parseInternal() throws SAXException, XMLStreamException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = this.reader.getEventType();
        while (true) {
            if (n2 != 7 && n2 != 8 && !bl) {
                this.handleStartDocument();
                bl = true;
            }
            switch (n2) {
                case 1: {
                    ++n;
                    this.handleStartElement();
                    break;
                }
                case 2: {
                    if (--n < 0) break;
                    this.handleEndElement();
                    break;
                }
                case 3: {
                    this.handleProcessingInstruction();
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    this.handleCharacters();
                    break;
                }
                case 7: {
                    this.handleStartDocument();
                    bl = true;
                    break;
                }
                case 8: {
                    this.handleEndDocument();
                    bl2 = true;
                    break;
                }
                case 5: {
                    this.handleComment();
                    break;
                }
                case 11: {
                    this.handleDtd();
                    break;
                }
                case 9: {
                    this.handleEntityReference();
                }
            }
            if (!this.reader.hasNext() || n < 0) break;
            n2 = this.reader.next();
        }
        if (!bl2) {
            this.handleEndDocument();
        }
    }

    private void handleStartDocument() throws SAXException {
        Object object;
        if (7 == this.reader.getEventType()) {
            object = this.reader.getVersion();
            if (StringUtils.hasLength((String)object)) {
                this.xmlVersion = object;
            }
            this.encoding = this.reader.getCharacterEncodingScheme();
        }
        if ((object = this.getContentHandler()) != null) {
            final Location location = this.reader.getLocation();
            object.setDocumentLocator(new Locator2(){

                @Override
                public int getColumnNumber() {
                    return location != null ? location.getColumnNumber() : -1;
                }

                @Override
                public int getLineNumber() {
                    return location != null ? location.getLineNumber() : -1;
                }

                @Override
                @Nullable
                public String getPublicId() {
                    return location != null ? location.getPublicId() : null;
                }

                @Override
                @Nullable
                public String getSystemId() {
                    return location != null ? location.getSystemId() : null;
                }

                @Override
                public String getXMLVersion() {
                    return StaxStreamXMLReader.this.xmlVersion;
                }

                @Override
                @Nullable
                public String getEncoding() {
                    return StaxStreamXMLReader.this.encoding;
                }
            });
            object.startDocument();
            if (this.reader.standaloneSet()) {
                this.setStandalone(this.reader.isStandalone());
            }
        }
    }

    private void handleStartElement() throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = this.reader.getName();
            if (this.hasNamespacesFeature()) {
                int n;
                for (n = 0; n < this.reader.getNamespaceCount(); ++n) {
                    this.startPrefixMapping(this.reader.getNamespacePrefix(n), this.reader.getNamespaceURI(n));
                }
                for (n = 0; n < this.reader.getAttributeCount(); ++n) {
                    String string = this.reader.getAttributePrefix(n);
                    String string2 = this.reader.getAttributeNamespace(n);
                    if (!StringUtils.hasLength(string2)) continue;
                    this.startPrefixMapping(string, string2);
                }
                this.getContentHandler().startElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName), this.getAttributes());
            } else {
                this.getContentHandler().startElement("", "", this.toQualifiedName(qName), this.getAttributes());
            }
        }
    }

    private void handleEndElement() throws SAXException {
        if (this.getContentHandler() != null) {
            QName qName = this.reader.getName();
            if (this.hasNamespacesFeature()) {
                this.getContentHandler().endElement(qName.getNamespaceURI(), qName.getLocalPart(), this.toQualifiedName(qName));
                for (int i = 0; i < this.reader.getNamespaceCount(); ++i) {
                    String string = this.reader.getNamespacePrefix(i);
                    if (string == null) {
                        string = "";
                    }
                    this.endPrefixMapping(string);
                }
            } else {
                this.getContentHandler().endElement("", "", this.toQualifiedName(qName));
            }
        }
    }

    private void handleCharacters() throws SAXException {
        if (12 == this.reader.getEventType() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().startCDATA();
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().characters(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
        }
        if (12 == this.reader.getEventType() && this.getLexicalHandler() != null) {
            this.getLexicalHandler().endCDATA();
        }
    }

    private void handleComment() throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().comment(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
        }
    }

    private void handleDtd() throws SAXException {
        if (this.getLexicalHandler() != null) {
            Location location = this.reader.getLocation();
            this.getLexicalHandler().startDTD(null, location.getPublicId(), location.getSystemId());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endDTD();
        }
    }

    private void handleEntityReference() throws SAXException {
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().startEntity(this.reader.getLocalName());
        }
        if (this.getLexicalHandler() != null) {
            this.getLexicalHandler().endEntity(this.reader.getLocalName());
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleProcessingInstruction() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(this.reader.getPITarget(), this.reader.getPIData());
        }
    }

    private Attributes getAttributes() {
        String string;
        String string2;
        int n;
        AttributesImpl attributesImpl = new AttributesImpl();
        for (n = 0; n < this.reader.getAttributeCount(); ++n) {
            string2 = this.reader.getAttributeNamespace(n);
            if (string2 == null || !this.hasNamespacesFeature()) {
                string2 = "";
            }
            if ((string = this.reader.getAttributeType(n)) == null) {
                string = "CDATA";
            }
            attributesImpl.addAttribute(string2, this.reader.getAttributeLocalName(n), this.toQualifiedName(this.reader.getAttributeName(n)), string, this.reader.getAttributeValue(n));
        }
        if (this.hasNamespacePrefixesFeature()) {
            for (n = 0; n < this.reader.getNamespaceCount(); ++n) {
                string2 = this.reader.getNamespacePrefix(n);
                string = this.reader.getNamespaceURI(n);
                String string3 = StringUtils.hasLength(string2) ? "xmlns:" + string2 : "xmlns";
                attributesImpl.addAttribute("", "", string3, "CDATA", string);
            }
        }
        return attributesImpl;
    }
}

