/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.springframework.lang.Nullable;
import org.springframework.util.xml.AbstractStaxHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

class StaxEventHandler
extends AbstractStaxHandler {
    private final XMLEventFactory eventFactory;
    private final XMLEventWriter eventWriter;

    public StaxEventHandler(XMLEventWriter xMLEventWriter) {
        this.eventFactory = XMLEventFactory.newInstance();
        this.eventWriter = xMLEventWriter;
    }

    public StaxEventHandler(XMLEventWriter xMLEventWriter, XMLEventFactory xMLEventFactory) {
        this.eventFactory = xMLEventFactory;
        this.eventWriter = xMLEventWriter;
    }

    @Override
    public void setDocumentLocator(@Nullable Locator locator) {
        if (locator != null) {
            this.eventFactory.setLocation(new LocatorLocationAdapter(locator));
        }
    }

    @Override
    protected void startDocumentInternal() throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createStartDocument());
    }

    @Override
    protected void endDocumentInternal() throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createEndDocument());
    }

    @Override
    protected void startElementInternal(QName qName, Attributes attributes, Map<String, String> map) throws XMLStreamException {
        List<Attribute> list = this.getAttributes(attributes);
        List<Namespace> list2 = this.getNamespaces(map);
        this.eventWriter.add(this.eventFactory.createStartElement(qName, list.iterator(), list2.iterator()));
    }

    private List<Namespace> getNamespaces(Map<String, String> map) {
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>(map.size());
        map.forEach((string, string2) -> arrayList.add(this.eventFactory.createNamespace((String)string, (String)string2)));
        return arrayList;
    }

    private List<Attribute> getAttributes(Attributes attributes) {
        int n = attributes.getLength();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(n);
        for (int i = 0; i < n; ++i) {
            QName qName = this.toQName(attributes.getURI(i), attributes.getQName(i));
            if (this.isNamespaceDeclaration(qName)) continue;
            arrayList.add(this.eventFactory.createAttribute(qName, attributes.getValue(i)));
        }
        return arrayList;
    }

    @Override
    protected void endElementInternal(QName qName, Map<String, String> map) throws XMLStreamException {
        List<Namespace> list = this.getNamespaces(map);
        this.eventWriter.add(this.eventFactory.createEndElement(qName, list.iterator()));
    }

    @Override
    protected void charactersInternal(String string) throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createCharacters(string));
    }

    @Override
    protected void cDataInternal(String string) throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createCData(string));
    }

    @Override
    protected void ignorableWhitespaceInternal(String string) throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createIgnorableSpace(string));
    }

    @Override
    protected void processingInstructionInternal(String string, String string2) throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createProcessingInstruction(string, string2));
    }

    @Override
    protected void dtdInternal(String string) throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createDTD(string));
    }

    @Override
    protected void commentInternal(String string) throws XMLStreamException {
        this.eventWriter.add(this.eventFactory.createComment(string));
    }

    @Override
    protected void skippedEntityInternal(String string) {
    }

    private static final class LocatorLocationAdapter
    implements Location {
        private final Locator locator;

        public LocatorLocationAdapter(Locator locator) {
            this.locator = locator;
        }

        @Override
        public int getLineNumber() {
            return this.locator.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this.locator.getColumnNumber();
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return this.locator.getPublicId();
        }

        @Override
        public String getSystemId() {
            return this.locator.getSystemId();
        }
    }
}

