/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.xml.DomContentHandler;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public abstract class DomUtils {
    public static List<Element> getChildElementsByTagName(Element element, String ... stringArray) {
        Assert.notNull((Object)element, "Element must not be null");
        Assert.notNull((Object)stringArray, "Element names collection must not be null");
        List<String> list = Arrays.asList(stringArray);
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameMatch(node, list)) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    public static List<Element> getChildElementsByTagName(Element element, String string) {
        return DomUtils.getChildElementsByTagName(element, new String[]{string});
    }

    @Nullable
    public static Element getChildElementByTagName(Element element, String string) {
        Assert.notNull((Object)element, "Element must not be null");
        Assert.notNull((Object)string, "Element name must not be null");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameMatch(node, string)) continue;
            return (Element)node;
        }
        return null;
    }

    @Nullable
    public static String getChildElementValueByTagName(Element element, String string) {
        Element element2 = DomUtils.getChildElementByTagName(element, string);
        return element2 != null ? DomUtils.getTextValue(element2) : null;
    }

    public static List<Element> getChildElements(Element element) {
        Assert.notNull((Object)element, "Element must not be null");
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    public static String getTextValue(Element element) {
        Assert.notNull((Object)element, "Element must not be null");
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if ((!(node instanceof CharacterData) || node instanceof Comment) && !(node instanceof EntityReference)) continue;
            stringBuilder.append(node.getNodeValue());
        }
        return stringBuilder.toString();
    }

    public static boolean nodeNameEquals(Node node, String string) {
        Assert.notNull((Object)node, "Node must not be null");
        Assert.notNull((Object)string, "Desired name must not be null");
        return DomUtils.nodeNameMatch(node, string);
    }

    public static ContentHandler createContentHandler(Node node) {
        return new DomContentHandler(node);
    }

    private static boolean nodeNameMatch(Node node, String string) {
        return string.equals(node.getNodeName()) || string.equals(node.getLocalName());
    }

    private static boolean nodeNameMatch(Node node, Collection<?> collection) {
        return collection.contains(node.getNodeName()) || collection.contains(node.getLocalName());
    }
}

