/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.unit;

import org.springframework.util.unit.DataSize;

public enum DataUnit {
    BYTES("B", DataSize.ofBytes(1L)),
    KILOBYTES("KB", DataSize.ofKilobytes(1L)),
    MEGABYTES("MB", DataSize.ofMegabytes(1L)),
    GIGABYTES("GB", DataSize.ofGigabytes(1L)),
    TERABYTES("TB", DataSize.ofTerabytes(1L));

    private final String suffix;
    private final DataSize size;

    private DataUnit(String string2, DataSize dataSize) {
        this.suffix = string2;
        this.size = dataSize;
    }

    DataSize size() {
        return this.size;
    }

    public static DataUnit fromSuffix(String string) {
        for (DataUnit dataUnit : DataUnit.values()) {
            if (!dataUnit.suffix.equals(string)) continue;
            return dataUnit;
        }
        throw new IllegalArgumentException("Unknown data unit suffix '" + string + "'");
    }
}

