/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.LinkedList;
import java.util.Queue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

public class ListenableFutureCallbackRegistry<T> {
    private final Queue<SuccessCallback<? super T>> successCallbacks = new LinkedList<SuccessCallback<? super T>>();
    private final Queue<FailureCallback> failureCallbacks = new LinkedList<FailureCallback>();
    private State state = State.NEW;
    @Nullable
    private Object result;
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(ListenableFutureCallback<? super T> listenableFutureCallback) {
        Assert.notNull(listenableFutureCallback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.successCallbacks.add(listenableFutureCallback);
                    this.failureCallbacks.add(listenableFutureCallback);
                    break;
                }
                case SUCCESS: {
                    this.notifySuccess(listenableFutureCallback);
                    break;
                }
                case FAILURE: {
                    this.notifyFailure(listenableFutureCallback);
                }
            }
        }
    }

    private void notifySuccess(SuccessCallback<? super T> successCallback) {
        try {
            successCallback.onSuccess(this.result);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void notifyFailure(FailureCallback failureCallback) {
        Assert.state(this.result instanceof Throwable, "No Throwable result for failure state");
        try {
            failureCallback.onFailure((Throwable)this.result);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuccessCallback(SuccessCallback<? super T> successCallback) {
        Assert.notNull(successCallback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.successCallbacks.add(successCallback);
                    break;
                }
                case SUCCESS: {
                    this.notifySuccess(successCallback);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFailureCallback(FailureCallback failureCallback) {
        Assert.notNull((Object)failureCallback, "'callback' must not be null");
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case NEW: {
                    this.failureCallbacks.add(failureCallback);
                    break;
                }
                case FAILURE: {
                    this.notifyFailure(failureCallback);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void success(@Nullable T t2) {
        Object object = this.mutex;
        synchronized (object) {
            SuccessCallback<? super T> successCallback;
            this.state = State.SUCCESS;
            this.result = t2;
            while ((successCallback = this.successCallbacks.poll()) != null) {
                this.notifySuccess(successCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable throwable) {
        Object object = this.mutex;
        synchronized (object) {
            FailureCallback failureCallback;
            this.state = State.FAILURE;
            this.result = throwable;
            while ((failureCallback = this.failureCallbacks.poll()) != null) {
                this.notifyFailure(failureCallback);
            }
        }
    }

    private static enum State {
        NEW,
        SUCCESS,
        FAILURE;

    }
}

