/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class FutureAdapter<T, S>
implements Future<T> {
    private final Future<S> adaptee;
    @Nullable
    private Object result;
    private State state = State.NEW;
    private final Object mutex = new Object();

    protected FutureAdapter(Future<S> future) {
        Assert.notNull(future, "Delegate must not be null");
        this.adaptee = future;
    }

    protected Future<S> getAdaptee() {
        return this.adaptee;
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.adaptee.cancel(bl);
    }

    @Override
    public boolean isCancelled() {
        return this.adaptee.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.adaptee.isDone();
    }

    @Override
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        return this.adaptInternal(this.adaptee.get());
    }

    @Override
    @Nullable
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.adaptInternal(this.adaptee.get(l, timeUnit));
    }

    @Nullable
    final T adaptInternal(S s2) throws ExecutionException {
        Object object = this.mutex;
        synchronized (object) {
            switch (this.state) {
                case SUCCESS: {
                    return (T)this.result;
                }
                case FAILURE: {
                    Assert.state(this.result instanceof ExecutionException, "Failure without exception");
                    throw (ExecutionException)this.result;
                }
                case NEW: {
                    try {
                        T t2 = this.adapt(s2);
                        this.result = t2;
                        this.state = State.SUCCESS;
                        return t2;
                    }
                    catch (ExecutionException executionException) {
                        this.result = executionException;
                        this.state = State.FAILURE;
                        throw executionException;
                    }
                    catch (Throwable throwable) {
                        ExecutionException executionException = new ExecutionException(throwable);
                        this.result = executionException;
                        this.state = State.FAILURE;
                        throw executionException;
                    }
                }
            }
            throw new IllegalStateException();
        }
    }

    @Nullable
    protected abstract T adapt(S var1) throws ExecutionException;

    private static enum State {
        NEW,
        SUCCESS,
        FAILURE;

    }
}

