/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import org.springframework.lang.Nullable;
import org.springframework.util.PropertyPlaceholderHelper;

public abstract class SystemPropertyUtils {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    public static final String VALUE_SEPARATOR = ":";
    private static final PropertyPlaceholderHelper strictHelper = new PropertyPlaceholderHelper("${", "}", ":", false);
    private static final PropertyPlaceholderHelper nonStrictHelper = new PropertyPlaceholderHelper("${", "}", ":", true);

    public static String resolvePlaceholders(String string) {
        return SystemPropertyUtils.resolvePlaceholders(string, false);
    }

    public static String resolvePlaceholders(String string, boolean bl) {
        if (string.isEmpty()) {
            return string;
        }
        PropertyPlaceholderHelper propertyPlaceholderHelper = bl ? nonStrictHelper : strictHelper;
        return propertyPlaceholderHelper.replacePlaceholders(string, new SystemPropertyPlaceholderResolver(string));
    }

    private static class SystemPropertyPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String text;

        public SystemPropertyPlaceholderResolver(String string) {
            this.text = string;
        }

        @Override
        @Nullable
        public String resolvePlaceholder(String string) {
            try {
                String string2 = System.getProperty(string);
                if (string2 == null) {
                    string2 = System.getenv(string);
                }
                return string2;
            }
            catch (Throwable throwable) {
                System.err.println("Could not resolve placeholder '" + string + "' in [" + this.text + "] as system property: " + throwable);
                return null;
            }
        }
    }
}

