/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class StreamUtils {
    public static final int BUFFER_SIZE = 4096;
    private static final byte[] EMPTY_CONTENT = new byte[0];

    public static byte[] copyToByteArray(@Nullable InputStream inputStream2) throws IOException {
        if (inputStream2 == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        StreamUtils.copy(inputStream2, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String copyToString(@Nullable InputStream inputStream2, Charset charset) throws IOException {
        int n;
        if (inputStream2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(4096);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, charset);
        char[] cArray = new char[4096];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static String copyToString(ByteArrayOutputStream byteArrayOutputStream, Charset charset) {
        Assert.notNull((Object)byteArrayOutputStream, "No ByteArrayOutputStream specified");
        Assert.notNull((Object)charset, "No Charset specified");
        try {
            return byteArrayOutputStream.toString(charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Invalid charset name: " + charset, unsupportedEncodingException);
        }
    }

    public static void copy(byte[] byArray, OutputStream outputStream2) throws IOException {
        Assert.notNull((Object)byArray, "No input byte array specified");
        Assert.notNull((Object)outputStream2, "No OutputStream specified");
        outputStream2.write(byArray);
        outputStream2.flush();
    }

    public static void copy(String string, Charset charset, OutputStream outputStream2) throws IOException {
        Assert.notNull((Object)string, "No input String specified");
        Assert.notNull((Object)charset, "No Charset specified");
        Assert.notNull((Object)outputStream2, "No OutputStream specified");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream2, charset);
        outputStreamWriter.write(string);
        ((Writer)outputStreamWriter).flush();
    }

    public static int copy(InputStream inputStream2, OutputStream outputStream2) throws IOException {
        int n;
        Assert.notNull((Object)inputStream2, "No InputStream specified");
        Assert.notNull((Object)outputStream2, "No OutputStream specified");
        int n2 = 0;
        byte[] byArray = new byte[4096];
        while ((n = inputStream2.read(byArray)) != -1) {
            outputStream2.write(byArray, 0, n);
            n2 += n;
        }
        outputStream2.flush();
        return n2;
    }

    public static long copyRange(InputStream inputStream2, OutputStream outputStream2, long l, long l2) throws IOException {
        int n;
        Assert.notNull((Object)inputStream2, "No InputStream specified");
        Assert.notNull((Object)outputStream2, "No OutputStream specified");
        long l3 = inputStream2.skip(l);
        if (l3 < l) {
            throw new IOException("Skipped only " + l3 + " bytes out of " + l + " required");
        }
        long l4 = l2 - l + 1L;
        byte[] byArray = new byte[(int)Math.min(4096L, l4)];
        while (l4 > 0L && (n = inputStream2.read(byArray)) != -1) {
            if ((long)n <= l4) {
                outputStream2.write(byArray, 0, n);
                l4 -= (long)n;
                continue;
            }
            outputStream2.write(byArray, 0, (int)l4);
            l4 = 0L;
        }
        return l2 - l + 1L - l4;
    }

    public static int drain(InputStream inputStream2) throws IOException {
        Assert.notNull((Object)inputStream2, "No InputStream specified");
        byte[] byArray = new byte[4096];
        int n = -1;
        int n2 = 0;
        while ((n = inputStream2.read(byArray)) != -1) {
            n2 += n;
        }
        return n2;
    }

    public static InputStream emptyInput() {
        return new ByteArrayInputStream(EMPTY_CONTENT);
    }

    public static InputStream nonClosing(InputStream inputStream2) {
        Assert.notNull((Object)inputStream2, "No InputStream specified");
        return new NonClosingInputStream(inputStream2);
    }

    public static OutputStream nonClosing(OutputStream outputStream2) {
        Assert.notNull((Object)outputStream2, "No OutputStream specified");
        return new NonClosingOutputStream(outputStream2);
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        public NonClosingOutputStream(OutputStream outputStream2) {
            super(outputStream2);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream inputStream2) {
            super(inputStream2);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

