/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class ReflectionUtils {
    public static final MethodFilter USER_DECLARED_METHODS = method -> !method.isBridge() && !method.isSynthetic();
    public static final FieldFilter COPYABLE_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    private static final String CGLIB_RENAMED_METHOD_PREFIX = "CGLIB$";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map<Class<?>, Method[]> declaredMethodsCache = new ConcurrentReferenceHashMap(256);
    private static final Map<Class<?>, Field[]> declaredFieldsCache = new ConcurrentReferenceHashMap(256);

    public static void handleReflectionException(Exception exception) {
        if (exception instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + exception.getMessage());
        }
        if (exception instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + exception.getMessage());
        }
        if (exception instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new UndeclaredThrowableException(exception);
    }

    public static void handleInvocationTargetException(InvocationTargetException invocationTargetException) {
        ReflectionUtils.rethrowRuntimeException(invocationTargetException.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static void rethrowException(Throwable throwable) throws Exception {
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static <T> Constructor<T> accessibleConstructor(Class<T> clazz, Class<?> ... classArray) throws NoSuchMethodException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(classArray);
        ReflectionUtils.makeAccessible(constructor);
        return constructor;
    }

    public static void makeAccessible(Constructor<?> constructor) {
        if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
            constructor.setAccessible(true);
        }
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String string) {
        return ReflectionUtils.findMethod(clazz, string, EMPTY_CLASS_ARRAY);
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)string, "Method name must not be null");
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray;
            for (Method method : methodArray = clazz2.isInterface() ? clazz2.getMethods() : ReflectionUtils.getDeclaredMethods(clazz2, false)) {
                if (!string.equals(method.getName()) || classArray != null && !ReflectionUtils.hasSameParams(method, classArray)) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean hasSameParams(Method method, Class<?>[] classArray) {
        return classArray.length == method.getParameterCount() && Arrays.equals(classArray, method.getParameterTypes());
    }

    @Nullable
    public static Object invokeMethod(Method method, @Nullable Object object) {
        return ReflectionUtils.invokeMethod(method, object, EMPTY_OBJECT_ARRAY);
    }

    @Nullable
    public static Object invokeMethod(Method method, @Nullable Object object, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            ReflectionUtils.handleReflectionException(exception);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static boolean declaresException(Method method, Class<?> clazz) {
        Class<?>[] classArray;
        Assert.notNull((Object)method, "Method must not be null");
        for (Class<?> clazz2 : classArray = method.getExceptionTypes()) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static void doWithLocalMethods(Class<?> clazz, MethodCallback methodCallback) {
        Method[] methodArray;
        for (Method method : methodArray = ReflectionUtils.getDeclaredMethods(clazz, false)) {
            try {
                methodCallback.doWith(method);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + illegalAccessException);
            }
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback methodCallback) {
        ReflectionUtils.doWithMethods(clazz, methodCallback, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback methodCallback, @Nullable MethodFilter methodFilter) {
        Method[] methodArray = ReflectionUtils.getDeclaredMethods(clazz, false);
        for (Method genericDeclaration : methodArray) {
            if (methodFilter != null && !methodFilter.matches(genericDeclaration)) continue;
            try {
                methodCallback.doWith(genericDeclaration);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Not allowed to access method '" + genericDeclaration.getName() + "': " + illegalAccessException);
            }
        }
        if (clazz.getSuperclass() != null && (methodFilter != USER_DECLARED_METHODS || clazz.getSuperclass() != Object.class)) {
            ReflectionUtils.doWithMethods(clazz.getSuperclass(), methodCallback, methodFilter);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionUtils.doWithMethods(genericDeclaration, methodCallback, methodFilter);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> clazz) {
        ArrayList arrayList = new ArrayList(20);
        ReflectionUtils.doWithMethods(clazz, arrayList::add);
        return arrayList.toArray(EMPTY_METHOD_ARRAY);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> clazz) {
        return ReflectionUtils.getUniqueDeclaredMethods(clazz, null);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> clazz, @Nullable MethodFilter methodFilter) {
        ArrayList arrayList = new ArrayList(20);
        ReflectionUtils.doWithMethods(clazz, method -> {
            boolean bl = false;
            Method method2 = null;
            for (Method method3 : arrayList) {
                if (!method.getName().equals(method3.getName()) || method.getParameterCount() != method3.getParameterCount() || !Arrays.equals(method.getParameterTypes(), method3.getParameterTypes())) continue;
                if (method3.getReturnType() != method.getReturnType() && method3.getReturnType().isAssignableFrom(method.getReturnType())) {
                    method2 = method3;
                    break;
                }
                bl = true;
                break;
            }
            if (method2 != null) {
                arrayList.remove(method2);
            }
            if (!bl && !ReflectionUtils.isCglibRenamedMethod(method)) {
                arrayList.add(method);
            }
        }, methodFilter);
        return arrayList.toArray(EMPTY_METHOD_ARRAY);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectionUtils.getDeclaredMethods(clazz, true);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz, boolean bl) {
        Assert.notNull(clazz, "Class must not be null");
        Method[] methodArray = declaredMethodsCache.get(clazz);
        if (methodArray == null) {
            try {
                Method[] methodArray2 = clazz.getDeclaredMethods();
                List<Method> list = ReflectionUtils.findConcreteMethodsOnInterfaces(clazz);
                if (list != null) {
                    methodArray = new Method[methodArray2.length + list.size()];
                    System.arraycopy(methodArray2, 0, methodArray, 0, methodArray2.length);
                    int n = methodArray2.length;
                    Iterator<Method> iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        Method method;
                        methodArray[n] = method = iterator2.next();
                        ++n;
                    }
                } else {
                    methodArray = methodArray2;
                }
                declaredMethodsCache.put(clazz, methodArray.length == 0 ? EMPTY_METHOD_ARRAY : methodArray);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", throwable);
            }
        }
        return methodArray.length == 0 || !bl ? methodArray : (Method[])methodArray.clone();
    }

    @Nullable
    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> arrayList = null;
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            for (Method method : clazz2.getMethods()) {
                if (Modifier.isAbstract(method.getModifiers())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Method>();
                }
                arrayList.add(method);
            }
        }
        return arrayList;
    }

    public static boolean isEqualsMethod(@Nullable Method method) {
        if (method == null) {
            return false;
        }
        if (method.getParameterCount() != 1) {
            return false;
        }
        if (!method.getName().equals("equals")) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(@Nullable Method method) {
        return method != null && method.getParameterCount() == 0 && method.getName().equals("hashCode");
    }

    public static boolean isToStringMethod(@Nullable Method method) {
        return method != null && method.getParameterCount() == 0 && method.getName().equals("toString");
    }

    public static boolean isObjectMethod(@Nullable Method method) {
        return method != null && (method.getDeclaringClass() == Object.class || ReflectionUtils.isEqualsMethod(method) || ReflectionUtils.isHashCodeMethod(method) || ReflectionUtils.isToStringMethod(method));
    }

    public static boolean isCglibRenamedMethod(Method method) {
        String string = method.getName();
        if (string.startsWith(CGLIB_RENAMED_METHOD_PREFIX)) {
            int n;
            for (n = string.length() - 1; n >= 0 && Character.isDigit(string.charAt(n)); --n) {
            }
            return n > CGLIB_RENAMED_METHOD_PREFIX.length() && n < string.length() - 1 && string.charAt(n) == '$';
        }
        return false;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    @Nullable
    public static Field findField(Class<?> clazz, String string) {
        return ReflectionUtils.findField(clazz, string, null);
    }

    @Nullable
    public static Field findField(Class<?> clazz, @Nullable String string, @Nullable Class<?> clazz2) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.isTrue(string != null || clazz2 != null, "Either name or type of the field must be specified");
        for (Class<?> clazz3 = clazz; Object.class != clazz3 && clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            Field[] fieldArray;
            for (Field field : fieldArray = ReflectionUtils.getDeclaredFields(clazz3)) {
                if (string != null && !string.equals(field.getName()) || clazz2 != null && !clazz2.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static void setField(Field field, @Nullable Object object, @Nullable Object object2) {
        try {
            field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            ReflectionUtils.handleReflectionException(illegalAccessException);
        }
    }

    @Nullable
    public static Object getField(Field field, @Nullable Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            ReflectionUtils.handleReflectionException(illegalAccessException);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void doWithLocalFields(Class<?> clazz, FieldCallback fieldCallback) {
        for (Field field : ReflectionUtils.getDeclaredFields(clazz)) {
            try {
                fieldCallback.doWith(field);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + illegalAccessException);
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fieldCallback) {
        ReflectionUtils.doWithFields(clazz, fieldCallback, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fieldCallback, @Nullable FieldFilter fieldFilter) {
        Class<?> clazz2 = clazz;
        do {
            Field[] fieldArray;
            for (Field field : fieldArray = ReflectionUtils.getDeclaredFields(clazz2)) {
                if (fieldFilter != null && !fieldFilter.matches(field)) continue;
                try {
                    fieldCallback.doWith(field);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + illegalAccessException);
                }
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && clazz2 != Object.class);
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        Field[] fieldArray = declaredFieldsCache.get(clazz);
        if (fieldArray == null) {
            try {
                fieldArray = clazz.getDeclaredFields();
                declaredFieldsCache.put(clazz, fieldArray.length == 0 ? EMPTY_FIELD_ARRAY : fieldArray);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", throwable);
            }
        }
        return fieldArray;
    }

    public static void shallowCopyFieldState(Object object, Object object2) {
        Assert.notNull(object, "Source for field copy cannot be null");
        Assert.notNull(object2, "Destination for field copy cannot be null");
        if (!object.getClass().isAssignableFrom(object2.getClass())) {
            throw new IllegalArgumentException("Destination class [" + object2.getClass().getName() + "] must be same or subclass as source class [" + object.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(object.getClass(), field -> {
            ReflectionUtils.makeAccessible(field);
            Object object3 = field.get(object);
            field.set(object2, object3);
        }, COPYABLE_FIELDS);
    }

    public static boolean isPublicStaticFinal(Field field) {
        int n = field.getModifiers();
        return Modifier.isPublic(n) && Modifier.isStatic(n) && Modifier.isFinal(n);
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void clearCache() {
        declaredMethodsCache.clear();
        declaredFieldsCache.clear();
    }

    @FunctionalInterface
    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

