/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ObjectUtils;

public class MimeType
implements Serializable,
Comparable<MimeType> {
    private static final long serialVersionUID = 4085923477777865903L;
    protected static final String WILDCARD_TYPE = "*";
    private static final String PARAM_CHARSET = "charset";
    private static final BitSet TOKEN;
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    @Nullable
    private transient Charset resolvedCharset;
    @Nullable
    private volatile String toStringValue;

    public MimeType(String string) {
        this(string, WILDCARD_TYPE);
    }

    public MimeType(String string, String string2) {
        this(string, string2, Collections.emptyMap());
    }

    public MimeType(String string, String string2, Charset charset) {
        this(string, string2, Collections.singletonMap(PARAM_CHARSET, charset.name()));
        this.resolvedCharset = charset;
    }

    public MimeType(MimeType mimeType, Charset charset) {
        this(mimeType.getType(), mimeType.getSubtype(), MimeType.addCharsetParameter(charset, mimeType.getParameters()));
        this.resolvedCharset = charset;
    }

    public MimeType(MimeType mimeType, @Nullable Map<String, String> map) {
        this(mimeType.getType(), mimeType.getSubtype(), map);
    }

    public MimeType(String string3, String string4, @Nullable Map<String, String> map) {
        Assert.hasLength(string3, "'type' must not be empty");
        Assert.hasLength(string4, "'subtype' must not be empty");
        this.checkToken(string3);
        this.checkToken(string4);
        this.type = string3.toLowerCase(Locale.ENGLISH);
        this.subtype = string4.toLowerCase(Locale.ENGLISH);
        if (!CollectionUtils.isEmpty(map)) {
            LinkedCaseInsensitiveMap linkedCaseInsensitiveMap = new LinkedCaseInsensitiveMap(map.size(), Locale.ENGLISH);
            map.forEach((string, string2) -> {
                this.checkParameters((String)string, (String)string2);
                linkedCaseInsensitiveMap.put(string, string2);
            });
            this.parameters = Collections.unmodifiableMap(linkedCaseInsensitiveMap);
        } else {
            this.parameters = Collections.emptyMap();
        }
    }

    private void checkToken(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (TOKEN.get(c)) continue;
            throw new IllegalArgumentException("Invalid token character '" + c + "' in token \"" + string + "\"");
        }
    }

    protected void checkParameters(String string, String string2) {
        Assert.hasLength(string, "'parameter' must not be empty");
        Assert.hasLength(string2, "'value' must not be empty");
        this.checkToken(string);
        if (PARAM_CHARSET.equals(string)) {
            if (this.resolvedCharset == null) {
                this.resolvedCharset = Charset.forName(this.unquote(string2));
            }
        } else if (!this.isQuotedString(string2)) {
            this.checkToken(string2);
        }
    }

    private boolean isQuotedString(String string) {
        if (string.length() < 2) {
            return false;
        }
        return string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'");
    }

    protected String unquote(String string) {
        return this.isQuotedString(string) ? string.substring(1, string.length() - 1) : string;
    }

    public boolean isWildcardType() {
        return WILDCARD_TYPE.equals(this.getType());
    }

    public boolean isWildcardSubtype() {
        return WILDCARD_TYPE.equals(this.getSubtype()) || this.getSubtype().startsWith("*+");
    }

    public boolean isConcrete() {
        return !this.isWildcardType() && !this.isWildcardSubtype();
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    @Nullable
    public Charset getCharset() {
        return this.resolvedCharset;
    }

    @Nullable
    public String getParameter(String string) {
        return this.parameters.get(string);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean includes(@Nullable MimeType mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (this.isWildcardType()) {
            return true;
        }
        if (this.getType().equals(mimeType.getType())) {
            if (this.getSubtype().equals(mimeType.getSubtype())) {
                return true;
            }
            if (this.isWildcardSubtype()) {
                int n = this.getSubtype().lastIndexOf(43);
                if (n == -1) {
                    return true;
                }
                int n2 = mimeType.getSubtype().lastIndexOf(43);
                if (n2 != -1) {
                    String string;
                    String string2 = this.getSubtype().substring(0, n);
                    String string3 = this.getSubtype().substring(n + 1);
                    if (string3.equals(string = mimeType.getSubtype().substring(n2 + 1)) && WILDCARD_TYPE.equals(string2)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isCompatibleWith(@Nullable MimeType mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (this.isWildcardType() || mimeType.isWildcardType()) {
            return true;
        }
        if (this.getType().equals(mimeType.getType())) {
            if (this.getSubtype().equals(mimeType.getSubtype())) {
                return true;
            }
            if (this.isWildcardSubtype() || mimeType.isWildcardSubtype()) {
                int n = this.getSubtype().lastIndexOf(43);
                int n2 = mimeType.getSubtype().lastIndexOf(43);
                if (n == -1 && n2 == -1) {
                    return true;
                }
                if (n != -1 && n2 != -1) {
                    String string;
                    String string2 = this.getSubtype().substring(0, n);
                    String string3 = mimeType.getSubtype().substring(0, n2);
                    String string4 = this.getSubtype().substring(n + 1);
                    if (string4.equals(string = mimeType.getSubtype().substring(n2 + 1)) && (WILDCARD_TYPE.equals(string2) || WILDCARD_TYPE.equals(string3))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean equalsTypeAndSubtype(@Nullable MimeType mimeType) {
        if (mimeType == null) {
            return false;
        }
        return this.type.equalsIgnoreCase(mimeType.type) && this.subtype.equalsIgnoreCase(mimeType.subtype);
    }

    public boolean isPresentIn(Collection<? extends MimeType> collection) {
        for (MimeType mimeType : collection) {
            if (!mimeType.equalsTypeAndSubtype(this)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MimeType)) {
            return false;
        }
        MimeType mimeType = (MimeType)object;
        return this.type.equalsIgnoreCase(mimeType.type) && this.subtype.equalsIgnoreCase(mimeType.subtype) && this.parametersAreEqual(mimeType);
    }

    private boolean parametersAreEqual(MimeType mimeType) {
        if (this.parameters.size() != mimeType.parameters.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String string = entry.getKey();
            if (!mimeType.parameters.containsKey(string)) {
                return false;
            }
            if (!(PARAM_CHARSET.equals(string) ? !ObjectUtils.nullSafeEquals(this.getCharset(), mimeType.getCharset()) : !ObjectUtils.nullSafeEquals(entry.getValue(), mimeType.parameters.get(string)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        n = 31 * n + this.subtype.hashCode();
        n = 31 * n + this.parameters.hashCode();
        return n;
    }

    public String toString() {
        String string = this.toStringValue;
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendTo(stringBuilder);
            this.toStringValue = string = stringBuilder.toString();
        }
        return string;
    }

    protected void appendTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.type);
        stringBuilder.append('/');
        stringBuilder.append(this.subtype);
        this.appendTo(this.parameters, stringBuilder);
    }

    private void appendTo(Map<String, String> map, StringBuilder stringBuilder) {
        map.forEach((string, string2) -> {
            stringBuilder.append(';');
            stringBuilder.append((String)string);
            stringBuilder.append('=');
            stringBuilder.append((String)string2);
        });
    }

    @Override
    public int compareTo(MimeType mimeType) {
        int n = this.getType().compareToIgnoreCase(mimeType.getType());
        if (n != 0) {
            return n;
        }
        n = this.getSubtype().compareToIgnoreCase(mimeType.getSubtype());
        if (n != 0) {
            return n;
        }
        n = this.getParameters().size() - mimeType.getParameters().size();
        if (n != 0) {
            return n;
        }
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(this.getParameters().keySet());
        TreeSet<String> treeSet2 = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        treeSet2.addAll(mimeType.getParameters().keySet());
        Iterator iterator2 = treeSet.iterator();
        Iterator iterator3 = treeSet2.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object object2;
            String string;
            String string2 = (String)iterator2.next();
            n = string2.compareToIgnoreCase(string = (String)iterator3.next());
            if (n != 0) {
                return n;
            }
            if (PARAM_CHARSET.equals(string2)) {
                object2 = this.getCharset();
                if (object2 == (object = mimeType.getCharset())) continue;
                if (object2 == null) {
                    return -1;
                }
                if (object == null) {
                    return 1;
                }
                n = ((Charset)object2).compareTo((Charset)object);
                if (n == 0) continue;
                return n;
            }
            object2 = this.getParameters().get(string2);
            object = mimeType.getParameters().get(string);
            if (object == null) {
                object = "";
            }
            if ((n = ((String)object2).compareTo((String)object)) == 0) continue;
            return n;
        }
        return 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = this.getParameter(PARAM_CHARSET);
        if (string != null) {
            this.resolvedCharset = Charset.forName(this.unquote(string));
        }
    }

    public static MimeType valueOf(String string) {
        return MimeTypeUtils.parseMimeType(string);
    }

    private static Map<String, String> addCharsetParameter(Charset charset, Map<String, String> map) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(map);
        linkedHashMap.put(PARAM_CHARSET, charset.name());
        return linkedHashMap;
    }

    static {
        BitSet bitSet = new BitSet(128);
        for (int i = 0; i <= 31; ++i) {
            bitSet.set(i);
        }
        bitSet.set(127);
        BitSet bitSet2 = new BitSet(128);
        bitSet2.set(40);
        bitSet2.set(41);
        bitSet2.set(60);
        bitSet2.set(62);
        bitSet2.set(64);
        bitSet2.set(44);
        bitSet2.set(59);
        bitSet2.set(58);
        bitSet2.set(92);
        bitSet2.set(34);
        bitSet2.set(47);
        bitSet2.set(91);
        bitSet2.set(93);
        bitSet2.set(63);
        bitSet2.set(61);
        bitSet2.set(123);
        bitSet2.set(125);
        bitSet2.set(32);
        bitSet2.set(9);
        TOKEN = new BitSet(128);
        TOKEN.set(0, 128);
        TOKEN.andNot(bitSet);
        TOKEN.andNot(bitSet2);
    }

    public static class SpecificityComparator<T extends MimeType>
    implements Comparator<T> {
        @Override
        public int compare(T t2, T t3) {
            if (((MimeType)t2).isWildcardType() && !((MimeType)t3).isWildcardType()) {
                return 1;
            }
            if (((MimeType)t3).isWildcardType() && !((MimeType)t2).isWildcardType()) {
                return -1;
            }
            if (!((MimeType)t2).getType().equals(((MimeType)t3).getType())) {
                return 0;
            }
            if (((MimeType)t2).isWildcardSubtype() && !((MimeType)t3).isWildcardSubtype()) {
                return 1;
            }
            if (((MimeType)t3).isWildcardSubtype() && !((MimeType)t2).isWildcardSubtype()) {
                return -1;
            }
            if (!((MimeType)t2).getSubtype().equals(((MimeType)t3).getSubtype())) {
                return 0;
            }
            return this.compareParameters(t2, t3);
        }

        protected int compareParameters(T t2, T t3) {
            int n = ((MimeType)t2).getParameters().size();
            int n2 = ((MimeType)t3).getParameters().size();
            return Integer.compare(n2, n);
        }
    }
}

