/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MethodInvoker {
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    @Nullable
    protected Class<?> targetClass;
    @Nullable
    private Object targetObject;
    @Nullable
    private String targetMethod;
    @Nullable
    private String staticMethod;
    @Nullable
    private Object[] arguments;
    @Nullable
    private Method methodObject;

    public void setTargetClass(@Nullable Class<?> clazz) {
        this.targetClass = clazz;
    }

    @Nullable
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public void setTargetObject(@Nullable Object object) {
        this.targetObject = object;
        if (object != null) {
            this.targetClass = object.getClass();
        }
    }

    @Nullable
    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetMethod(@Nullable String string) {
        this.targetMethod = string;
    }

    @Nullable
    public String getTargetMethod() {
        return this.targetMethod;
    }

    public void setStaticMethod(String string) {
        this.staticMethod = string;
    }

    public void setArguments(Object ... objectArray) {
        this.arguments = objectArray;
    }

    public Object[] getArguments() {
        return this.arguments != null ? this.arguments : EMPTY_ARGUMENTS;
    }

    public void prepare() throws ClassNotFoundException, NoSuchMethodException {
        block5: {
            Object object;
            String string;
            if (this.staticMethod != null) {
                int n = this.staticMethod.lastIndexOf(46);
                if (n == -1 || n == this.staticMethod.length()) {
                    throw new IllegalArgumentException("staticMethod must be a fully qualified class plus method name: e.g. 'example.MyExampleClass.myExampleMethod'");
                }
                string = this.staticMethod.substring(0, n);
                object = this.staticMethod.substring(n + 1);
                this.targetClass = this.resolveClassName(string);
                this.targetMethod = object;
            }
            Class<?> clazz = this.getTargetClass();
            string = this.getTargetMethod();
            Assert.notNull(clazz, "Either 'targetClass' or 'targetObject' is required");
            Assert.notNull((Object)string, "Property 'targetMethod' is required");
            object = this.getArguments();
            Class[] classArray = new Class[((Object[])object).length];
            for (int i = 0; i < ((Object[])object).length; ++i) {
                classArray[i] = object[i] != null ? object[i].getClass() : Object.class;
            }
            try {
                this.methodObject = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.methodObject = this.findMatchingMethod();
                if (this.methodObject != null) break block5;
                throw noSuchMethodException;
            }
        }
    }

    protected Class<?> resolveClassName(String string) throws ClassNotFoundException {
        return ClassUtils.forName(string, ClassUtils.getDefaultClassLoader());
    }

    @Nullable
    protected Method findMatchingMethod() {
        String string = this.getTargetMethod();
        Object[] objectArray = this.getArguments();
        int n = objectArray.length;
        Class<?> clazz = this.getTargetClass();
        Assert.state(clazz != null, "No target class set");
        Method[] methodArray = ReflectionUtils.getAllDeclaredMethods(clazz);
        int n2 = Integer.MAX_VALUE;
        Method method = null;
        for (Method method2 : methodArray) {
            Class<?>[] classArray;
            int n3;
            if (!method2.getName().equals(string) || method2.getParameterCount() != n || (n3 = MethodInvoker.getTypeDifferenceWeight(classArray = method2.getParameterTypes(), objectArray)) >= n2) continue;
            n2 = n3;
            method = method2;
        }
        return method;
    }

    public Method getPreparedMethod() throws IllegalStateException {
        if (this.methodObject == null) {
            throw new IllegalStateException("prepare() must be called prior to invoke() on MethodInvoker");
        }
        return this.methodObject;
    }

    public boolean isPrepared() {
        return this.methodObject != null;
    }

    @Nullable
    public Object invoke() throws InvocationTargetException, IllegalAccessException {
        Object object = this.getTargetObject();
        Method method = this.getPreparedMethod();
        if (object == null && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Target method must not be non-static without a target");
        }
        ReflectionUtils.makeAccessible(method);
        return method.invoke(object, this.getArguments());
    }

    public static int getTypeDifferenceWeight(Class<?>[] classArray, Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            if (!ClassUtils.isAssignableValue(classArray[i], objectArray[i])) {
                return Integer.MAX_VALUE;
            }
            if (objectArray[i] == null) continue;
            Class<?> clazz = classArray[i];
            Class<?> clazz2 = objectArray[i].getClass().getSuperclass();
            while (clazz2 != null) {
                if (clazz.equals(clazz2)) {
                    n += 2;
                    clazz2 = null;
                    continue;
                }
                if (ClassUtils.isAssignable(clazz, clazz2)) {
                    n += 2;
                    clazz2 = clazz2.getSuperclass();
                    continue;
                }
                clazz2 = null;
            }
            if (!clazz.isInterface()) continue;
            ++n;
        }
        return n;
    }
}

