/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;
import org.springframework.util.ObjectUtils;

public abstract class CollectionUtils {
    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static List arrayToList(@Nullable Object object) {
        return Arrays.asList(ObjectUtils.toObjectArray(object));
    }

    public static <E> void mergeArrayIntoCollection(@Nullable Object object, Collection<E> collection) {
        Object[] objectArray;
        for (Object object2 : objectArray = ObjectUtils.toObjectArray(object)) {
            collection.add(object2);
        }
    }

    public static <K, V> void mergePropertiesIntoMap(@Nullable Properties properties, Map<K, V> map) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = properties.get(string);
                if (object == null) {
                    object = properties.getProperty(string);
                }
                map.put(string, object);
            }
        }
    }

    public static boolean contains(@Nullable Iterator<?> iterator2, Object object) {
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                Object obj = iterator2.next();
                if (!ObjectUtils.nullSafeEquals(obj, object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(@Nullable Enumeration<?> enumeration, Object object) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(obj, object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(@Nullable Collection<?> collection, Object object) {
        if (collection != null) {
            for (Object obj : collection) {
                if (obj != object) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection<?> collection, Collection<?> collection2) {
        return CollectionUtils.findFirstMatch(collection, collection2) != null;
    }

    @Nullable
    public static <E> E findFirstMatch(Collection<?> collection, Collection<E> collection2) {
        if (CollectionUtils.isEmpty(collection) || CollectionUtils.isEmpty(collection2)) {
            return null;
        }
        for (E e : collection2) {
            if (!collection.contains(e)) continue;
            return e;
        }
        return null;
    }

    @Nullable
    public static <T> T findValueOfType(Collection<?> collection, @Nullable Class<T> clazz) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        T t2 = null;
        for (Object obj : collection) {
            if (clazz != null && !clazz.isInstance(obj)) continue;
            if (t2 != null) {
                return null;
            }
            t2 = (T)obj;
        }
        return t2;
    }

    @Nullable
    public static Object findValueOfType(Collection<?> collection, Class<?>[] classArray) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(classArray)) {
            return null;
        }
        for (Class<?> clazz : classArray) {
            Object obj = CollectionUtils.findValueOfType(collection, clazz);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean bl = false;
        Object var2_2 = null;
        for (Object obj : collection) {
            if (!bl) {
                bl = true;
                var2_2 = obj;
                continue;
            }
            if (var2_2 == obj) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Class<?> findCommonElementType(Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class<?> clazz = null;
        for (Object obj : collection) {
            if (obj == null) continue;
            if (clazz == null) {
                clazz = obj.getClass();
                continue;
            }
            if (clazz == obj.getClass()) continue;
            return null;
        }
        return clazz;
    }

    @Nullable
    public static <T> T firstElement(@Nullable Set<T> set) {
        if (CollectionUtils.isEmpty(set)) {
            return null;
        }
        if (set instanceof SortedSet) {
            return (T)((SortedSet)set).first();
        }
        Iterator<T> iterator2 = set.iterator();
        T t2 = null;
        if (iterator2.hasNext()) {
            t2 = iterator2.next();
        }
        return t2;
    }

    @Nullable
    public static <T> T firstElement(@Nullable List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Nullable
    public static <T> T lastElement(@Nullable Set<T> set) {
        if (CollectionUtils.isEmpty(set)) {
            return null;
        }
        if (set instanceof SortedSet) {
            return (T)((SortedSet)set).last();
        }
        Iterator<T> iterator2 = set.iterator();
        T t2 = null;
        while (iterator2.hasNext()) {
            t2 = iterator2.next();
        }
        return t2;
    }

    @Nullable
    public static <T> T lastElement(@Nullable List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] AArray) {
        ArrayList<E> arrayList = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(AArray);
    }

    public static <E> Iterator<E> toIterator(@Nullable Enumeration<E> enumeration) {
        return enumeration != null ? new EnumerationIterator<E>(enumeration) : Collections.emptyIterator();
    }

    public static <K, V> MultiValueMap<K, V> toMultiValueMap(Map<K, List<V>> map) {
        Assert.notNull(map, "'targetMap' must not be null");
        return new MultiValueMapAdapter<K, V>(map);
    }

    public static <K, V> MultiValueMap<K, V> unmodifiableMultiValueMap(MultiValueMap<? extends K, ? extends V> multiValueMap) {
        Assert.notNull(multiValueMap, "'targetMap' must not be null");
        LinkedHashMap linkedHashMap = new LinkedHashMap(multiValueMap.size());
        multiValueMap.forEach((object, list) -> {
            List list2 = Collections.unmodifiableList(list);
            linkedHashMap.put(object, list2);
        });
        Map map = Collections.unmodifiableMap(linkedHashMap);
        return CollectionUtils.toMultiValueMap(map);
    }

    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private final Enumeration<E> enumeration;

        public EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

