/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Assert {
    public static void state(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    public static void state(boolean bl, Supplier<String> supplier) {
        if (!bl) {
            throw new IllegalStateException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void state(boolean bl) {
        Assert.state(bl, "[Assertion failed] - this state invariant must be true");
    }

    public static void isTrue(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void isTrue(boolean bl, Supplier<String> supplier) {
        if (!bl) {
            throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void isTrue(boolean bl) {
        Assert.isTrue(bl, "[Assertion failed] - this expression must be true");
    }

    public static void isNull(@Nullable Object object, String string) {
        if (object != null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void isNull(@Nullable Object object, Supplier<String> supplier) {
        if (object != null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void isNull(@Nullable Object object) {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null");
    }

    public static void notNull(@Nullable Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notNull(@Nullable Object object, Supplier<String> supplier) {
        if (object == null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void notNull(@Nullable Object object) {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static void hasLength(@Nullable String string, String string2) {
        if (!StringUtils.hasLength(string)) {
            throw new IllegalArgumentException(string2);
        }
    }

    public static void hasLength(@Nullable String string, Supplier<String> supplier) {
        if (!StringUtils.hasLength(string)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void hasLength(@Nullable String string) {
        Assert.hasLength(string, "[Assertion failed] - this String argument must have length; it must not be null or empty");
    }

    public static void hasText(@Nullable String string, String string2) {
        if (!StringUtils.hasText(string)) {
            throw new IllegalArgumentException(string2);
        }
    }

    public static void hasText(@Nullable String string, Supplier<String> supplier) {
        if (!StringUtils.hasText(string)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void hasText(@Nullable String string) {
        Assert.hasText(string, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
    }

    public static void doesNotContain(@Nullable String string, String string2, String string3) {
        if (StringUtils.hasLength(string) && StringUtils.hasLength(string2) && string.contains(string2)) {
            throw new IllegalArgumentException(string3);
        }
    }

    public static void doesNotContain(@Nullable String string, String string2, Supplier<String> supplier) {
        if (StringUtils.hasLength(string) && StringUtils.hasLength(string2) && string.contains(string2)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void doesNotContain(@Nullable String string, String string2) {
        Assert.doesNotContain(string, string2, () -> "[Assertion failed] - this String argument must not contain the substring [" + string2 + "]");
    }

    public static void notEmpty(@Nullable Object[] objectArray, String string) {
        if (ObjectUtils.isEmpty(objectArray)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notEmpty(@Nullable Object[] objectArray, Supplier<String> supplier) {
        if (ObjectUtils.isEmpty(objectArray)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void notEmpty(@Nullable Object[] objectArray) {
        Assert.notEmpty(objectArray, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void noNullElements(@Nullable Object[] objectArray, String string) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object != null) continue;
                throw new IllegalArgumentException(string);
            }
        }
    }

    public static void noNullElements(@Nullable Object[] objectArray, Supplier<String> supplier) {
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object != null) continue;
                throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
            }
        }
    }

    @Deprecated
    public static void noNullElements(@Nullable Object[] objectArray) {
        Assert.noNullElements(objectArray, "[Assertion failed] - this array must not contain any null elements");
    }

    public static void notEmpty(@Nullable Collection<?> collection, String string) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, Supplier<String> supplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void notEmpty(@Nullable Collection<?> collection) {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static void noNullElements(@Nullable Collection<?> collection, String string) {
        if (collection != null) {
            for (Object obj : collection) {
                if (obj != null) continue;
                throw new IllegalArgumentException(string);
            }
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, Supplier<String> supplier) {
        if (collection != null) {
            for (Object obj : collection) {
                if (obj != null) continue;
                throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
            }
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map, String string) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map, Supplier<String> supplier) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(supplier));
        }
    }

    @Deprecated
    public static void notEmpty(@Nullable Map<?, ?> map) {
        Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static void isInstanceOf(Class<?> clazz, @Nullable Object object, String string) {
        Assert.notNull(clazz, "Type to check against must not be null");
        if (!clazz.isInstance(object)) {
            Assert.instanceCheckFailed(clazz, object, string);
        }
    }

    public static void isInstanceOf(Class<?> clazz, @Nullable Object object, Supplier<String> supplier) {
        Assert.notNull(clazz, "Type to check against must not be null");
        if (!clazz.isInstance(object)) {
            Assert.instanceCheckFailed(clazz, object, Assert.nullSafeGet(supplier));
        }
    }

    public static void isInstanceOf(Class<?> clazz, @Nullable Object object) {
        Assert.isInstanceOf(clazz, object, "");
    }

    public static void isAssignable(Class<?> clazz, @Nullable Class<?> clazz2, String string) {
        Assert.notNull(clazz, "Super type to check against must not be null");
        if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) {
            Assert.assignableCheckFailed(clazz, clazz2, string);
        }
    }

    public static void isAssignable(Class<?> clazz, @Nullable Class<?> clazz2, Supplier<String> supplier) {
        Assert.notNull(clazz, "Super type to check against must not be null");
        if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) {
            Assert.assignableCheckFailed(clazz, clazz2, Assert.nullSafeGet(supplier));
        }
    }

    public static void isAssignable(Class<?> clazz, Class<?> clazz2) {
        Assert.isAssignable(clazz, clazz2, "");
    }

    private static void instanceCheckFailed(Class<?> clazz, @Nullable Object object, @Nullable String string) {
        String string2 = object != null ? object.getClass().getName() : "null";
        String string3 = "";
        boolean bl = true;
        if (StringUtils.hasLength(string)) {
            if (Assert.endsWithSeparator(string)) {
                string3 = string + " ";
            } else {
                string3 = Assert.messageWithTypeName(string, string2);
                bl = false;
            }
        }
        if (bl) {
            string3 = string3 + "Object of class [" + string2 + "] must be an instance of " + clazz;
        }
        throw new IllegalArgumentException(string3);
    }

    private static void assignableCheckFailed(Class<?> clazz, @Nullable Class<?> clazz2, @Nullable String string) {
        String string2 = "";
        boolean bl = true;
        if (StringUtils.hasLength(string)) {
            if (Assert.endsWithSeparator(string)) {
                string2 = string + " ";
            } else {
                string2 = Assert.messageWithTypeName(string, clazz2);
                bl = false;
            }
        }
        if (bl) {
            string2 = string2 + clazz2 + " is not assignable to " + clazz;
        }
        throw new IllegalArgumentException(string2);
    }

    private static boolean endsWithSeparator(String string) {
        return string.endsWith(":") || string.endsWith(";") || string.endsWith(",") || string.endsWith(".");
    }

    private static String messageWithTypeName(String string, @Nullable Object object) {
        return string + (string.endsWith(" ") ? "" : ": ") + object;
    }

    @Nullable
    private static String nullSafeGet(@Nullable Supplier<String> supplier) {
        return supplier != null ? supplier.get() : null;
    }
}

