/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import org.springframework.util.IdGenerator;

public class AlternativeJdkIdGenerator
implements IdGenerator {
    private final Random random;

    public AlternativeJdkIdGenerator() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        this.random = new Random(new BigInteger(byArray).longValue());
    }

    @Override
    public UUID generateId() {
        byte[] byArray = new byte[16];
        this.random.nextBytes(byArray);
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(byArray[i] & 0xFF);
        }
        long l2 = 0L;
        for (int i = 8; i < 16; ++i) {
            l2 = l2 << 8 | (long)(byArray[i] & 0xFF);
        }
        return new UUID(l, l2);
    }
}

