/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.ProtectionDomain;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.util.UnsafeUtils;
import org.springframework.objenesis.strategy.PlatformDescription;
import sun.misc.Unsafe;

public final class DefineClassHelper {
    private static final Helper privileged = PlatformDescription.isAfterJava11() ? new Java11() : new Java8();

    public static Class<?> defineClass(String string, byte[] byArray, int n, int n2, Class<?> clazz, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        return privileged.defineClass(string, byArray, n, n2, clazz, classLoader, protectionDomain);
    }

    private DefineClassHelper() {
    }

    private static class Java11
    extends Helper {
        private final Class<?> module = this.module();
        private final MethodHandles.Lookup lookup = MethodHandles.lookup();
        private final MethodHandle getModule = this.getModule();
        private final MethodHandle addReads = this.addReads();
        private final MethodHandle privateLookupIn = this.privateLookupIn();
        private final MethodHandle defineClass = this.defineClass();

        private Java11() {
        }

        private Class<?> module() {
            try {
                return Class.forName("java.lang.Module");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ObjenesisException(classNotFoundException);
            }
        }

        private MethodHandle getModule() {
            try {
                return this.lookup.findVirtual(Class.class, "getModule", MethodType.methodType(this.module));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new ObjenesisException(reflectiveOperationException);
            }
        }

        private MethodHandle addReads() {
            try {
                return this.lookup.findVirtual(this.module, "addReads", MethodType.methodType(this.module, this.module));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new ObjenesisException(reflectiveOperationException);
            }
        }

        private MethodHandle privateLookupIn() {
            try {
                return this.lookup.findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new ObjenesisException(reflectiveOperationException);
            }
        }

        private MethodHandle defineClass() {
            try {
                return this.lookup.findVirtual(MethodHandles.Lookup.class, "defineClass", MethodType.methodType(Class.class, byte[].class));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new ObjenesisException(reflectiveOperationException);
            }
        }

        @Override
        Class<?> defineClass(String string, byte[] byArray, int n, int n2, Class<?> clazz, ClassLoader classLoader, ProtectionDomain protectionDomain) {
            try {
                Object object = this.getModule.invokeWithArguments(DefineClassHelper.class);
                Object object2 = this.getModule.invokeWithArguments(clazz);
                this.addReads.invokeWithArguments(object, object2);
                MethodHandles.Lookup lookup = this.privateLookupIn.invokeExact(clazz, this.lookup);
                return this.defineClass.invokeExact(lookup, byArray);
            }
            catch (Throwable throwable) {
                throw new ObjenesisException(clazz.getName() + " has no permission to define the class", throwable);
            }
        }
    }

    private static class Java8
    extends Helper {
        private final MethodHandle defineClass = this.defineClass();

        private Java8() {
        }

        private MethodHandle defineClass() {
            MethodHandle methodHandle;
            MethodType methodType = MethodType.methodType(Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
            try {
                methodHandle = MethodHandles.publicLookup().findVirtual(Unsafe.class, "defineClass", methodType);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new ObjenesisException(reflectiveOperationException);
            }
            Unsafe unsafe = UnsafeUtils.getUnsafe();
            return methodHandle.bindTo(unsafe);
        }

        @Override
        Class<?> defineClass(String string, byte[] byArray, int n, int n2, Class<?> clazz, ClassLoader classLoader, ProtectionDomain protectionDomain) {
            try {
                return this.defineClass.invokeExact(string, byArray, n, n2, classLoader, protectionDomain);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new ObjenesisException(throwable);
            }
        }
    }

    private static abstract class Helper {
        private Helper() {
        }

        abstract Class<?> defineClass(String var1, byte[] var2, int var3, int var4, Class<?> var5, ClassLoader var6, ProtectionDomain var7);
    }
}

