/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.sun;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.objenesis.ObjenesisException;

class SunReflectionFactoryHelper {
    SunReflectionFactoryHelper() {
    }

    public static <T> Constructor<T> newConstructorForSerialization(Class<T> clazz, Constructor<?> constructor) {
        Class<?> clazz2 = SunReflectionFactoryHelper.getReflectionFactoryClass();
        Object object = SunReflectionFactoryHelper.createReflectionFactory(clazz2);
        Method method = SunReflectionFactoryHelper.getNewConstructorForSerializationMethod(clazz2);
        try {
            return (Constructor)method.invoke(object, clazz, constructor);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new ObjenesisException(exception);
        }
    }

    private static Class<?> getReflectionFactoryClass() {
        try {
            return Class.forName("sun.reflect.ReflectionFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ObjenesisException(classNotFoundException);
        }
    }

    private static Object createReflectionFactory(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getReflectionFactory", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
            throw new ObjenesisException(exception);
        }
    }

    private static Method getNewConstructorForSerializationMethod(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethod("newConstructorForSerialization", Class.class, Constructor.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ObjenesisException(noSuchMethodException);
        }
    }
}

