/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.filter;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.Nullable;

public abstract class AbstractTypeHierarchyTraversingFilter
implements TypeFilter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final boolean considerInherited;
    private final boolean considerInterfaces;

    protected AbstractTypeHierarchyTraversingFilter(boolean bl, boolean bl2) {
        this.considerInherited = bl;
        this.considerInterfaces = bl2;
    }

    @Override
    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        ClassMetadata classMetadata;
        block15: {
            String[] stringArray;
            if (this.matchSelf(metadataReader)) {
                return true;
            }
            classMetadata = metadataReader.getClassMetadata();
            if (this.matchClassName(classMetadata.getClassName())) {
                return true;
            }
            if (this.considerInherited && (stringArray = classMetadata.getSuperClassName()) != null) {
                Boolean bl = this.matchSuperClass((String)stringArray);
                if (bl != null) {
                    if (bl.booleanValue()) {
                        return true;
                    }
                } else {
                    try {
                        if (this.match(classMetadata.getSuperClassName(), metadataReaderFactory)) {
                            return true;
                        }
                    }
                    catch (IOException iOException) {
                        if (!this.logger.isDebugEnabled()) break block15;
                        this.logger.debug("Could not read super class [" + classMetadata.getSuperClassName() + "] of type-filtered class [" + classMetadata.getClassName() + "]");
                    }
                }
            }
        }
        if (this.considerInterfaces) {
            for (String string : classMetadata.getInterfaceNames()) {
                Boolean bl = this.matchInterface(string);
                if (bl != null) {
                    if (!bl.booleanValue()) continue;
                    return true;
                }
                try {
                    if (this.match(string, metadataReaderFactory)) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Could not read interface [" + string + "] for type-filtered class [" + classMetadata.getClassName() + "]");
                }
            }
        }
        return false;
    }

    private boolean match(String string, MetadataReaderFactory metadataReaderFactory) throws IOException {
        return this.match(metadataReaderFactory.getMetadataReader(string), metadataReaderFactory);
    }

    protected boolean matchSelf(MetadataReader metadataReader) {
        return false;
    }

    protected boolean matchClassName(String string) {
        return false;
    }

    @Nullable
    protected Boolean matchSuperClass(String string) {
        return null;
    }

    @Nullable
    protected Boolean matchInterface(String string) {
        return null;
    }
}

