/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReader;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class SimpleMetadataReaderFactory
implements MetadataReaderFactory {
    private final ResourceLoader resourceLoader;

    public SimpleMetadataReaderFactory() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(@Nullable ClassLoader classLoader) {
        this.resourceLoader = classLoader != null ? new DefaultResourceLoader(classLoader) : new DefaultResourceLoader();
    }

    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public MetadataReader getMetadataReader(String string) throws IOException {
        try {
            String string2 = "classpath:" + ClassUtils.convertClassNameToResourcePath(string) + ".class";
            Resource resource = this.resourceLoader.getResource(string2);
            return this.getMetadataReader(resource);
        }
        catch (FileNotFoundException fileNotFoundException) {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                String string3 = string.substring(0, n) + '$' + string.substring(n + 1);
                String string4 = "classpath:" + ClassUtils.convertClassNameToResourcePath(string3) + ".class";
                Resource resource = this.resourceLoader.getResource(string4);
                if (resource.exists()) {
                    return this.getMetadataReader(resource);
                }
            }
            throw fileNotFoundException;
        }
    }

    @Override
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        return new SimpleMetadataReader(resource, this.resourceLoader.getClassLoader());
    }
}

