/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task.support;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureTask;

public class TaskExecutorAdapter
implements AsyncListenableTaskExecutor {
    private final Executor concurrentExecutor;
    @Nullable
    private TaskDecorator taskDecorator;

    public TaskExecutorAdapter(Executor executor) {
        Assert.notNull((Object)executor, "Executor must not be null");
        this.concurrentExecutor = executor;
    }

    public final void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    @Override
    public void execute(Runnable runnable2) {
        try {
            this.doExecute(this.concurrentExecutor, this.taskDecorator, runnable2);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + runnable2, rejectedExecutionException);
        }
    }

    @Override
    public void execute(Runnable runnable2, long l) {
        this.execute(runnable2);
    }

    @Override
    public Future<?> submit(Runnable runnable2) {
        try {
            if (this.taskDecorator == null && this.concurrentExecutor instanceof ExecutorService) {
                return ((ExecutorService)this.concurrentExecutor).submit(runnable2);
            }
            FutureTask<Object> futureTask = new FutureTask<Object>(runnable2, null);
            this.doExecute(this.concurrentExecutor, this.taskDecorator, futureTask);
            return futureTask;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + runnable2, rejectedExecutionException);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        try {
            if (this.taskDecorator == null && this.concurrentExecutor instanceof ExecutorService) {
                return ((ExecutorService)this.concurrentExecutor).submit(callable);
            }
            FutureTask<T> futureTask = new FutureTask<T>(callable);
            this.doExecute(this.concurrentExecutor, this.taskDecorator, futureTask);
            return futureTask;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + callable, rejectedExecutionException);
        }
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable runnable2) {
        try {
            ListenableFutureTask<Object> listenableFutureTask = new ListenableFutureTask<Object>(runnable2, null);
            this.doExecute(this.concurrentExecutor, this.taskDecorator, listenableFutureTask);
            return listenableFutureTask;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + runnable2, rejectedExecutionException);
        }
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> callable) {
        try {
            ListenableFutureTask<T> listenableFutureTask = new ListenableFutureTask<T>(callable);
            this.doExecute(this.concurrentExecutor, this.taskDecorator, listenableFutureTask);
            return listenableFutureTask;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + callable, rejectedExecutionException);
        }
    }

    protected void doExecute(Executor executor, @Nullable TaskDecorator taskDecorator, Runnable runnable2) throws RejectedExecutionException {
        executor.execute(taskDecorator != null ? taskDecorator.decorate(runnable2) : runnable2);
    }
}

