/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ToStringCreator {
    private static final ToStringStyler DEFAULT_TO_STRING_STYLER = new DefaultToStringStyler(StylerUtils.DEFAULT_VALUE_STYLER);
    private final StringBuilder buffer = new StringBuilder(256);
    private final ToStringStyler styler;
    private final Object object;
    private boolean styledFirstField;

    public ToStringCreator(Object object) {
        this(object, (ToStringStyler)null);
    }

    public ToStringCreator(Object object, @Nullable ValueStyler valueStyler) {
        this(object, new DefaultToStringStyler(valueStyler != null ? valueStyler : StylerUtils.DEFAULT_VALUE_STYLER));
    }

    public ToStringCreator(Object object, @Nullable ToStringStyler toStringStyler) {
        Assert.notNull(object, "The object to be styled must not be null");
        this.object = object;
        this.styler = toStringStyler != null ? toStringStyler : DEFAULT_TO_STRING_STYLER;
        this.styler.styleStart(this.buffer, this.object);
    }

    public ToStringCreator append(String string, byte by) {
        return this.append(string, (Object)by);
    }

    public ToStringCreator append(String string, short s2) {
        return this.append(string, (Object)s2);
    }

    public ToStringCreator append(String string, int n) {
        return this.append(string, (Object)n);
    }

    public ToStringCreator append(String string, long l) {
        return this.append(string, (Object)l);
    }

    public ToStringCreator append(String string, float f) {
        return this.append(string, Float.valueOf(f));
    }

    public ToStringCreator append(String string, double d) {
        return this.append(string, (Object)d);
    }

    public ToStringCreator append(String string, boolean bl) {
        return this.append(string, (Object)bl);
    }

    public ToStringCreator append(String string, @Nullable Object object) {
        this.printFieldSeparatorIfNecessary();
        this.styler.styleField(this.buffer, string, object);
        return this;
    }

    private void printFieldSeparatorIfNecessary() {
        if (this.styledFirstField) {
            this.styler.styleFieldSeparator(this.buffer);
        } else {
            this.styledFirstField = true;
        }
    }

    public ToStringCreator append(Object object) {
        this.styler.styleValue(this.buffer, object);
        return this;
    }

    public String toString() {
        this.styler.styleEnd(this.buffer, this.object);
        return this.buffer.toString();
    }
}

