/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class LogMessage
implements CharSequence {
    @Nullable
    private String result;

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int n) {
        return this.toString().charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.toString().subSequence(n, n2);
    }

    @Override
    public String toString() {
        if (this.result == null) {
            this.result = this.buildString();
        }
        return this.result;
    }

    abstract String buildString();

    public static LogMessage of(Supplier<? extends CharSequence> supplier) {
        return new SupplierMessage(supplier);
    }

    public static LogMessage format(String string, Object object) {
        return new FormatMessage1(string, object);
    }

    public static LogMessage format(String string, Object object, Object object2) {
        return new FormatMessage2(string, object, object2);
    }

    public static LogMessage format(String string, Object object, Object object2, Object object3) {
        return new FormatMessage3(string, object, object2, object3);
    }

    public static LogMessage format(String string, Object object, Object object2, Object object3, Object object4) {
        return new FormatMessage4(string, object, object2, object3, object4);
    }

    public static LogMessage format(String string, Object ... objectArray) {
        return new FormatMessageX(string, objectArray);
    }

    private static final class FormatMessageX
    extends FormatMessage {
        private final Object[] args;

        FormatMessageX(String string, Object ... objectArray) {
            super(string);
            this.args = objectArray;
        }

        @Override
        String buildString() {
            return String.format(this.format, this.args);
        }
    }

    private static final class FormatMessage4
    extends FormatMessage {
        private final Object arg1;
        private final Object arg2;
        private final Object arg3;
        private final Object arg4;

        FormatMessage4(String string, Object object, Object object2, Object object3, Object object4) {
            super(string);
            this.arg1 = object;
            this.arg2 = object2;
            this.arg3 = object3;
            this.arg4 = object4;
        }

        @Override
        String buildString() {
            return String.format(this.format, this.arg1, this.arg2, this.arg3, this.arg4);
        }
    }

    private static final class FormatMessage3
    extends FormatMessage {
        private final Object arg1;
        private final Object arg2;
        private final Object arg3;

        FormatMessage3(String string, Object object, Object object2, Object object3) {
            super(string);
            this.arg1 = object;
            this.arg2 = object2;
            this.arg3 = object3;
        }

        @Override
        String buildString() {
            return String.format(this.format, this.arg1, this.arg2, this.arg3);
        }
    }

    private static final class FormatMessage2
    extends FormatMessage {
        private final Object arg1;
        private final Object arg2;

        FormatMessage2(String string, Object object, Object object2) {
            super(string);
            this.arg1 = object;
            this.arg2 = object2;
        }

        @Override
        String buildString() {
            return String.format(this.format, this.arg1, this.arg2);
        }
    }

    private static final class FormatMessage1
    extends FormatMessage {
        private final Object arg1;

        FormatMessage1(String string, Object object) {
            super(string);
            this.arg1 = object;
        }

        @Override
        protected String buildString() {
            return String.format(this.format, this.arg1);
        }
    }

    private static abstract class FormatMessage
    extends LogMessage {
        protected final String format;

        FormatMessage(String string) {
            Assert.notNull((Object)string, "Format must not be null");
            this.format = string;
        }
    }

    private static final class SupplierMessage
    extends LogMessage {
        private Supplier<? extends CharSequence> supplier;

        SupplierMessage(Supplier<? extends CharSequence> supplier) {
            Assert.notNull(supplier, "Supplier must not be null");
            this.supplier = supplier;
        }

        @Override
        String buildString() {
            return this.supplier.get().toString();
        }
    }
}

