/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public abstract class LogFormatUtils {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("[\n\r]");
    private static final Pattern CONTROL_CHARACTER_PATTERN = Pattern.compile("\\p{Cc}");

    public static String formatValue(@Nullable Object object, boolean bl) {
        return LogFormatUtils.formatValue(object, bl ? 100 : -1, bl);
    }

    public static String formatValue(@Nullable Object object, int n, boolean bl) {
        String string;
        if (object == null) {
            return "";
        }
        try {
            string = ObjectUtils.nullSafeToString(object);
        }
        catch (Throwable throwable) {
            string = ObjectUtils.nullSafeToString(throwable);
        }
        if (n != -1) {
            String string2 = string = string.length() > n ? string.substring(0, n) + " (truncated)..." : string;
        }
        if (bl) {
            string = NEWLINE_PATTERN.matcher(string).replaceAll("<EOL>");
            string = CONTROL_CHARACTER_PATTERN.matcher(string).replaceAll("?");
        }
        if (object instanceof CharSequence) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    public static void traceDebug(Log log, Function<Boolean, String> function) {
        if (log.isDebugEnabled()) {
            boolean bl = log.isTraceEnabled();
            String string = function.apply(bl);
            if (bl) {
                log.trace(string);
            } else {
                log.debug(string);
            }
        }
    }
}

