/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.log;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;

public class LogAccessor {
    private final Log log;

    public LogAccessor(Log log) {
        this.log = log;
    }

    public LogAccessor(Class<?> clazz) {
        this.log = LogFactory.getLog(clazz);
    }

    public LogAccessor(String string) {
        this.log = LogFactory.getLog(string);
    }

    public final Log getLog() {
        return this.log;
    }

    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public void fatal(CharSequence charSequence) {
        this.log.fatal(charSequence);
    }

    public void fatal(Throwable throwable, CharSequence charSequence) {
        this.log.fatal(charSequence, throwable);
    }

    public void error(CharSequence charSequence) {
        this.log.error(charSequence);
    }

    public void error(Throwable throwable, CharSequence charSequence) {
        this.log.error(charSequence, throwable);
    }

    public void warn(CharSequence charSequence) {
        this.log.warn(charSequence);
    }

    public void warn(Throwable throwable, CharSequence charSequence) {
        this.log.warn(charSequence, throwable);
    }

    public void info(CharSequence charSequence) {
        this.log.info(charSequence);
    }

    public void info(Throwable throwable, CharSequence charSequence) {
        this.log.info(charSequence, throwable);
    }

    public void debug(CharSequence charSequence) {
        this.log.debug(charSequence);
    }

    public void debug(Throwable throwable, CharSequence charSequence) {
        this.log.debug(charSequence, throwable);
    }

    public void trace(CharSequence charSequence) {
        this.log.trace(charSequence);
    }

    public void trace(Throwable throwable, CharSequence charSequence) {
        this.log.trace(charSequence, throwable);
    }

    public void fatal(Supplier<? extends CharSequence> supplier) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal(LogMessage.of(supplier));
        }
    }

    public void fatal(Throwable throwable, Supplier<? extends CharSequence> supplier) {
        if (this.log.isFatalEnabled()) {
            this.log.fatal(LogMessage.of(supplier), throwable);
        }
    }

    public void error(Supplier<? extends CharSequence> supplier) {
        if (this.log.isErrorEnabled()) {
            this.log.error(LogMessage.of(supplier));
        }
    }

    public void error(Throwable throwable, Supplier<? extends CharSequence> supplier) {
        if (this.log.isErrorEnabled()) {
            this.log.error(LogMessage.of(supplier), throwable);
        }
    }

    public void warn(Supplier<? extends CharSequence> supplier) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(LogMessage.of(supplier));
        }
    }

    public void warn(Throwable throwable, Supplier<? extends CharSequence> supplier) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(LogMessage.of(supplier), throwable);
        }
    }

    public void info(Supplier<? extends CharSequence> supplier) {
        if (this.log.isInfoEnabled()) {
            this.log.info(LogMessage.of(supplier));
        }
    }

    public void info(Throwable throwable, Supplier<? extends CharSequence> supplier) {
        if (this.log.isInfoEnabled()) {
            this.log.info(LogMessage.of(supplier), throwable);
        }
    }

    public void debug(Supplier<? extends CharSequence> supplier) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(LogMessage.of(supplier));
        }
    }

    public void debug(Throwable throwable, Supplier<? extends CharSequence> supplier) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(LogMessage.of(supplier), throwable);
        }
    }

    public void trace(Supplier<? extends CharSequence> supplier) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(LogMessage.of(supplier));
        }
    }

    public void trace(Throwable throwable, Supplier<? extends CharSequence> supplier) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(LogMessage.of(supplier), throwable);
        }
    }
}

